/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.ra10;

import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.Icon;
import org.jboss.jca.common.api.metadata.ra.LicenseType;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra10.Connector10;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.metadata.ra.common.ConnectorAbstractmpl;

public final class Connector10Impl
extends ConnectorAbstractmpl
implements Connector10 {
    private static final long serialVersionUID = -6095735191032372517L;
    private final XsdString version;
    private final XsdString specVersion;

    public Connector10Impl(XsdString vendorName, XsdString eisType, XsdString resourceadapterVersion, LicenseType license, ResourceAdapter resourceadapter, List<LocalizedXsdString> description, List<LocalizedXsdString> displayName, List<Icon> icon, String id, XsdString specVersion) {
        super(vendorName, eisType, license, resourceadapter, description, displayName, icon, id);
        this.version = resourceadapterVersion;
        if (!XsdString.isNull((XsdString)this.version)) {
            this.version.setTag(Connector10.Tag.VERSION.toString());
        }
        this.specVersion = specVersion;
        if (!XsdString.isNull((XsdString)this.specVersion)) {
            this.specVersion.setTag(Connector10.Tag.SPEC_VERSION.toString());
        }
    }

    public Connector10Impl(XsdString vendorName, XsdString eisType, XsdString resourceadapterVersion, LicenseType license, ResourceAdapter resourceadapter, List<LocalizedXsdString> description, List<LocalizedXsdString> displayName, List<Icon> icon, String id) {
        this(vendorName, eisType, resourceadapterVersion, license, resourceadapter, description, displayName, icon, id, new XsdString("1.0", null));
    }

    public Connector.Version getVersion() {
        return Connector.Version.V_10;
    }

    public XsdString getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.specVersion == null ? 0 : this.specVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Connector10Impl)) {
            return false;
        }
        Connector10Impl other = (Connector10Impl)obj;
        if (this.version == null ? other.version != null : !this.version.equals((Object)other.version)) {
            return false;
        }
        return !(this.specVersion == null ? other.specVersion != null : !this.specVersion.equals((Object)other.specVersion));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<").append("connector");
        if (this.id != null) {
            sb.append(" " + Connector10.Attribute.ID + "=\"" + this.id + "\"");
        }
        sb.append(">");
        sb.append(super.toString());
        if (!XsdString.isNull((XsdString)this.version)) {
            sb.append(this.version);
        }
        if (!XsdString.isNull((XsdString)this.specVersion)) {
            sb.append(this.specVersion);
        }
        sb.append(this.resourceadapter);
        sb.append("</").append("connector").append(">");
        return sb.toString();
    }

    @Override
    public CopyableMetaData copy() {
        return new Connector10Impl((XsdString)CopyUtil.clone((CopyableMetaData)this.vendorName), (XsdString)CopyUtil.clone((CopyableMetaData)this.eisType), (XsdString)CopyUtil.clone((CopyableMetaData)this.version), (LicenseType)CopyUtil.clone((CopyableMetaData)this.license), (ResourceAdapter)CopyUtil.clone((CopyableMetaData)this.resourceadapter), CopyUtil.cloneList((List)this.description), CopyUtil.cloneList((List)this.displayName), CopyUtil.cloneList((List)this.icon), CopyUtil.cloneString((String)this.id), (XsdString)CopyUtil.clone((CopyableMetaData)this.specVersion));
    }

    @Override
    public Connector merge(MergeableMetadata<?> inputMd) throws Exception {
        if (inputMd instanceof Connector10Impl) {
            Connector10Impl input10 = (Connector10Impl)inputMd;
            XsdString newResourceadapterVersion = XsdString.isNull((XsdString)this.version) ? input10.version : this.version;
            XsdString newEisType = XsdString.isNull((XsdString)this.eisType) ? input10.eisType : this.eisType;
            List newIcons = MergeUtil.mergeList((List)this.icon, (List)input10.icon);
            LicenseType newLicense = this.license == null ? input10.license : this.license.merge((MergeableMetadata)input10.license);
            List newDescriptions = MergeUtil.mergeList((List)this.description, (List)input10.description);
            List newDisplayNames = MergeUtil.mergeList((List)this.displayName, (List)input10.displayName);
            XsdString newVendorName = XsdString.isNull((XsdString)this.vendorName) ? input10.vendorName : this.vendorName;
            ResourceAdapter10 newResourceadapter = this.resourceadapter == null ? (ResourceAdapter10)input10.resourceadapter : (ResourceAdapter10)((ResourceAdapter10)this.resourceadapter).merge((MergeableMetadata)((ResourceAdapter10)input10.resourceadapter));
            return new Connector10Impl(newVendorName, newEisType, newResourceadapterVersion, newLicense, (ResourceAdapter)newResourceadapter, newDescriptions, newDisplayNames, newIcons, null);
        }
        return this;
    }
}

