/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.ra15;

import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.Icon;
import org.jboss.jca.common.api.metadata.ra.LicenseType;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra15.Connector15;
import org.jboss.jca.common.metadata.ra.common.ConnectorAbstractmpl;

public class Connector15Impl
extends ConnectorAbstractmpl
implements Connector15 {
    private static final long serialVersionUID = 531372312218060928L;
    protected final XsdString resourceadapterVersion;

    public Connector15Impl(XsdString vendorName, XsdString eisType, XsdString resourceadapterVersion, LicenseType license, ResourceAdapter1516 resourceadapter, List<LocalizedXsdString> description, List<LocalizedXsdString> displayName, List<Icon> icon, String id) {
        super(vendorName, eisType, license, (ResourceAdapter)resourceadapter, description, displayName, icon, id);
        this.resourceadapterVersion = resourceadapterVersion;
        if (!XsdString.isNull((XsdString)this.resourceadapterVersion)) {
            this.resourceadapterVersion.setTag(Connector15.Tag.RESOURCEADPTER_VERSION.toString());
        }
    }

    public XsdString getResourceadapterVersion() {
        return this.resourceadapterVersion;
    }

    public Connector.Version getVersion() {
        return Connector.Version.V_15;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.resourceadapterVersion == null ? 0 : this.resourceadapterVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Connector15Impl)) {
            return false;
        }
        Connector15Impl other = (Connector15Impl)obj;
        return !(this.resourceadapterVersion == null ? other.resourceadapterVersion != null : !this.resourceadapterVersion.equals((Object)other.resourceadapterVersion));
    }

    protected String defaultPropertiesToString() {
        return super.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<").append("connector");
        sb.append(" " + Connector15.Attribute.VERSION + "=\"1.5\"");
        if (this.id != null) {
            sb.append(" " + Connector15.Attribute.ID + "=\"" + this.id + "\"");
        }
        sb.append(">");
        sb.append(super.toString());
        if (!XsdString.isNull((XsdString)this.resourceadapterVersion)) {
            sb.append(this.resourceadapterVersion);
        }
        sb.append(this.resourceadapter);
        sb.append("</").append("connector").append(">");
        return sb.toString();
    }

    @Override
    public CopyableMetaData copy() {
        return new Connector15Impl((XsdString)CopyUtil.clone((CopyableMetaData)this.vendorName), (XsdString)CopyUtil.clone((CopyableMetaData)this.eisType), (XsdString)CopyUtil.clone((CopyableMetaData)this.resourceadapterVersion), (LicenseType)CopyUtil.clone((CopyableMetaData)this.license), (ResourceAdapter1516)CopyUtil.clone((CopyableMetaData)((ResourceAdapter1516)this.resourceadapter)), CopyUtil.cloneList((List)this.description), CopyUtil.cloneList((List)this.displayName), CopyUtil.cloneList((List)this.icon), CopyUtil.cloneString((String)this.id));
    }

    @Override
    public Connector merge(MergeableMetadata<?> inputMd) throws Exception {
        if (inputMd instanceof Connector15Impl) {
            Connector15Impl input15 = (Connector15Impl)inputMd;
            XsdString newResourceadapterVersion = XsdString.isNull((XsdString)this.resourceadapterVersion) ? input15.resourceadapterVersion : this.resourceadapterVersion;
            XsdString newEisType = XsdString.isNull((XsdString)this.eisType) ? input15.eisType : this.eisType;
            List newIcons = MergeUtil.mergeList((List)this.icon, (List)input15.icon);
            LicenseType newLicense = this.license == null ? input15.license : this.license.merge((MergeableMetadata)input15.license);
            List newDescriptions = MergeUtil.mergeList((List)this.description, (List)input15.description);
            List newDisplayNames = MergeUtil.mergeList((List)this.displayName, (List)input15.displayName);
            XsdString newVendorName = XsdString.isNull((XsdString)this.vendorName) ? input15.vendorName : this.vendorName;
            ResourceAdapter1516 newResourceadapter = this.resourceadapter == null ? (ResourceAdapter1516)input15.resourceadapter : (ResourceAdapter1516)((ResourceAdapter1516)this.resourceadapter).merge((MergeableMetadata)((ResourceAdapter1516)input15.resourceadapter));
            return new Connector15Impl(newVendorName, newEisType, newResourceadapterVersion, newLicense, newResourceadapter, newDescriptions, newDisplayNames, newIcons, null);
        }
        return this;
    }
}

