/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.net;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext createSecurityContext(final Principal p, final Object cred, final Subject s, final String domainName) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)s, (String)domainName);
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static String getClientSecurityDomain() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("org.jboss.security.negotiation.default.client.security.domain", "com.sun.security.jgss.krb5.initiate");
            }
        });
    }

    static String getServerName() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("org.jboss.security.negotiation.server.principal");
            }
        });
    }
}

