/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.locators.cache.CacheLocator;
import org.jboss.security.xacml.sunxacml.ctx.Attribute;
import org.jboss.security.xacml.sunxacml.ctx.RequestCtx;
import org.jboss.security.xacml.sunxacml.ctx.ResponseCtx;
import org.jboss.security.xacml.sunxacml.ctx.Subject;
import org.jboss.security.xacml.util.JBossXACMLUtil;

public class DecisionCacheLocator
extends CacheLocator {
    private static Logger log = Logger.getLogger(DecisionCacheLocator.class.getCanonicalName());
    protected WeakHashMap<RequestCtx, ResponseCtx> correctnessDecisionMap = null;
    protected LinkedHashMap<RequestCtx, ResponseCtx> speedDecisionMap = null;
    public static final String IGNORE_SUBJECT_ID = "ignoreSubjectID";
    public static final String IGNORE_RESOURCE_ID = "ignoreResourceID";
    public static final String IGNORE_ACTION_ID = "ignoreActionID";
    public static final String IGNORE_ENVIRONMENT_ID = "ignoreEnvironmentID";
    public static final String ENHANCE_SPEED = "enhanceSpeed";
    public static final String INITIAL_CAPACITY = "initialCapacity";
    public static final String LOAD_FACTOR = "loadFactor";

    public void add(RequestCtx request, ResponseCtx response) {
        RequestCtx cacheRequest = this.preprocessRequest(request);
        if (this.needCorrectness()) {
            this.validateCorrectnessMap();
            this.correctnessDecisionMap.put(cacheRequest, response);
        } else {
            this.validateSpeedMap();
            this.speedDecisionMap.put(cacheRequest, response);
        }
    }

    @Override
    public ResponseCtx get(RequestCtx request) {
        int speedSize;
        RequestCtx cacheRequest = this.preprocessRequest(request);
        ResponseCtx response = null;
        int correctnessSize = this.correctnessDecisionMap != null ? this.correctnessDecisionMap.size() : 0;
        int n = speedSize = this.speedDecisionMap != null ? this.speedDecisionMap.size() : 0;
        if (this.needCorrectness()) {
            this.validateCorrectnessMap();
            response = this.correctnessDecisionMap.get(cacheRequest);
        } else {
            this.validateSpeedMap();
            response = this.speedDecisionMap.get(cacheRequest);
        }
        if (response == null) {
            log.log(Level.FINEST, "Cache Miss with " + this.toString() + " correctness size=" + correctnessSize + " speed size=" + speedSize);
        }
        return response;
    }

    private RequestCtx preprocessRequest(RequestCtx request) {
        ArrayList<String> subjectID = new ArrayList<String>();
        ArrayList<String> resourceID = new ArrayList<String>();
        ArrayList<String> actionID = new ArrayList<String>();
        ArrayList<String> envID = new ArrayList<String>();
        String ignoreSubjectOption = (String)this.optionMap.get(IGNORE_SUBJECT_ID);
        String ignoreResourceOption = (String)this.optionMap.get(IGNORE_RESOURCE_ID);
        String ignoreActionOption = (String)this.optionMap.get(IGNORE_ACTION_ID);
        String ignoreEnvOption = (String)this.optionMap.get(IGNORE_ENVIRONMENT_ID);
        subjectID.addAll(JBossXACMLUtil.getTokenList(ignoreSubjectOption));
        resourceID.addAll(JBossXACMLUtil.getTokenList(ignoreResourceOption));
        actionID.addAll(JBossXACMLUtil.getTokenList(ignoreActionOption));
        envID.addAll(JBossXACMLUtil.getTokenList(ignoreEnvOption));
        return DecisionCacheLocatorRequest.from(request, subjectID, resourceID, actionID, envID);
    }

    private boolean needCorrectness() {
        boolean correctness = false;
        String correct = (String)this.optionMap.get(ENHANCE_SPEED);
        if (correct != null && "false".equalsIgnoreCase(correct)) {
            correctness = true;
        }
        return correctness;
    }

    private void validateCorrectnessMap() {
        if (this.correctnessDecisionMap == null) {
            int initialCapacity = this.getInitialCapacity();
            float loadFactor = this.getLoadFactor();
            this.correctnessDecisionMap = new WeakHashMap(initialCapacity, loadFactor);
        }
    }

    private void validateSpeedMap() {
        if (this.speedDecisionMap == null) {
            int initialCapacity = this.getInitialCapacity();
            float loadFactor = this.getLoadFactor();
            this.speedDecisionMap = new LinkedHashMap(initialCapacity, loadFactor, true);
        }
    }

    private int getInitialCapacity() {
        int initialCapacity = 100;
        String initialCapacityStr = (String)this.optionMap.get(INITIAL_CAPACITY);
        if (initialCapacityStr != null && initialCapacityStr != "") {
            initialCapacity = Integer.parseInt(initialCapacityStr);
        }
        return initialCapacity;
    }

    private float getLoadFactor() {
        float loadFactor = 0.75f;
        String loadFactorStr = (String)this.optionMap.get(LOAD_FACTOR);
        if (loadFactorStr != null && loadFactorStr != "") {
            loadFactor = Float.parseFloat(loadFactorStr);
        }
        return loadFactor;
    }

    public static class DecisionCacheLocatorRequest
    extends RequestCtx {
        public DecisionCacheLocatorRequest(List subjects, List resource, List action, List environment) {
            super(subjects, resource, action, environment);
        }

        public static RequestCtx from(RequestCtx request, List<String> ignoreSubjectIDs, List<String> ignoreResourceIDs, List<String> ignoreActionIDs, List<String> ignoreEnvIDs) {
            List requestSubject = request.getSubjectsAsList();
            if (ignoreSubjectIDs != null) {
                requestSubject = DecisionCacheLocatorRequest.processSubject(requestSubject, ignoreSubjectIDs);
            }
            List requestResource = request.getResourceAsList();
            if (ignoreResourceIDs != null) {
                requestResource = DecisionCacheLocatorRequest.processAttributes(requestResource, ignoreResourceIDs);
            }
            List requestAction = request.getActionAsList();
            if (ignoreActionIDs != null) {
                requestAction = DecisionCacheLocatorRequest.processAttributes(requestAction, ignoreActionIDs);
            }
            List requestEnvironment = request.getEnvironmentAttributesAsList();
            if (ignoreEnvIDs != null) {
                requestEnvironment = DecisionCacheLocatorRequest.processAttributes(requestEnvironment, ignoreEnvIDs);
            }
            DecisionCacheLocatorRequest myRequest = new DecisionCacheLocatorRequest(requestSubject, requestResource, requestAction, requestEnvironment);
            return myRequest;
        }

        private static List processSubject(List origSet, List<String> ignoreIDs) {
            Iterator envIter;
            ArrayList<Subject> resultSet = new ArrayList<Subject>();
            Iterator iterator = envIter = origSet != null ? origSet.iterator() : null;
            while (envIter != null && envIter.hasNext()) {
                Subject subject = (Subject)envIter.next();
                List attributes = subject.getAttributesAsList();
                attributes = DecisionCacheLocatorRequest.processAttributes(attributes, ignoreIDs);
                Subject newSubject = new Subject(attributes);
                resultSet.add(newSubject);
            }
            return resultSet;
        }

        private static List processAttributes(List origSet, List<String> ignoreIDs) {
            Iterator envIter;
            ArrayList<Attribute> resultSet = new ArrayList<Attribute>();
            Iterator iterator = envIter = origSet != null ? origSet.iterator() : null;
            while (envIter != null && envIter.hasNext()) {
                Attribute iterObject = (Attribute)envIter.next();
                String id = iterObject.getId().toASCIIString();
                if (ignoreIDs.contains(id)) continue;
                resultSet.add(iterObject);
            }
            return resultSet;
        }
    }
}

