/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.combine;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.jboss.security.xacml.sunxacml.ctx.Status;

public class PermitOverridesPolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides";
    private static URI identifierURI = URI.create("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides");

    public PermitOverridesPolicyAlg() {
        super(identifierURI);
    }

    protected PermitOverridesPolicyAlg(URI identifier) {
        super(identifier);
    }

    @Override
    public Result combine(EvaluationCtx context, List parameters, List policyElements) {
        boolean atLeastOneError = false;
        boolean atLeastOneDeny = false;
        HashSet denyObligations = new HashSet();
        Status firstIndeterminateStatus = null;
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2) {
                atLeastOneError = true;
                if (firstIndeterminateStatus != null) continue;
                firstIndeterminateStatus = match.getStatus();
                continue;
            }
            if (match.getResult() != 0) continue;
            Result result = policy.evaluate(context);
            int effect = result.getDecision();
            if (effect == 0) {
                return result;
            }
            if (effect == 1) {
                atLeastOneDeny = true;
                denyObligations.addAll(result.getObligations());
                continue;
            }
            if (effect != 2) continue;
            atLeastOneError = true;
            if (firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (atLeastOneDeny) {
            return new Result(1, context.getResourceId().encode(), denyObligations);
        }
        if (atLeastOneError) {
            return new Result(2, firstIndeterminateStatus, context.getResourceId().encode());
        }
        return new Result(3, context.getResourceId().encode());
    }
}

