/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.finder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FilePolicyModule
extends PolicyFinderModule
implements ErrorHandler {
    public static final String POLICY_SCHEMA_PROPERTY = "com.sun.xacml.PolicySchema";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private PolicyFinder finder;
    private File schemaFile;
    private Set fileNames = new HashSet();
    private Set policies = new HashSet();
    private static final Logger logger = Logger.getLogger(FilePolicyModule.class.getName());

    public FilePolicyModule() {
        String schemaName = System.getProperty(POLICY_SCHEMA_PROPERTY);
        this.schemaFile = schemaName == null ? null : new File(schemaName);
    }

    public FilePolicyModule(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public FilePolicyModule(List fileNames) {
        this();
        if (fileNames != null) {
            this.fileNames.addAll(fileNames);
        }
    }

    @Override
    public boolean isRequestSupported() {
        return true;
    }

    @Override
    public void init(PolicyFinder finder) {
        this.finder = finder;
        for (String fname : this.fileNames) {
            AbstractPolicy policy = FilePolicyModule.loadPolicy(fname, finder, this.schemaFile, this);
            if (policy == null) continue;
            this.policies.add(policy);
        }
    }

    public boolean addPolicy(String filename) {
        return this.fileNames.add(filename);
    }

    public static AbstractPolicy loadPolicy(String filename, PolicyFinder finder) {
        return FilePolicyModule.loadPolicy(filename, finder, null, null);
    }

    public static AbstractPolicy loadPolicy(String filename, PolicyFinder finder, File schemaFile, ErrorHandler handler) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            DocumentBuilder db = null;
            factory.setNamespaceAware(true);
            if (schemaFile == null) {
                factory.setValidating(false);
                db = factory.newDocumentBuilder();
            } else {
                factory.setValidating(true);
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                factory.setAttribute(JAXP_SCHEMA_SOURCE, schemaFile);
                db = factory.newDocumentBuilder();
                db.setErrorHandler(handler);
            }
            Document doc = db.parse(new FileInputStream(filename));
            Element root = doc.getDocumentElement();
            String name = root.getTagName();
            if (name.equals("Policy")) {
                return Policy.getInstance(root);
            }
            if (name.equals("PolicySet")) {
                return PolicySet.getInstance(root, finder);
            }
            throw new Exception("Unknown root document type: " + name);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error reading policy from file " + filename, e);
            }
            return null;
        }
    }

    @Override
    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        AbstractPolicy selectedPolicy = null;
        for (AbstractPolicy policy : this.policies) {
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                return new PolicyFinderResult(match.getStatus());
            }
            if (result != 0) continue;
            if (selectedPolicy != null) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicy = policy;
        }
        if (selectedPolicy != null) {
            return new PolicyFinderResult(selectedPolicy);
        }
        return new PolicyFinderResult();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Warning on line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("error parsing policy");
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Fatal error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("fatal error parsing policy");
    }
}

