/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support.finder;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyCollection;
import org.jboss.security.xacml.sunxacml.support.finder.TopLevelPolicyException;

public class BasicPolicyFinderModule
extends PolicyFinderModule {
    private PolicyCollection ctxPolicies;
    private PolicyCollection refPolicies;
    private PolicyCombiningAlgorithm combiningAlg;
    private static final String POLICY_ID = "urn:com:sun:xacml:support:finder:dynamic-policy-set";
    private static URI policyId;
    private static final Logger logger;

    public BasicPolicyFinderModule() {
        this.ctxPolicies = new PolicyCollection();
        this.refPolicies = new PolicyCollection();
    }

    public BasicPolicyFinderModule(PolicyCombiningAlgorithm combiningAlg) {
        this.ctxPolicies = new PolicyCollection(combiningAlg, policyId);
        this.refPolicies = new PolicyCollection(combiningAlg, policyId);
    }

    public synchronized boolean addPolicy(AbstractPolicy policy) {
        if (this.ctxPolicies.addPolicy(policy)) {
            return this.refPolicies.addPolicy(policy);
        }
        return false;
    }

    public synchronized boolean addPolicyNoRef(AbstractPolicy policy) {
        return this.ctxPolicies.addPolicy(policy);
    }

    public synchronized boolean addPolicyOnlyRef(AbstractPolicy policy) {
        return this.refPolicies.addPolicy(policy);
    }

    @Override
    public boolean isRequestSupported() {
        return true;
    }

    @Override
    public boolean isIdReferenceSupported() {
        return true;
    }

    @Override
    public void init(PolicyFinder finder) {
    }

    @Override
    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy = this.ctxPolicies.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
    }

    @Override
    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        AbstractPolicy policy = this.refPolicies.getPolicy(idReference.toString(), type, constraints);
        if (policy == null) {
            return new PolicyFinderResult();
        }
        return new PolicyFinderResult(policy);
    }

    static {
        block2: {
            policyId = null;
            logger = Logger.getLogger(BasicPolicyFinderModule.class.getName());
            try {
                policyId = new URI(POLICY_ID);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(Level.SEVERE, "couldn't assign default policy id");
            }
        }
    }
}

