/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AbstractPosition;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;
import org.xml.sax.Attributes;

public class ElementPosition
extends AbstractPosition {
    private TypeBinding type = ((ElementBinding)this.term).getType();
    private ParticleBinding nonXsiParticle;
    private boolean ignoreCharacters;
    private StringBuffer textContent;
    private Boolean indentation;
    private boolean ignorableCharacters = true;
    private Object[] interceptorObjects;

    public ElementPosition(QName qName, ParticleBinding particle) {
        super(qName, particle);
    }

    @Override
    public boolean isElement() {
        return true;
    }

    public void reset() {
        if (!this.ended) {
            throw new JBossXBRuntimeException("Attempt to reset a particle that has already been reset: " + this.term);
        }
        this.ended = false;
        this.o = null;
        if (this.textContent != null) {
            this.textContent.setLength(0);
        }
        this.indentation = null;
        this.ignorableCharacters = true;
        if (this.nonXsiParticle != null) {
            this.particle = this.nonXsiParticle;
            this.term = this.particle.getTerm();
            this.type = ((ElementBinding)this.term).getType();
        }
    }

    public ParticleBinding getNonXsiParticle() {
        return this.nonXsiParticle;
    }

    public void setNonXsiParticle(ParticleBinding nonXsiParticle) {
        this.nonXsiParticle = nonXsiParticle;
    }

    public boolean isIgnoreCharacters() {
        return this.ignoreCharacters;
    }

    public void setIgnoreCharacters(boolean ignoreCharacters) {
        this.ignoreCharacters = ignoreCharacters;
    }

    public StringBuffer getTextContent() {
        return this.textContent;
    }

    @Override
    public AbstractPosition nextPosition(QName startName, Attributes atts) {
        ModelGroupBinding modelGroup;
        if (this.ended) {
            if (!this.qName.equals(startName)) {
                if (this.repeatableParticleValue != null) {
                    this.endRepeatableParticle();
                }
                return null;
            }
            if (this.particle.isRepeatable()) {
                if (this.particle.isOccurrenceAllowed(this.occurrence + 1)) {
                    this.reset();
                    ++this.occurrence;
                    return this;
                }
                if (this.repeatableParticleValue != null) {
                    this.endRepeatableParticle();
                }
                return null;
            }
            this.reset();
            this.previous.repeatForChild(atts);
            this.occurrence = 1;
            if (this.next != null) {
                this.next.previous = null;
                this.next = null;
            }
            return this;
        }
        ParticleBinding typeParticle = this.type.getParticle();
        ModelGroupBinding modelGroupBinding = modelGroup = typeParticle == null ? null : (ModelGroupBinding)typeParticle.getTerm();
        if (modelGroup == null) {
            if (startName.equals(Constants.QNAME_XOP_INCLUDE)) {
                SchemaBinding schema = this.term.getSchema();
                TypeBinding anyUriType = schema.getType(Constants.QNAME_ANYURI);
                if (anyUriType == null) {
                    log.warn((Object)("Type " + Constants.QNAME_ANYURI + " not bound."));
                }
                ElementBinding element = (ElementBinding)this.term;
                element.setXopUnmarshaller(schema.getXopUnmarshaller());
                this.flushIgnorableCharacters();
                this.handler = DefaultHandlers.XOP_HANDLER;
                this.ignoreCharacters = true;
                this.initValue(null);
                TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
                xopIncludeType.setSchemaBinding(schema);
                xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
                xopIncludeType.setHandler(new XOPIncludeHandler(this.type, schema.getXopUnmarshaller()));
                ElementBinding xopInclude = new ElementBinding(schema, Constants.QNAME_XOP_INCLUDE, xopIncludeType);
                this.next = new ElementPosition(startName, new ParticleBinding(xopInclude));
                this.next.stack = this.stack;
                this.next.previous = this;
                this.next.notSkippedParent = this.getLastNotSkipped();
                return this.next;
            }
            QName typeName = this.type.getQName();
            throw new JBossXBRuntimeException((typeName == null ? "Anonymous" : typeName.toString()) + " type of element " + this.qName + " should be complex and contain " + startName + " as a child element.");
        }
        if (this.next != null && !this.particle.isOccurrenceAllowed(++this.occurrence)) {
            throw new JBossXBRuntimeException(startName + " cannot appear in this position. Expected content of " + this.qName + " is " + modelGroup);
        }
        this.next = modelGroup.newPosition(startName, atts, typeParticle);
        if (this.next == null) {
            throw new JBossXBRuntimeException(startName + " not found as a child of " + this.qName + " in " + modelGroup);
        }
        this.next.previous = this;
        this.flushIgnorableCharacters();
        AbstractPosition nextPosition = this.next;
        while (nextPosition.next != null) {
            nextPosition.notSkippedParent = nextPosition.previous.getLastNotSkipped();
            if (nextPosition.repeatableHandler != null) {
                nextPosition.startRepeatableParticle();
            }
            nextPosition.stack = this.stack;
            nextPosition.initValue(atts);
            nextPosition.parentType = this.type;
            nextPosition = nextPosition.next;
        }
        nextPosition.stack = this.stack;
        nextPosition.parentType = this.type;
        nextPosition.notSkippedParent = nextPosition.previous.getLastNotSkipped();
        return (ElementPosition)nextPosition;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.type.isTextContentAllowed()) {
            return;
        }
        if (this.indentation != Boolean.FALSE) {
            if (this.type.isSimple()) {
                this.indentation = Boolean.FALSE;
                this.ignorableCharacters = false;
            } else if (this.term.getSchema() != null && !this.term.getSchema().isIgnoreWhitespacesInMixedContent()) {
                this.indentation = Boolean.FALSE;
                this.ignorableCharacters = false;
            } else {
                for (int i = start; i < start + length; ++i) {
                    if (ch[i] == '\n') {
                        this.indentation = Boolean.TRUE;
                        continue;
                    }
                    if (Character.isWhitespace(ch[i])) continue;
                    this.indentation = Boolean.FALSE;
                    this.ignorableCharacters = false;
                    break;
                }
            }
        }
        if (this.textContent == null) {
            this.textContent = new StringBuffer();
        }
        this.textContent.append(ch, start, length);
    }

    @Override
    public void endParticle() {
        ElementInterceptor interceptor;
        this.ended = true;
        ElementBinding element = (ElementBinding)this.term;
        List<ElementInterceptor> interceptors = null;
        List localInterceptors = null;
        if (this.interceptorObjects != null) {
            interceptors = element.getInterceptors();
            List<Object> list = localInterceptors = this.parentType == null ? Collections.emptyList() : this.parentType.getInterceptors(this.qName);
        }
        if (this.o != SundayContentHandler.NIL) {
            String textContent;
            this.flushIgnorableCharacters();
            TypeBinding charType = this.type.getSimpleType();
            if (charType == null) {
                charType = this.type;
            }
            CharactersHandler charHandler = this.ignoreCharacters ? null : charType.getCharactersHandler();
            String string = textContent = this.textContent == null ? "" : this.textContent.toString();
            if (textContent.length() > 0 || charHandler != null && !this.type.isIgnoreEmptyString()) {
                Object unmarshalled;
                String dataContent;
                SchemaBinding schema = this.term.getSchema();
                if (textContent.length() == 0) {
                    dataContent = null;
                } else {
                    dataContent = textContent;
                    if (schema != null && schema.isReplacePropertyRefs()) {
                        dataContent = StringPropertyReplacer.replaceProperties((String)dataContent);
                    }
                    if (element.isNormalizeSpace()) {
                        dataContent = dataContent.trim();
                    }
                }
                if (charHandler == null) {
                    if (!this.type.isSimple() && !this.term.isSkip() && schema != null && schema.isStrictSchema()) {
                        throw new JBossXBRuntimeException("Element " + this.qName + " with type binding " + this.type.getQName() + " does not include text content binding: " + dataContent);
                    }
                    unmarshalled = dataContent;
                } else {
                    CharactersMetaData charactersMetaData;
                    ValueMetaData valueMetaData = this.term.getValueMetaData();
                    if (valueMetaData == null && (charactersMetaData = this.type.getCharactersMetaData()) != null) {
                        valueMetaData = charactersMetaData.getValue();
                    }
                    Object object = unmarshalled = dataContent == null ? charHandler.unmarshalEmpty(this.qName, charType, this.stack.getNamespaceRegistry(), valueMetaData) : charHandler.unmarshal(this.qName, charType, this.stack.getNamespaceRegistry(), valueMetaData, dataContent);
                }
                if (unmarshalled != null) {
                    if (this.o == null) {
                        this.o = unmarshalled;
                    } else if (charHandler != null) {
                        TermBeforeSetParentCallback beforeSetParent = charType.getBeforeSetParentCallback();
                        if (beforeSetParent != null) {
                            SundayContentHandler.UnmarshallingContextImpl ctx = this.stack.getContext();
                            ctx.parent = this.o;
                            ctx.particle = this.particle;
                            ctx.parentParticle = this.notSkippedParent.particle;
                            unmarshalled = beforeSetParent.beforeSetParent(unmarshalled, ctx);
                            ctx.clear();
                        }
                        charHandler.setValue(this.qName, element, this.o, unmarshalled);
                    }
                }
                if (this.interceptorObjects != null) {
                    ElementInterceptor interceptor2;
                    int i;
                    NamespaceRegistry nsRegistry = this.stack.getNamespaceRegistry();
                    int ioIndex = 0;
                    for (i = interceptors.size() - 1; i >= 0; --i) {
                        interceptor2 = interceptors.get(i);
                        interceptor2.characters(this.interceptorObjects[ioIndex++], this.qName, this.type, nsRegistry, dataContent);
                    }
                    for (i = localInterceptors.size() - 1; i >= 0; --i) {
                        interceptor2 = (ElementInterceptor)localInterceptors.get(i);
                        interceptor2.characters(this.interceptorObjects[ioIndex++], this.qName, this.type, nsRegistry, dataContent);
                    }
                }
            }
        } else {
            this.o = null;
        }
        if (this.skip) {
            return;
        }
        this.o = this.handler.endParticle(this.o, this.qName, this.particle);
        if (this.interceptorObjects != null && !interceptors.isEmpty()) {
            int ioIndex = 0;
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                interceptor = interceptors.get(i);
                this.interceptorObjects[ioIndex] = interceptor.endElement(this.interceptorObjects[ioIndex++], this.qName, this.type);
            }
        }
        if (this.interceptorObjects != null) {
            Object parent;
            int i;
            int ioIndex = 0;
            for (i = interceptors.size() - 1; i >= 0; --i) {
                interceptor = interceptors.get(i);
                parent = this.interceptorObjects[ioIndex++];
                interceptor.add(parent, this.o, this.qName);
                this.o = parent;
            }
            for (i = localInterceptors.size() - 1; i >= 0; --i) {
                interceptor = (ElementInterceptor)localInterceptors.get(i);
                parent = this.interceptorObjects[ioIndex++];
                interceptor.add(parent, this.o, this.qName);
                this.o = parent;
            }
        } else if (this.notSkippedParent != null) {
            if (this.notSkippedParent.o != null) {
                ParticleHandler wh;
                ParticleHandler handler = this.handler;
                if (this.notSkippedParent.term.isWildcard() && (wh = ((WildcardBinding)this.notSkippedParent.term).getWildcardHandler()) != null) {
                    handler = wh;
                }
                this.setParent(this.notSkippedParent, handler);
            } else if (this.notSkippedParent.term.isWildcard()) {
                AbstractPosition parentPos = this.previous;
                parentPos.o = this.o;
                while (!parentPos.isElement()) {
                    parentPos = parentPos.getPrevious();
                    parentPos.o = this.o;
                }
                if (trace) {
                    log.trace((Object)("Value of " + this.qName + " " + this.o + " is promoted as the value of its parent element."));
                }
            }
        }
    }

    @Override
    public ElementPosition startParticle(QName startName, Attributes atts) {
        return (ElementPosition)this.nextPosition(startName, atts);
    }

    @Override
    public void repeatForChild(Attributes atts) {
        throw new JBossXBRuntimeException("Failed to repeat parent for non-repeatable element: repeatable parent expected to be a model group but got element " + this.qName);
    }

    public void push(Attributes atts) {
        List<ElementInterceptor> interceptors;
        String xsiType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (xsiType != null) {
            String xsiTypeLocal;
            String xsiTypePrefix;
            int colon;
            if (trace) {
                log.trace((Object)(this.term.getQName() + " uses xsi:type " + xsiType));
            }
            if (this.nonXsiParticle == null) {
                this.nonXsiParticle = this.particle;
            }
            if ((colon = xsiType.indexOf(58)) == -1) {
                xsiTypePrefix = "";
                xsiTypeLocal = xsiType;
            } else {
                xsiTypePrefix = xsiType.substring(0, colon);
                xsiTypeLocal = xsiType.substring(colon + 1);
            }
            String xsiTypeNs = this.stack.getNamespaceRegistry().getNamespaceURI(xsiTypePrefix);
            QName xsiTypeQName = new QName(xsiTypeNs, xsiTypeLocal);
            SchemaBinding schemaBinding = this.term.getSchema();
            TypeBinding xsiTypeBinding = schemaBinding.getType(xsiTypeQName);
            if (xsiTypeBinding == null) {
                throw new JBossXBRuntimeException("Type binding not found for type " + xsiTypeQName + " specified with xsi:type for element " + this.qName);
            }
            ElementBinding xsiElement = new ElementBinding(schemaBinding, this.qName, xsiTypeBinding);
            xsiElement.setRepeatableHandler(this.term.getRepeatableHandler());
            this.particle = new ParticleBinding(xsiElement, this.particle.getMinOccurs(), this.particle.getMaxOccurs(), this.particle.getMaxOccursUnbounded());
            this.term = xsiElement;
            this.type = xsiTypeBinding;
        }
        if (this.occurrence == 1 && this.repeatableHandler != null) {
            this.startRepeatableParticle();
        }
        Object parent = this.previous == null ? null : this.previous.o;
        ElementBinding element = (ElementBinding)this.term;
        if (this.parentType != null && !(interceptors = this.parentType.getInterceptors(this.qName)).isEmpty()) {
            NamespaceRegistry nsRegistry = this.stack.getNamespaceRegistry();
            this.interceptorObjects = new Object[interceptors.size() + element.getInterceptors().size()];
            int ioIndex = this.interceptorObjects.length - 1;
            for (ElementInterceptor i : interceptors) {
                parent = i.startElement(parent, this.qName, this.type);
                i.attributes(parent, this.qName, this.type, atts, nsRegistry);
                this.interceptorObjects[ioIndex--] = parent;
            }
        }
        if (!element.getInterceptors().isEmpty()) {
            int ioIndex;
            NamespaceRegistry nsRegistry = this.stack.getNamespaceRegistry();
            if (this.interceptorObjects == null) {
                this.interceptorObjects = new Object[element.getInterceptors().size()];
                ioIndex = this.interceptorObjects.length - 1;
            } else {
                ioIndex = element.getInterceptors().size() - 1;
            }
            for (ElementInterceptor i : element.getInterceptors()) {
                parent = i.startElement(parent, this.qName, this.type);
                i.attributes(parent, this.qName, this.type, atts, nsRegistry);
                this.interceptorObjects[ioIndex--] = parent;
            }
        }
        if (element.isNillable()) {
            String nil = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            if (nil == null || !"1".equals(nil) && !"true".equals(nil)) {
                this.initValue(atts);
            } else {
                this.o = SundayContentHandler.NIL;
            }
        } else {
            this.initValue(atts);
        }
    }

    private void flushIgnorableCharacters() {
        if (this.textContent == null) {
            return;
        }
        if (this.indentation == Boolean.TRUE || this.ignorableCharacters) {
            if (trace) {
                log.trace((Object)("ignored characters: " + this.term.getQName() + " '" + this.textContent + "'"));
            }
            this.textContent = null;
            this.indentation = null;
        }
    }
}

