/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.resolver.MutableSchemaResolverWithQNameMapping;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaResolverConfigMBean;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class SchemaResolverConfig
implements SchemaResolverConfigMBean {
    private static final Logger log = Logger.getLogger(SchemaResolverConfig.class);
    protected static MutableSchemaResolverWithQNameMapping resolver = (MutableSchemaResolverWithQNameMapping)SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    protected Properties schemaInitializers;
    protected Map<String, SchemaBindingInitializer> schemaInitializerInstances;
    protected Properties schemaLocations;
    protected Properties parseAnnotations;
    protected Properties bindingClasses;
    protected Properties bindingClassesByLocation;

    @Override
    public boolean getCacheResolvedSchemas() {
        return resolver.isCacheResolvedSchemas();
    }

    @Override
    public void setCacheResolvedSchemas(boolean flag) {
        resolver.setCacheResolvedSchemas(flag);
    }

    @Override
    public Properties getSchemaInitializers() {
        return this.schemaInitializers;
    }

    @Override
    public void setSchemaInitializers(Properties schemaInitializers) {
        this.schemaInitializers = schemaInitializers;
        if (schemaInitializers != null && schemaInitializers.size() != 0) {
            for (Map.Entry<Object, Object> entry : schemaInitializers.entrySet()) {
                String namespace = (String)entry.getKey();
                String initializer = (String)entry.getValue();
                try {
                    resolver.mapSchemaInitializer(namespace, initializer);
                }
                catch (Exception ignored) {
                    log.debug((Object)"Ignored: ", (Throwable)ignored);
                }
            }
        }
    }

    @Override
    public Map<String, SchemaBindingInitializer> getSchemaInitializerInstances() {
        return this.schemaInitializerInstances;
    }

    @Override
    public void setSchemaInitializerInstances(Map<String, SchemaBindingInitializer> schemaInitializers) {
        this.schemaInitializerInstances = schemaInitializers;
        if (schemaInitializers != null && schemaInitializers.size() != 0) {
            for (Map.Entry<String, SchemaBindingInitializer> entry : schemaInitializers.entrySet()) {
                String namespace = entry.getKey();
                SchemaBindingInitializer initializer = entry.getValue();
                try {
                    resolver.mapSchemaInitializer(namespace, initializer);
                }
                catch (Exception ignored) {
                    log.debug((Object)"Ignored: ", (Throwable)ignored);
                }
            }
        }
    }

    @Override
    public Properties getSchemaLocations() {
        return this.schemaLocations;
    }

    @Override
    public void setSchemaLocations(Properties schemaLocations) {
        this.schemaLocations = schemaLocations;
        if (schemaLocations != null && schemaLocations.size() != 0) {
            for (Map.Entry<Object, Object> entry : schemaLocations.entrySet()) {
                String namespace = (String)entry.getKey();
                String location = (String)entry.getValue();
                resolver.mapSchemaLocation(namespace, location);
            }
        }
    }

    @Override
    public Properties getParseAnnotations() {
        return this.parseAnnotations;
    }

    @Override
    public void setParseAnnotations(Properties parseAnnotations) {
        this.parseAnnotations = parseAnnotations;
        if (parseAnnotations != null && parseAnnotations.size() != 0) {
            for (Map.Entry<Object, Object> entry : parseAnnotations.entrySet()) {
                String namespace = (String)entry.getKey();
                String value = (String)entry.getValue();
                Boolean booleanValue = Boolean.valueOf(value);
                if (booleanValue == null) continue;
                resolver.setParseXSDAnnotations(namespace, booleanValue);
            }
        }
    }

    @Override
    public Properties getBindingClassesByLocations() {
        return this.bindingClassesByLocation;
    }

    @Override
    public void setBindingClassesByLocations(Properties bindingClassesByLocation) {
        this.bindingClassesByLocation = bindingClassesByLocation;
        if (bindingClassesByLocation != null && bindingClassesByLocation.size() != 0) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (Map.Entry<Object, Object> entry : bindingClassesByLocation.entrySet()) {
                String schemaLocation = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    Class<?> clazz = loader.loadClass(value);
                    resolver.mapLocationToClass(schemaLocation, clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed to load class: " + value), (Throwable)e);
                }
            }
        }
    }

    @Override
    public Properties getBindingClasses() {
        return this.bindingClasses;
    }

    @Override
    public void setBindingClasses(Properties bindingClasses) {
        this.bindingClasses = bindingClasses;
        if (bindingClasses != null && bindingClasses.size() != 0) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (Map.Entry<Object, Object> entry : bindingClasses.entrySet()) {
                String namespace = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    Class<?> clazz = loader.loadClass(value);
                    resolver.mapURIToClass(namespace, clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed to load class: " + value), (Throwable)e);
                }
            }
        }
    }

    public void setBindingClassesByElementNames(Map<QName, String> bindingClassesByElementName) {
        if (bindingClassesByElementName != null && bindingClassesByElementName.size() != 0) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (Map.Entry<QName, String> entry : bindingClassesByElementName.entrySet()) {
                try {
                    Class<?> clazz = loader.loadClass(entry.getValue());
                    resolver.mapQNameToClasses(entry.getKey(), clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed to load class: " + entry.getValue()), (Throwable)e);
                }
            }
        }
    }
}

