/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.util.OsConstraint;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Pack
implements Serializable {
    static final long serialVersionUID = -5458360562175088671L;
    private boolean hidden;
    public boolean loose;
    public boolean uninstall;
    public String name;
    public String id;
    public Set<String> installGroups = new HashSet<String>();
    public String excludeGroup = "";
    public String group;
    public String description;
    public List<OsConstraint> osConstraints = null;
    private String condition;
    public List<String> dependencies = null;
    public List<String> revDependencies = null;
    public String[] onSelect = null;
    public String[] onDeselect = null;
    public boolean required;
    public boolean selectable;
    public long nbytes;
    public String overrideSize = "";
    public boolean preselected;
    public String parent;
    public int color;
    public String packImgId;
    private List<String> validators = new ArrayList<String>();
    public static final int WHITE = 0;
    public static final int GREY = 1;
    public static final int BLACK = 2;
    public int fileCount = 0;
    public int longestPath = 0;
    private static final double KILOBYTES = 1024.0;
    private static final double MEGABYTES = 1048576.0;
    private static final double GIGABYTES = 1.073741824E9;
    private static final DecimalFormat formatter = new DecimalFormat("#,###.##");

    public Pack(String name, String id, String description, List<OsConstraint> osConstraints, List<String> dependencies, boolean required, boolean preselected, boolean loose, String excludegroup, boolean uninstall) {
        this.name = name;
        this.id = id;
        this.description = description;
        this.osConstraints = osConstraints;
        this.dependencies = dependencies;
        this.required = required;
        this.selectable = true;
        this.preselected = preselected;
        this.loose = loose;
        this.excludeGroup = excludegroup;
        this.uninstall = uninstall;
        this.packImgId = null;
        this.condition = null;
        this.nbytes = 0L;
        this.color = 0;
    }

    public String toString() {
        return this.name + " (" + this.description + ")";
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void addRevDep(String name0) {
        if (this.revDependencies == null) {
            this.revDependencies = new ArrayList<String>();
        }
        this.revDependencies.add(name0);
    }

    public String depString() {
        String name0;
        String text = "";
        if (this.dependencies == null) {
            return text;
        }
        for (int i = 0; i < this.dependencies.size() - 1; ++i) {
            name0 = this.dependencies.get(i);
            text = text + name0 + ",";
        }
        name0 = this.dependencies.get(this.dependencies.size() - 1);
        text = text + name0;
        return text;
    }

    public static String toByteUnitsString(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(bytes) + " B";
        }
        if ((double)bytes < 1048576.0) {
            double value = (double)bytes / 1024.0;
            return formatter.format(value) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            double value = (double)bytes / 1048576.0;
            return formatter.format(value) + " MB";
        }
        double value = (double)bytes / 1.073741824E9;
        return formatter.format(value) + " GB";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public void addValidator(String validatorClassName) {
        this.validators.add(validatorClassName);
    }

    public List<String> getValidators() {
        return this.validators;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void incFileCount() {
        ++this.fileCount;
    }

    public long getSize() {
        if (this.overrideSize.equals("")) {
            return this.nbytes;
        }
        return Long.parseLong(this.overrideSize);
    }

    public void adjustLongestPath(String targetfile) {
        String relativePath = targetfile.replaceFirst("^\\$\\{.*\\}", "");
        int relativeLength = relativePath.length();
        this.longestPath = this.longestPath < relativeLength ? relativeLength : this.longestPath;
    }
}

