/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.adaptator.impl;

import com.izforge.izpack.adaptator.IXMLElement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLElementImpl
implements IXMLElement {
    private Element element;
    private boolean hasChanged = true;
    private Vector<IXMLElement> childrenVector;

    public XMLElementImpl(String name) {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder constructeur = documentFactory.newDocumentBuilder();
            Document document = constructeur.newDocument();
            document.setXmlVersion("1.0");
            this.element = document.createElement(name);
            document.appendChild(this.element);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public XMLElementImpl(String name, Document inDocument) {
        this.element = inDocument.createElement(name);
    }

    public XMLElementImpl(String name, IXMLElement elementReference) {
        this.element = elementReference.getElement().getOwnerDocument().createElement(name);
    }

    public XMLElementImpl(Node node) {
        if (!(node instanceof Element)) {
            throw new IllegalArgumentException("The node should be an instance of Element");
        }
        this.element = (Element)node;
    }

    @Override
    public String getName() {
        return this.element.getNodeName();
    }

    @Override
    public void addChild(IXMLElement child) {
        this.hasChanged = true;
        this.element.appendChild(child.getElement());
    }

    @Override
    public void removeChild(IXMLElement child) {
        this.hasChanged = true;
        this.element.removeChild(child.getElement());
    }

    @Override
    public boolean hasChildren() {
        for (Node child = this.element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private void initChildrenVector() {
        if (this.hasChanged) {
            this.hasChanged = false;
            this.childrenVector = new Vector();
            for (Node child = this.element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                this.childrenVector.add(new XMLElementImpl(child));
            }
        }
    }

    @Override
    public int getChildrenCount() {
        this.initChildrenVector();
        return this.childrenVector.size();
    }

    @Override
    public Vector<IXMLElement> getChildren() {
        this.initChildrenVector();
        return this.childrenVector;
    }

    @Override
    public IXMLElement getChildAtIndex(int index) {
        this.initChildrenVector();
        return this.childrenVector.get(index);
    }

    @Override
    public IXMLElement getFirstChildNamed(String name) {
        XMLElementImpl res = null;
        NodeList nodeList = this.element.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            res = new XMLElementImpl(nodeList.item(0));
        }
        return res;
    }

    @Override
    public Vector<IXMLElement> getChildrenNamed(String name) {
        Vector<IXMLElement> res = new Vector<IXMLElement>();
        Vector<IXMLElement> children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            IXMLElement child = children.elementAt(i);
            if (child.getName() == null || !child.getName().equals(name)) continue;
            res.add(new XMLElementImpl(child.getElement()));
        }
        return res;
    }

    @Override
    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        Node attribute = this.element.getAttributes().getNamedItem(name);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        return defaultValue;
    }

    @Override
    public void setAttribute(String name, String value) {
        NamedNodeMap attributes = this.element.getAttributes();
        Attr attribute = this.element.getOwnerDocument().createAttribute(name);
        attribute.setValue(value);
        attributes.setNamedItem(attribute);
    }

    @Override
    public void removeAttribute(String name) {
        this.element.getAttributes().removeNamedItem(name);
    }

    @Override
    public Enumeration enumerateAttributeNames() {
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        Properties properties = new Properties();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            properties.put(node.getNodeName(), node.getNodeValue());
        }
        return properties.keys();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.element.getAttributes().getNamedItem(name) != null;
    }

    @Override
    public Properties getAttributes() {
        Properties properties = new Properties();
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            properties.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());
        }
        return properties;
    }

    @Override
    public int getLineNr() {
        Object ln = this.element.getUserData("ln");
        if (ln == null) {
            return -1;
        }
        try {
            return (Integer)this.element.getUserData("ln");
        }
        catch (ClassCastException e) {
            return -1;
        }
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder();
        Node child = this.element.getFirstChild();
        boolean err = child == null;
        Pattern p = Pattern.compile("^\\s+$");
        while (!err && child != null) {
            String content = child.getNodeValue();
            if (child.getNodeType() == 3) {
                if (content != null && !p.matcher(content).matches()) {
                    sb.append(content);
                }
            } else if (child.getNodeType() == 4) {
                sb.append(content);
            } else {
                err = true;
            }
            child = child.getNextSibling();
        }
        return err ? null : sb.toString().trim();
    }

    @Override
    public void setContent(String content) {
        Node child;
        while ((child = this.element.getFirstChild()) != null) {
            this.element.removeChild(child);
        }
        this.element.appendChild(this.element.getOwnerDocument().createTextNode(content));
    }

    @Override
    public Node getElement() {
        return this.element;
    }

    public String toString() {
        return this.element.getNodeName() + " " + this.element.getNodeValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IXMLElement) {
            IXMLElement o = (IXMLElement)obj;
            Element elem = (Element)o.getElement();
            Node child2 = elem.getFirstChild();
            for (Node child = this.element.getFirstChild(); child != null && child2 != null; child = child.getNextSibling()) {
                if (!child.equals(child2)) {
                    return false;
                }
                child2.getNextSibling();
            }
            return true;
        }
        return false;
    }
}

