/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.HighlightJButton;
import com.izforge.izpack.gui.UiResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class ButtonFactory {
    private static HashMap<String, String> buttonMnemonicMap = new HashMap();
    private static HashMap<String, String> frameShortcuts = new HashMap();
    private static boolean useHighlightButtons = false;
    private static boolean useButtonIcons = false;

    public static void useButtonIcons() {
        ButtonFactory.useButtonIcons(true);
    }

    public static void useButtonIcons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useButtonIcons = useit;
        }
    }

    public static void useHighlightButtons() {
        ButtonFactory.useHighlightButtons(true);
    }

    public static void useHighlightButtons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useHighlightButtons = useit;
        }
        ButtonFactory.useButtonIcons(useit);
    }

    public static JButton createButton(String text, Icon icon, Color color, int mnemonic, boolean isFrame) {
        JButton btn = null;
        HashMap<String, String> map = null;
        btn = useHighlightButtons ? (useButtonIcons && icon != null ? new HighlightJButton(text, icon, color) : new HighlightJButton(text, color)) : (useButtonIcons && icon != null ? new AutoSizedButton(text, icon) : new AutoSizedButton(text));
        HashMap<String, String> hashMap = map = isFrame ? frameShortcuts : buttonMnemonicMap;
        if (text != null) {
            if (mnemonic == 0) {
                String key = ButtonFactory.findMnemonic(text);
                if (key != null) {
                    btn.setMnemonic(key.charAt(0));
                    map.put(key, text);
                }
            } else {
                btn.setMnemonic(mnemonic);
                map.put(String.valueOf(mnemonic), text);
            }
            if (text.contains("<html>")) {
                ButtonFactory.makeMnemonicVisibleForHtmlText(btn);
            }
        }
        btn.setFont(FontResources.getOpenSansRegular());
        btn.addFocusListener(new FocusListenerAutoScroll());
        return btn;
    }

    public static JButton createButton(String text) {
        return ButtonFactory.createButton(text, null, null, 0);
    }

    public static JButton createButton(String text, boolean isFrame) {
        return ButtonFactory.createButton(text, null, null, 0, isFrame);
    }

    public static JButton createButton(String text, Icon icon, Color color, int mnemonic) {
        return ButtonFactory.createButton(text, icon, color, mnemonic, false);
    }

    public static JButton createButton(String text, Icon icon, Color color, boolean isFrame) {
        return ButtonFactory.createButton(text, icon, color, 0, isFrame);
    }

    public static JButton createButton(String text, int mnemonic) {
        return ButtonFactory.createButton(text, null, null, mnemonic);
    }

    public static JButton createButton(String text, Color color) {
        return ButtonFactory.createButton(text, null, color, 0);
    }

    public static JButton createButton(String text, Icon icon) {
        return ButtonFactory.createButton(text, icon, null, 0);
    }

    public static JButton createButton(String text, Icon icon, Color color) {
        return ButtonFactory.createButton(text, icon, color, 0);
    }

    public static JButton createButton(Icon icon, Color color) {
        return ButtonFactory.createButton(null, icon, color, 0);
    }

    public static JButton createButton(Action a, Color color) {
        if (useHighlightButtons) {
            return new HighlightJButton(a, color);
        }
        return new AutoSizedButton(a);
    }

    public static String findMnemonic(String text) {
        String stepOne = text.toLowerCase().replaceAll("</*html>", "");
        String caption = stepOne.toLowerCase().replaceAll("<font.*</font>", "").trim();
        caption = caption.contains("<u>") ? caption.substring(3, 4) + caption.substring(8) : caption;
        String key = null;
        for (caption = caption.replaceAll(" ", ""); caption != null && caption.length() > 0; caption = caption.substring(1)) {
            key = String.valueOf(caption.charAt(0));
            if (buttonMnemonicMap.containsKey(key) || frameShortcuts.containsKey(key)) {
                continue;
            }
            return key;
        }
        return null;
    }

    private static void makeMnemonicVisibleForHtmlText(JButton btn) {
        String btnText = btn.getText();
        String strippedText = btnText.replaceAll("(?i)</*html>", "").replaceAll("(?i)<font.*</font>", "").trim();
        if (strippedText.toUpperCase().indexOf(btn.getMnemonic()) >= 0 && btnText.contains(strippedText)) {
            int startOfVisibleText = btnText.indexOf(strippedText);
            int realMnemonicIndex = btnText.toUpperCase().indexOf(btn.getMnemonic(), startOfVisibleText);
            btn.getDisplayedMnemonicIndex();
            StringBuilder updatedText = new StringBuilder(btnText);
            updatedText.insert(realMnemonicIndex + 1, "</u>");
            updatedText.insert(realMnemonicIndex, "<u>");
            btn.setText(updatedText.toString());
        }
    }

    public static void reserveInstallerFrameShortcuts(String[] shortcuts) {
        for (String shortcut : shortcuts) {
            frameShortcuts.put(ButtonFactory.findMnemonic(shortcut), shortcut);
        }
    }

    public static void clearInstallerFrameShortcuts() {
        frameShortcuts.clear();
    }

    public static void clearButtonMnemonics() {
        buttonMnemonicMap.clear();
    }

    private static JButton createGradientButton(String text, Color light, Color dark, Color stroke, Color shadow) {
        String key;
        GradientButton gradientButton = new GradientButton(text, light, dark, stroke, shadow);
        gradientButton.setFont(FontResources.getOpenSansRegular());
        if (text != null && (key = ButtonFactory.findMnemonic(text)) != null) {
            gradientButton.setMnemonic(key.charAt(0));
            buttonMnemonicMap.put(key, text);
        }
        return gradientButton;
    }

    public static JButton createBlueGradientButton(String text, Icon icon) {
        JButton button = ButtonFactory.createBlueGradientButton(text);
        button.setIcon(icon);
        return button;
    }

    public static JButton createBlueGradientButton(String text) {
        JButton button = ButtonFactory.createGradientButton(text, UiResources.blueButtonLight, UiResources.blueButtonDark, UiResources.blueButtonStroke, UiResources.blueButtonShadow);
        button.setForeground(new Color(0xFFFFFF));
        return button;
    }

    public static JButton createRedGradientButton(String text) {
        JButton button = ButtonFactory.createGradientButton(text, UiResources.redButtonLight, UiResources.redButtonDark, UiResources.redButtonStroke, UiResources.redButtonShadow);
        button.setForeground(new Color(0xFFFFFF));
        return button;
    }

    public static JButton createGrayGradientButton(String text, Icon icon) {
        JButton button = ButtonFactory.createGrayGradientButton(text);
        button.setIcon(icon);
        return button;
    }

    public static JButton createGrayGradientButton(String text) {
        return ButtonFactory.createGradientButton(text, UiResources.grayButtonLight, UiResources.grayButtonDark, UiResources.grayButtonStroke, UiResources.grayButtonShadow);
    }

    public static JButton createConstrainedGrayGradientButton(String text, int minWidth) {
        GradientButton gradient = new GradientButton(text, UiResources.grayButtonLight, UiResources.grayButtonDark, UiResources.grayButtonStroke, UiResources.grayButtonShadow, minWidth);
        return gradient;
    }

    public static void clearButton(JButton browseButton) {
        int mnemonic = browseButton.getMnemonic();
        int key = mnemonic >= 65 && mnemonic <= 90 ? mnemonic + 32 : mnemonic;
        buttonMnemonicMap.remove(String.valueOf((char)key));
    }

    public static class GradientButton
    extends JButton {
        private Color light;
        private Color dark;
        private Color stroke;
        private Color shadow;
        private Color currentStroke;
        private final int minimumWidth = 55;
        private final int fontAwesomeWidth = 8;
        private final int leftSpace = 10;
        private final int rightSpace = 10;
        private final int buttonHeight = 25;

        public GradientButton() {
        }

        public GradientButton(String s, Color light, Color dark, Color stroke, Color mouseOver) {
            this(s, light, dark, stroke, mouseOver, 0);
        }

        public GradientButton(String s, Color light, Color dark, Color stroke, Color mouseOver, int minimumWidth) {
            super(s);
            this.setText(s);
            this.light = light;
            this.dark = dark;
            this.stroke = stroke;
            this.currentStroke = stroke;
            this.shadow = mouseOver;
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            if (this.getFont() != null) {
                String htmlStripped;
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                int textWidth = metrics.stringWidth(htmlStripped = this.stripHtml(this.getText()));
                int totalWidth = textWidth + this.fontAwesomeWidth;
                Dimension d = totalWidth >= 55 ? new Dimension(10 + totalWidth + 10, 25) : new Dimension(75, 25);
                this.setPreferredSize(d);
            }
        }

        private String stripHtml(String text) {
            String step1 = text.replaceAll("</*html>", "");
            String step2 = step1.replaceAll("<font.*>", "");
            return step2;
        }

        private Paint getPressPaint() {
            return UiResources.getGradientPaint(this, this.shadow, this.dark);
        }

        private Paint getHoverPaint() {
            return UiResources.getGradientPaint(this, this.dark, this.dark);
        }

        private Paint getNormalPaint() {
            return UiResources.getGradientPaint(this, this.light, this.dark);
        }

        @Override
        public void paintComponent(Graphics g) {
            Paint currentPaint;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle2D.Float rectangle = new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
            if (this.isEnabled()) {
                this.currentStroke = this.stroke;
                this.paintBorder(g);
                currentPaint = this.getNormalPaint();
                if (this.getModel().isRollover()) {
                    currentPaint = this.getHoverPaint();
                }
                if (this.getModel().isPressed()) {
                    currentPaint = this.getPressPaint();
                }
            } else {
                currentPaint = UiResources.sideNavigationBackGround;
                this.currentStroke = UiResources.grayDisabledStroke;
                this.paintBorder(g);
            }
            g2d.setPaint(currentPaint);
            g2d.fill(rectangle);
            super.paintComponent(g);
        }

        @Override
        public void paintBorder(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor(this.currentStroke);
            Rectangle2D border = new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight()).getBounds2D();
            g2d.drawRect(0, 0, (int)border.getWidth() - 1, (int)border.getHeight() - 1);
        }

        public Color getLight() {
            return this.light;
        }

        public Color getDark() {
            return this.dark;
        }

        public Color getShadow() {
            return this.shadow;
        }

        public Color getStroke() {
            return this.stroke;
        }
    }

    public static class AutoSizedButton
    extends JButton {
        private final int leftSpace = 10;
        private final int rightSpace = 10;
        private final int fontAwesomeWidth = 8;
        private final int buttonHeight = 25;
        private final int minimumWidth = 55;

        public AutoSizedButton(Icon icon) {
            super(icon);
        }

        public AutoSizedButton(String text) {
            super(text);
        }

        public AutoSizedButton(String text, Icon icon) {
            super(text, icon);
        }

        public AutoSizedButton(Action a) {
            super(a);
        }

        public AutoSizedButton() {
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getFont() != null) {
                int totalWidth = this.getStringWidth(this.getText());
                Dimension dimension = totalWidth >= 55 ? new Dimension(10 + totalWidth + 10, 25) : new Dimension(75, 25);
                return dimension;
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        private int getStringWidth(String s) {
            int totalWidth = 0;
            if (s != null) {
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                String htmlStripped = this.stripHtml(s);
                totalWidth = this.containsFontAwesome(htmlStripped) ? metrics.stringWidth(htmlStripped) + this.fontAwesomeWidth : metrics.stringWidth(htmlStripped);
            }
            return totalWidth;
        }

        private boolean containsFontAwesome(String htmlStripped) {
            for (String icon : FontResources.awesomeIcons) {
                if (!htmlStripped.contains(icon)) continue;
                return true;
            }
            return false;
        }

        private String stripHtml(String text) {
            if (text != null) {
                String stripped = text.replaceAll("<[^>]+>", "");
                return stripped;
            }
            return "";
        }
    }
}

