/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FontResources {
    private static final List<String> UNSUPPORTED_LOCALS = Arrays.asList("chn", "jpn");
    public static final String checkmarkCharacter = "\uf00c";
    public static final String rightArrowCircle = "\uf0a9";
    public static final String chevronLeft = "\uf053";
    public static final String chevronRight = "\uf054";
    public static final String question = "\uf128";
    public static final String homeIcon = "\uf015";
    public static final String upIcon = "\uf148";
    public static final String folderIcon = "\uf07c";
    public static final String gridIcon = "\uf009";
    public static final String listIcon = "\uf00b";
    public static List<String> awesomeIcons = new ArrayList<String>();
    public static final String buttonLeftIcon = "<font size='2' face='FontAwesome'>\uf053</font>";
    public static final String buttonRightIcon = "<font size='2' face='FontAwesome'>\uf054</font>";
    private static Font openSansLight;
    private static Font openSansRegular;
    private static Font openSansExtraBold;
    private static Font fontAwesome;
    private static Font regularBaseFont;
    private static Font titleBaseFont;

    private static void loadOpenSansExtraBold() throws IOException, FontFormatException {
        InputStream is = FontResources.class.getResourceAsStream("/fonts/opensans-extrabold.ttf");
        openSansExtraBold = Font.createFont(0, is).deriveFont(13.0f);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(openSansExtraBold);
    }

    private static void loadOpenSansRegular() throws IOException, FontFormatException {
        InputStream is = FontResources.class.getResourceAsStream("/fonts/opensans-regular.ttf");
        openSansRegular = Font.createFont(0, is).deriveFont(13.0f);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(openSansRegular);
    }

    private static void loadOpenSansLight() throws IOException, FontFormatException {
        InputStream is = FontResources.class.getResourceAsStream("/fonts/opensans-light.ttf");
        openSansLight = Font.createFont(0, is).deriveFont(24.0f);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(openSansLight);
    }

    private static void loadFontAwesome() throws IOException, FontFormatException {
        InputStream is = FontResources.class.getResourceAsStream("/fonts/fontawesome-webfont.ttf");
        fontAwesome = Font.createFont(0, is).deriveFont(14.0f);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(fontAwesome);
    }

    private static void loadRegularBaseFont() throws IOException, FontFormatException {
        regularBaseFont = new Font("Dialog", 0, 12);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(regularBaseFont);
    }

    private static void loadTitleBaseFont() throws IOException, FontFormatException {
        titleBaseFont = new Font("Dialog", 0, 24);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(titleBaseFont);
    }

    public static Font getRegularBaseFont() {
        if (regularBaseFont == null) {
            try {
                FontResources.loadRegularBaseFont();
            }
            catch (FontFormatException e) {
                Debug.log(e);
            }
            catch (IOException e) {
                Debug.log(e);
            }
        }
        return regularBaseFont;
    }

    public static Font getTitleBaseFont() {
        if (titleBaseFont == null) {
            try {
                FontResources.loadTitleBaseFont();
            }
            catch (FontFormatException e) {
                Debug.log(e);
            }
            catch (IOException e) {
                Debug.log(e);
            }
        }
        return titleBaseFont;
    }

    public static Font getFontAwesome() {
        if (fontAwesome == null) {
            try {
                FontResources.loadFontAwesome();
            }
            catch (FontFormatException e) {
                Debug.log(e);
            }
            catch (IOException e) {
                Debug.log(e);
            }
        }
        return fontAwesome;
    }

    public static Font getOpenSansLight() {
        String locale = FontResources.getLocale();
        if (locale == null || UNSUPPORTED_LOCALS.contains(locale)) {
            return FontResources.getTitleBaseFont();
        }
        if (openSansLight == null) {
            try {
                FontResources.loadOpenSansLight();
            }
            catch (IOException e) {
                Debug.log(e);
            }
            catch (FontFormatException e) {
                Debug.log(e);
            }
        }
        return openSansLight;
    }

    public static Font getOpenSansRegular() {
        String locale = FontResources.getLocale();
        if (locale == null || UNSUPPORTED_LOCALS.contains(locale)) {
            return FontResources.getRegularBaseFont();
        }
        if (openSansRegular == null) {
            try {
                FontResources.loadOpenSansRegular();
            }
            catch (IOException e) {
                Debug.log(e);
            }
            catch (FontFormatException e) {
                Debug.log(e);
            }
        }
        return openSansRegular;
    }

    public static Font getOpenSansExtraBold() {
        String locale = FontResources.getLocale();
        if (UNSUPPORTED_LOCALS.contains(locale)) {
            return FontResources.getRegularBaseFont();
        }
        if (openSansExtraBold == null) {
            try {
                FontResources.loadOpenSansExtraBold();
            }
            catch (IOException e) {
                Debug.log(e);
            }
            catch (FontFormatException e) {
                Debug.log(e);
            }
        }
        return openSansExtraBold;
    }

    public static String getLocale() {
        AutomatedInstallData adata = AutomatedInstallData.getInstance();
        String locale = null;
        if (adata != null) {
            locale = adata.localeISO3;
        }
        return locale;
    }

    static {
        awesomeIcons.add(checkmarkCharacter);
        awesomeIcons.add(rightArrowCircle);
        awesomeIcons.add(chevronLeft);
        awesomeIcons.add(chevronRight);
        awesomeIcons.add(question);
    }
}

