/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.CorrectWidthJTextArea;
import com.izforge.izpack.gui.FontResources;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class LabelFactory
implements SwingConstants {
    private static boolean useLabelIcons = true;
    private static float labelFontSizeVal = 1.0f;
    private static Font customLabelFontObj = null;

    public static boolean isUseLabelIcons() {
        return useLabelIcons;
    }

    public static void setUseLabelIcons(boolean b) {
        useLabelIcons = b;
    }

    public static float getLabelFontSize() {
        return labelFontSizeVal;
    }

    public static void setLabelFontSize(float val) {
        if (val > 0.0f && val <= 5.0f && val != labelFontSizeVal) {
            labelFontSizeVal = val;
            Font fontObj = new JLabel().getFont();
            customLabelFontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
    }

    public static JLabel create(Icon image) {
        return LabelFactory.create(image, 0);
    }

    public static JLabel create(Icon image, int horizontalAlignment) {
        return LabelFactory.create(null, image, horizontalAlignment);
    }

    public static JLabel create(String text) {
        return LabelFactory.create(text, 2);
    }

    public static JLabel create(String text, boolean isFullLine) {
        return LabelFactory.create(text, 0, isFullLine);
    }

    public static JLabel create(String text, int horizontalAlignment) {
        return LabelFactory.create(text, null, horizontalAlignment);
    }

    public static JLabel create(String text, int horizontalAlignment, boolean isFullLine) {
        return LabelFactory.create(text, null, horizontalAlignment, isFullLine);
    }

    public static JLabel create(String text, Icon image, int horizontalAlignment) {
        return LabelFactory.create(text, image, horizontalAlignment, false);
    }

    public static JLabel createTitleLabel(String titleText, boolean isOpaque) {
        JLabel title = new JLabel(titleText, 2);
        title.setOpaque(isOpaque);
        Font font = FontResources.getOpenSansLight();
        title.setFont(font);
        return title;
    }

    public static JLabel create(String text, Icon image, int horizontalAlignment, boolean isFullLine) {
        JLabel retval = null;
        retval = image != null && LabelFactory.isUseLabelIcons() ? (isFullLine ? new FullLineLabel(image) : new JLabel(image)) : (isFullLine ? new FullLineLabel() : new JLabel());
        if (text != null) {
            retval.setText(text);
        }
        if (customLabelFontObj != null) {
            retval.setFont(customLabelFontObj);
        }
        retval.setHorizontalAlignment(horizontalAlignment);
        return retval;
    }

    public static JLabel create(String text, String URL2) {
        SwingLink retval = null;
        retval = new SwingLink(text, URL2);
        if (customLabelFontObj != null) {
            retval.setFont(customLabelFontObj);
        }
        return retval;
    }

    public static JTextArea createMultilineLabel(String labelText, boolean isOpaque) {
        CorrectWidthJTextArea area = new CorrectWidthJTextArea(labelText);
        area.setFont(UIManager.getFont("Label.font"));
        area.setEditable(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setOpaque(isOpaque);
        return area;
    }

    public static class SwingLink
    extends JLabel {
        private static final long serialVersionUID = 8273875024682878518L;

        public SwingLink(String text, Icon image, URI uri) {
            super(image);
            this.setup(text, uri);
        }

        public SwingLink(String text, String uri) {
            URI oURI;
            try {
                oURI = new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.setup(text, oURI);
        }

        public void setup(String text, final URI uri) {
            this.setText("<html><span style=\"color: #000099;\">" + text + "</span></html>");
            this.setToolTipText(uri.toString());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingLink.open(uri);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
        }

        private static void open(URI uri) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(uri);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Failed to launch the link, your computer is likely misconfigured.", "Cannot Launch Link", 2);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Java is not able to launch links on your computer.", "Cannot Launch Link", 2);
            }
        }
    }

    public static class FullLineLabel
    extends JLabel {
        private static final long serialVersionUID = 2918265795390777147L;

        public FullLineLabel(Icon image) {
            super(image);
        }

        public FullLineLabel() {
        }
    }
}

