/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutFocusTraversalPolicy;

public class PanelFactory {
    public static JPanel createContentPanel(boolean isOpaque) {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setOpaque(isOpaque);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 25;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 100;
        gbc.gridy = 100;
        gbc.gridwidth = 100;
        gbc.gridheight = 100;
        gbc.fill = 1;
        contentPanel.add(Box.createGlue(), gbc);
        contentPanel.setBorder(BorderFactory.createEmptyBorder());
        return contentPanel;
    }

    public static JPanel createMainPanel(boolean isOpaque) {
        JPanel panel = new JPanel();
        panel.setOpaque(isOpaque);
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        return panel;
    }

    public static JPanel createRadioContentPanel(boolean isOpaque) {
        JPanel contentPanel = new JPanel();
        contentPanel.setOpaque(isOpaque);
        contentPanel.setBorder(BorderFactory.createEmptyBorder());
        return contentPanel;
    }

    public static JPanel createRadioButtonPanel(boolean isOpaque, final ButtonGroup group) {
        JPanel buttonPanel = PanelFactory.createRadioContentPanel(isOpaque);
        buttonPanel.setFocusTraversalPolicyProvider(true);
        buttonPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                ButtonModel selection = group.getSelection();
                for (Component c : focusCycleRoot.getComponents()) {
                    if (!(c instanceof Box)) continue;
                    for (Component bc : ((Box)c).getComponents()) {
                        if (!(bc instanceof JRadioButton)) continue;
                        JRadioButton radioBtn = (JRadioButton)bc;
                        if (!radioBtn.isEnabled()) {
                            return null;
                        }
                        ButtonModel loopModel = radioBtn.getModel();
                        if (loopModel != selection) continue;
                        return radioBtn;
                    }
                }
                return super.getDefaultComponent(focusCycleRoot);
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return this.getDefaultComponent(focusCycleRoot);
            }
        });
        return buttonPanel;
    }
}

