/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.MouseListenerFocus;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScrollPaneFactory {
    public static JScrollPane createScroller() {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), null, 20, 30, true);
    }

    public static JScrollPane createScroller(boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), null, 20, 30, isOpaque);
    }

    public static JScrollPane createScroller(Component view) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 20, 30, true);
    }

    public static JScrollPane createScroller(Border border) {
        return ScrollPaneFactory.createPanelScroller(border, null, 20, 30, true);
    }

    public static JScrollPane createScroller(Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 20, 30, isOpaque);
    }

    public static JScrollPane createScroller(Border border, Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(border, view, 20, 30, isOpaque);
    }

    public static JScrollPane createNoHorizontalPanelScroller(Component view) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 20, 31, true);
    }

    public static JScrollPane createNoVerticalPanelScroller(Component view) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 21, 30, true);
    }

    public static JScrollPane createAlwaysHorizontalPanelScroller(Component view) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 20, 32, true);
    }

    public static JScrollPane createAlwaysVerticalPanelScroller(Component view) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 22, 30, true);
    }

    public static JScrollPane createAlwaysVerticalAndHorizontalPanelScroller(Component view) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 22, 32, true);
    }

    public static JScrollPane createNoHorizontalPanelScroller(Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 20, 31, isOpaque);
    }

    public static JScrollPane createNoVerticalPanelScroller(Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 21, 30, isOpaque);
    }

    public static JScrollPane createAlwaysHorizontalPanelScroller(Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 20, 32, isOpaque);
    }

    public static JScrollPane createAlwaysVerticalPanelScroller(Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 22, 30, isOpaque);
    }

    public static JScrollPane createAlwaysVerticalAndHorizontalPanelScroller(Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(BorderFactory.createEmptyBorder(), view, 22, 32, isOpaque);
    }

    public static JScrollPane createNoHorizontalPanelScroller(Border border, Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(border, view, 20, 31, isOpaque);
    }

    public static JScrollPane createNoVerticalPanelScroller(Border border, Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(border, view, 21, 30, isOpaque);
    }

    public static JScrollPane createAlwaysHorizontalPanelScroller(Border border, Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(border, view, 20, 32, isOpaque);
    }

    public static JScrollPane createAlwaysVerticalPanelScroller(Border border, Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(border, view, 22, 30, isOpaque);
    }

    public static JScrollPane createAlwaysVerticalAndHorizontalPanelScroller(Border border, Component view, boolean isOpaque) {
        return ScrollPaneFactory.createPanelScroller(border, view, 22, 32, isOpaque);
    }

    private static JScrollPane createPanelScroller(Border border, Component view, int vertical, int horizontal, boolean isOpaque) {
        final JScrollPane scroller = new JScrollPane(view, vertical, horizontal);
        scroller.setViewportBorder(border);
        scroller.getVerticalScrollBar().setBorder(border);
        scroller.getHorizontalScrollBar().setBorder(border);
        scroller.getViewport().setOpaque(isOpaque);
        scroller.setOpaque(isOpaque);
        scroller.setBorder(border);
        scroller.getVerticalScrollBar().setUnitIncrement(15);
        scroller.getHorizontalScrollBar().setUnitIncrement(15);
        scroller.setFocusable(false);
        scroller.getHorizontalScrollBar().addMouseListener(new MouseListenerFocus());
        scroller.getVerticalScrollBar().addMouseListener(new MouseListenerFocus());
        scroller.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                scroller.getVerticalScrollBar().repaint();
                scroller.getHorizontalScrollBar().repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                scroller.getVerticalScrollBar().repaint();
                scroller.getHorizontalScrollBar().repaint();
            }
        });
        scroller.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (scroller.getHorizontalScrollBar().isVisible() || scroller.getVerticalScrollBar().isVisible()) {
                    scroller.setFocusable(true);
                }
                if (!scroller.getHorizontalScrollBar().isVisible() && !scroller.getVerticalScrollBar().isVisible()) {
                    scroller.setFocusable(false);
                }
            }
        });
        return scroller;
    }
}

