/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class UserInputGuiUtils {
    private static int baseIndent = 20;

    public static JPanel createMainPanel(boolean isOpaque) {
        JPanel panel = new JPanel();
        panel.setOpaque(isOpaque);
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        return panel;
    }

    public static JPanel createContentPanel(boolean isOpaque) {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setOpaque(isOpaque);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 25;
        gbc.weightx = 10.0;
        gbc.weighty = 10.0;
        gbc.gridx = 100;
        gbc.gridy = 100;
        gbc.gridwidth = 100;
        gbc.gridheight = 100;
        gbc.fill = 1;
        contentPanel.add(Box.createGlue(), gbc);
        contentPanel.setBorder(BorderFactory.createEmptyBorder());
        return contentPanel;
    }

    public static GridBagConstraints getContentPanelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 15;
        gbc.weightx = 10.0;
        gbc.weighty = 10.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        return gbc;
    }

    public static JScrollPane createPanelScroller(Border border, JPanel panel, boolean isOpaque) {
        JScrollPane scroller = new JScrollPane(panel, 20, 31);
        scroller.setViewportBorder(border);
        scroller.getVerticalScrollBar().setBorder(border);
        scroller.getHorizontalScrollBar().setBorder(border);
        scroller.getViewport().setOpaque(isOpaque);
        scroller.setOpaque(isOpaque);
        scroller.setBorder(border);
        scroller.getVerticalScrollBar().setUnitIncrement(15);
        return scroller;
    }

    public static GridBagConstraints getTitleConstraints(int gridBagAnchor) {
        GridBagConstraints titleConstraints = new GridBagConstraints();
        titleConstraints.insets = new Insets(10, 20, 10, 20);
        titleConstraints.gridheight = 1;
        titleConstraints.gridwidth = 1;
        titleConstraints.weightx = 0.0;
        titleConstraints.weighty = 0.0;
        titleConstraints.fill = 0;
        titleConstraints.anchor = gridBagAnchor;
        titleConstraints.gridx = 0;
        titleConstraints.gridy = 0;
        return titleConstraints;
    }

    public static GridBagConstraints createNonFullLineElementConstraint(int row, int col, int alignment, int indent) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = alignment;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 20);
        return gbc;
    }

    public static GridBagConstraints createFullLineElementConstraint(int row, int col, int indent) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 40);
        return gbc;
    }

    public static GridBagConstraints createCheckAndRadioConstraint(int row, int col, int indent, double weightx) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.weightx = weightx;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(0, baseIndent + indent, 0, 20);
        return gbc;
    }

    public static GridBagConstraints createAlignedElementConstraint(int row, int col, int indent, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = fill;
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 20);
        return gbc;
    }

    public static GridBagConstraints createFixedSizeAlignedElementConstraint(int row, int col, int indent, double weightx) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = weightx;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 20);
        return gbc;
    }

    public static GridBagConstraints createDividerConstraints(int row, int indent) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 10000.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 20);
        return gbc;
    }
}

