/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.dynamic;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.gui.dynamic.DynamicValidator;
import com.izforge.izpack.gui.dynamic.KeyValueDynamicComponent;
import com.izforge.izpack.gui.dynamic.SecurityDomainModule;
import com.izforge.izpack.gui.dynamic.TwoJTextFieldJPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.panels.ValidatorContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DynamicComponentsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -998206641413808493L;
    private static final String addOneCommand = "AddOne";
    private static final String removeOneCommand = "RemoveOne";
    private static final String TwoJTextFieldJPanel = "com.izforge.izpack.gui.dynamic.TwoJTextFieldJPanel";
    private final Class<?> dynamicComponentType;
    private int dynamicComponentCount = 0;
    private int minDynamicComponents;
    private final int maxDynamicComponents;
    private final JLabel addDynamicLabel;
    private final JButton addDynamicComponentButton;
    private final JButton removeDynamicComponentButton;
    private InstallData idata;
    private IzPanel izpanel;
    private String tooltip;
    private JPanel dynamicComponents;
    private String[][] defaults = null;
    private List<ValidatorContainer> validators;
    private String id = "authen";
    private String fileExtDes;
    private String fileExt;

    public DynamicComponentsPanel(Class<?> type, int maxComponents, int minComponents, JComponent headerComponent, String addText, String removeText) {
        super(true);
        JLabel addLabel;
        GridBagLayout layout = new GridBagLayout();
        layout.rowHeights = new int[]{0, 0, 0};
        layout.columnWidths = new int[]{0};
        layout.columnWeights = new double[]{1.0};
        layout.rowWeights = new double[]{0.0, 1.0, 0.0};
        super.setLayout(layout);
        super.setOpaque(false);
        if (type == JLabel.class || type == JButton.class) {
            throw new RuntimeException("JComponents of the implementing class " + type.getCanonicalName() + " aren't accepted as the dynamic component type.");
        }
        if (!JComponent.class.isAssignableFrom(type)) {
            throw new RuntimeException("Class " + type.getCanonicalName() + " isn't JComponent or a subclass of JComponent");
        }
        this.dynamicComponentType = type;
        if (maxComponents <= 0) {
            throw new RuntimeException("Maxiumum components limit of " + maxComponents + " is not valid (must be > 0)");
        }
        this.maxDynamicComponents = maxComponents;
        this.minDynamicComponents = minComponents < 0 ? 0 : minComponents;
        JPanel addRemovePanel = new JPanel(new GridBagLayout());
        JButton addButton = ButtonFactory.createButton(addText);
        addButton.setActionCommand(addOneCommand);
        addButton.addActionListener(this);
        addButton.addFocusListener(new FocusListenerAutoScroll());
        addRemovePanel.add(addButton);
        this.addDynamicComponentButton = addButton;
        JButton removeButton = ButtonFactory.createButton(removeText);
        removeButton.setActionCommand(removeOneCommand);
        removeButton.addActionListener(this);
        removeButton.addFocusListener(new FocusListenerAutoScroll());
        removeButton.setEnabled(false);
        addRemovePanel.add(removeButton);
        this.removeDynamicComponentButton = removeButton;
        this.addDynamicLabel = addLabel = new JLabel();
        this.dynamicComponents = new JPanel(new GridLayout(0, 1), true);
        GridBagConstraints gbc_headerComponent = new GridBagConstraints();
        gbc_headerComponent.fill = 2;
        gbc_headerComponent.anchor = 17;
        gbc_headerComponent.gridx = 0;
        gbc_headerComponent.gridy = 0;
        GridBagConstraints gbc_dynamicComponents = new GridBagConstraints();
        gbc_dynamicComponents.fill = 1;
        gbc_dynamicComponents.anchor = 10;
        gbc_dynamicComponents.gridx = 0;
        gbc_dynamicComponents.gridy = 1;
        GridBagConstraints gbc_addRemovePanel = new GridBagConstraints();
        gbc_addRemovePanel.fill = 0;
        gbc_addRemovePanel.anchor = 13;
        gbc_addRemovePanel.gridx = 0;
        gbc_addRemovePanel.gridy = 2;
        super.add((Component)headerComponent, gbc_headerComponent);
        super.add((Component)this.dynamicComponents, gbc_dynamicComponents);
        super.add((Component)addRemovePanel, gbc_addRemovePanel);
    }

    public DynamicComponentsPanel(Class<?> type, int maxComponents, int minComponents, JComponent headerComponent, String tooltip, String addText, String removeText) {
        this(type, maxComponents, minComponents, headerComponent, addText, removeText);
        this.setTooltip(tooltip);
    }

    public DynamicComponentsPanel(Class<?> type, int maxComponents, int minComponents, String tooltip, String addText, String removeText) {
        this(type, maxComponents, minComponents, new JPanel(new GridLayout(1, 2)), addText, removeText);
        this.setTooltip(tooltip);
    }

    public void setIdata(InstallData idata) {
        this.idata = idata;
    }

    public void setIzpanel(IzPanel parent) {
        this.izpanel = parent;
    }

    public Map<String, String> serialize(String namePrefix) {
        LinkedHashMap<String, String> serialisedData = new LinkedHashMap<String, String>();
        Component[] components = this.dynamicComponents.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (KeyValueDynamicComponent.class.isAssignableFrom(component.getClass())) {
                KeyValueDynamicComponent keyValueComponent = (KeyValueDynamicComponent)((Object)component);
                String name = keyValueComponent.getKey();
                String value = keyValueComponent.getValue();
                serialisedData.put(namePrefix + "-" + (i + 1) + "-name", name);
                serialisedData.put(namePrefix + "-" + (i + 1) + "-value", value);
                continue;
            }
            if (PathSelectionPanel.class.isAssignableFrom(component.getClass())) {
                PathSelectionPanel pathSelectionComponent = (PathSelectionPanel)component;
                String path = pathSelectionComponent.getPath();
                serialisedData.put(namePrefix + "-" + (i + 1) + "-path", path);
                continue;
            }
            if (SecurityDomainModule.class.isAssignableFrom(component.getClass())) {
                SecurityDomainModule securityDomainModule = (SecurityDomainModule)component;
                serialisedData.put(namePrefix + "-" + (i + 1) + "-code", securityDomainModule.getCode());
                serialisedData.put(namePrefix + "-" + (i + 1) + "-flag", securityDomainModule.getFlag());
                serialisedData.put(namePrefix + "-" + (i + 1) + "-operation", securityDomainModule.getOperation());
                continue;
            }
            throw new RuntimeException("Unhandled component type " + component.getClass().getCanonicalName() + "at index " + i);
        }
        return serialisedData;
    }

    public int getCurrentNumberOfComponents() {
        return this.dynamicComponents.getComponents().length;
    }

    public Class<?> getDynamicComponentType() {
        return this.dynamicComponentType;
    }

    public boolean noKeyDuplication() {
        Component[] components = this.dynamicComponents.getComponents();
        LinkedHashMap<String, String> componentMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (KeyValueDynamicComponent.class.isAssignableFrom(component.getClass())) {
                KeyValueDynamicComponent kvComponent = (KeyValueDynamicComponent)((Object)component);
                if (componentMap.containsKey(kvComponent.getKey())) {
                    return false;
                }
                componentMap.put(kvComponent.getKey(), kvComponent.getValue());
                continue;
            }
            if (!PathSelectionPanel.class.isAssignableFrom(component.getClass())) continue;
            PathSelectionPanel psPanel = (PathSelectionPanel)component;
            if (componentMap.containsKey(psPanel.getPath())) {
                return false;
            }
            componentMap.put(psPanel.getPath(), "");
        }
        return true;
    }

    public boolean noEmptyProperties() {
        Component[] components = this.dynamicComponents.getComponents();
        for (int i = 2; i < components.length; ++i) {
            KeyValueDynamicComponent kvComponent;
            Component component = components[i];
            if (!KeyValueDynamicComponent.class.isAssignableFrom(component.getClass()) || !(kvComponent = (KeyValueDynamicComponent)((Object)component)).getKey().equals("") && !kvComponent.getValue().equals("")) continue;
            return false;
        }
        return true;
    }

    public boolean validateDynamicComponents(DynamicValidator validator) {
        Component[] components = this.dynamicComponents.getComponents();
        for (int i = 0; i < components.length; ++i) {
            KeyValueDynamicComponent kvComponent;
            Component component = components[i];
            if (!KeyValueDynamicComponent.class.isAssignableFrom(component.getClass()) || validator.validateData((kvComponent = (KeyValueDynamicComponent)((Object)component)).getKey(), kvComponent.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean somethingChanged = false;
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(addOneCommand)) {
            this.oneMore();
            somethingChanged = true;
        } else if (actionCommand.equals(removeOneCommand)) {
            this.oneLess();
            somethingChanged = true;
        }
        if (somethingChanged) {
            this.refresh();
            this.scrollToComponent(e.getSource());
        }
    }

    private void scrollToComponent(Object component) {
        JComponent element;
        Container p;
        if (component instanceof JComponent && (p = (element = (JComponent)component).getParent()) instanceof JComponent) {
            JComponent parent = (JComponent)p;
            Rectangle rect = p.getBounds();
            parent.scrollRectToVisible(rect);
        }
    }

    private void refresh() {
        super.revalidate();
        super.repaint();
    }

    public void setAddButtonText(String text) {
        this.addDynamicComponentButton.setText(text);
        this.refresh();
    }

    public void setRemoveButtonText(String text) {
        this.removeDynamicComponentButton.setText(text);
        this.refresh();
    }

    public void setAddLabel() {
        this.addDynamicLabel.setText("Test");
        this.refresh();
    }

    public void addInitial() {
        this.addInitial(new ArrayList<String>());
    }

    public void addInitial(ArrayList<String> defaultValues) {
        this.addInitial(defaultValues, true);
    }

    public void addInitial(ArrayList<String> defaultValues, boolean enabled) {
        if (defaultValues.isEmpty() || defaultValues == null) {
            this.oneMore();
        } else {
            for (String defaultValue : defaultValues) {
                this.oneMore(defaultValue, enabled);
            }
        }
        this.refresh();
    }

    public void initializeDefaults(String[][] elements) {
        this.initializeDefaults(elements, false);
    }

    public void initializeDefaults(String[][] elements, boolean editable) {
        this.dynamicComponentCount += elements.length;
        if (!editable) {
            this.defaults = elements;
        }
        Object object = this.createUnknownObject();
        for (String[] keyValue : elements) {
            JPanel component = null;
            if (this.isJTwoTextField(object)) {
                component = new TwoJTextFieldJPanel(keyValue[0], keyValue[1], editable);
            } else if (this.isSecurityDomainModule(object)) {
                if (keyValue.length == 1) {
                    component = new SecurityDomainModule(this.getId(), keyValue[0]);
                } else if (keyValue.length == 3) {
                    component = new SecurityDomainModule(this.getId(), keyValue[0], keyValue[1], keyValue[2]);
                }
            }
            if (component != null) {
                this.dynamicComponents.add(component);
            }
            if (component instanceof TwoJTextFieldJPanel) continue;
            component.addFocusListener(new FocusListenerAutoScroll());
            component.addFocusListener(new FocusListenerRepaint());
        }
    }

    private void oneMore() {
        this.oneMore("");
    }

    private void oneMore(String defaultValue) {
        this.oneMore(defaultValue, true);
    }

    private void oneMore(String defaultValue, boolean isEnabled) {
        Object object = this.createUnknownObject();
        if (JComponent.class.isAssignableFrom(object.getClass())) {
            JPanel temp;
            if (TwoJTextFieldJPanel.class.isAssignableFrom(object.getClass())) {
                temp = (TwoJTextFieldJPanel)object;
                if (this.tooltip != null) {
                    ((TwoJTextFieldJPanel)temp).getKeyField().setToolTipText(this.tooltip);
                    ((TwoJTextFieldJPanel)temp).getValueField().setToolTipText(this.tooltip);
                    temp.setEnabled(isEnabled);
                }
            }
            if (PathSelectionPanel.class.isAssignableFrom(object.getClass())) {
                if (this.idata != null && this.izpanel != null) {
                    temp = (PathSelectionPanel)object;
                    ((PathSelectionPanel)temp).setIdata(this.idata);
                    ((PathSelectionPanel)temp).setIzPanel(this.izpanel);
                    ((PathSelectionPanel)temp).setFileExtension(this.fileExt);
                    ((PathSelectionPanel)temp).setFileExtensionDescription(this.fileExtDes);
                    ((PathSelectionPanel)temp).createLayout();
                    ((PathSelectionPanel)temp).setEnabled(isEnabled);
                    if (defaultValue != null & !defaultValue.isEmpty()) {
                        ((PathSelectionPanel)temp).setPath(defaultValue);
                    }
                    if (this.tooltip != null) {
                        ((PathSelectionPanel)temp).getPathInputField().setToolTipText(this.tooltip);
                    }
                } else {
                    throw new RuntimeException("Missing required izpanel and idata information for PathSelectionPanel" + this.dynamicComponentType);
                }
            }
            if (SecurityDomainModule.class.isAssignableFrom(object.getClass())) {
                object = new SecurityDomainModule(this.getId());
            }
        } else {
            throw new RuntimeException("Unhandled component type " + object.getClass().getCanonicalName());
        }
        JComponent component = (JComponent)object;
        this.dynamicComponents.add(component);
        ++this.dynamicComponentCount;
        if (this.dynamicComponentCount >= this.maxDynamicComponents) {
            this.addDynamicComponentButton.setEnabled(false);
        } else if (this.dynamicComponentCount > this.minDynamicComponents) {
            this.removeDynamicComponentButton.setEnabled(true);
        }
        if (this.addDynamicComponentButton.isEnabled()) {
            this.addDynamicComponentButton.grabFocus();
        }
        if (!this.addDynamicComponentButton.isEnabled() && this.removeDynamicComponentButton.isEnabled()) {
            this.removeDynamicComponentButton.grabFocus();
        }
    }

    private void oneLess() {
        Component toDelete = this.dynamicComponents.getComponent(this.dynamicComponents.getComponentCount() - 1);
        if (toDelete instanceof PathSelectionPanel) {
            PathSelectionPanel toDeletePanel = (PathSelectionPanel)toDelete;
            ButtonFactory.clearButton(toDeletePanel.getBrowseButton());
        }
        this.dynamicComponents.remove(toDelete);
        --this.dynamicComponentCount;
        if (this.dynamicComponentCount <= this.minDynamicComponents) {
            this.removeDynamicComponentButton.setEnabled(false);
        }
        if (this.dynamicComponentCount < this.maxDynamicComponents) {
            this.addDynamicComponentButton.setEnabled(true);
        }
        if (!this.removeDynamicComponentButton.isEnabled()) {
            this.addDynamicComponentButton.grabFocus();
        }
    }

    public void clearDynamicComponents() {
        for (int i = this.dynamicComponentCount; i > 0; --i) {
            this.oneLess();
        }
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isJTwoTextField(Object obj) {
        return JComponent.class.isAssignableFrom(obj.getClass()) && TwoJTextFieldJPanel.class.isAssignableFrom(obj.getClass());
    }

    public boolean isSecurityDomainModule(Object obj) {
        return JComponent.class.isAssignableFrom(obj.getClass()) && SecurityDomainModule.class.isAssignableFrom(obj.getClass());
    }

    private Object createUnknownObject() {
        Object object = null;
        try {
            object = this.dynamicComponentType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not get instance for contained component type", e);
        }
        return object;
    }

    public void hideButtons() {
        this.addDynamicComponentButton.setVisible(false);
        this.removeDynamicComponentButton.setVisible(false);
    }

    public void showButtons() {
        this.addDynamicComponentButton.setVisible(true);
        this.removeDynamicComponentButton.setVisible(true);
    }

    public void setValidators(List<ValidatorContainer> validators) {
        this.validators = validators;
    }

    public List<ValidatorContainer> getValidators() {
        if (this.validators == null) {
            return new ArrayList<ValidatorContainer>();
        }
        return this.validators;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component comp : this.dynamicComponents.getComponents()) {
            comp.setEnabled(enabled);
        }
        if (enabled && this.dynamicComponentCount > 1 && this.dynamicComponentCount > this.minDynamicComponents) {
            this.removeDynamicComponentButton.setEnabled(true);
        } else {
            this.removeDynamicComponentButton.setEnabled(false);
        }
        if (enabled && this.dynamicComponentCount < this.maxDynamicComponents) {
            this.addDynamicComponentButton.setEnabled(true);
        } else {
            this.addDynamicComponentButton.setEnabled(false);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        for (Component comp : this.dynamicComponents.getComponents()) {
            comp.setVisible(visible);
        }
        this.removeDynamicComponentButton.setVisible(visible);
        this.addDynamicComponentButton.setVisible(visible);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFileExtDes(String fileExtDes) {
        this.fileExtDes = fileExtDes;
    }

    public void setFileExt(String fileExt) {
        this.fileExt = fileExt;
    }

    public JButton getAddDynamicComponentButton() {
        return this.addDynamicComponentButton;
    }

    public JButton getRemoveDynamicComponentButton() {
        return this.removeDynamicComponentButton;
    }
}

