/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.dynamic;

import com.izforge.izpack.gui.ComboBoxFactory;
import com.izforge.izpack.gui.CorrectWidthJTextField;
import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.panels.JFocusPanel;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SecurityDomainModule
extends JPanel {
    private static final long serialVersionUID = 8369099216227655047L;
    private JComboBox code;
    private JComboBox flag;
    private JTextField operation;
    private boolean enabled = true;
    public static Map<String, String[]> flags = new HashMap<String, String[]>();
    public static Map<String, String[]> codes = new HashMap<String, String[]>();

    public SecurityDomainModule() {
    }

    public SecurityDomainModule(String id) {
        super(new GridLayout(1, 3), true);
        this.code = ComboBoxFactory.createComboBox(codes.get(id));
        this.flag = ComboBoxFactory.createComboBox(flags.get(id));
        this.operation = new CorrectWidthJTextField();
        this.operation.setColumns(14);
        JFocusPanel focusBorder = new JFocusPanel(this.operation);
        this.code.addFocusListener(new FocusListenerAutoScroll());
        this.flag.addFocusListener(new FocusListenerAutoScroll());
        this.operation.addFocusListener(new FocusListenerAutoScroll());
        this.operation.addFocusListener(new FocusListenerRepaint());
        super.add(this.code);
        super.add(this.flag);
        super.add(focusBorder);
    }

    public SecurityDomainModule(String id, String value) {
        this(id);
        this.operation.setText(value);
    }

    public SecurityDomainModule(String id, String value, String code, String flag) {
        this(id, value);
        this.setCode(code);
        this.setFlag(flag);
    }

    public void setCode(String codeString) {
        this.code.setSelectedItem(codeString);
    }

    public void setFlag(String flagString) {
        this.flag.setSelectedItem(flagString);
    }

    public String getCode() {
        return (String)this.code.getSelectedItem();
    }

    public String getFlag() {
        return (String)this.flag.getSelectedItem();
    }

    public String getOperation() {
        return this.operation.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.code.setEnabled(enabled);
        this.flag.setEnabled(enabled);
        this.operation.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    static {
        flags.put("authen", new String[]{"Required", "Requisite", "Sufficient", "Optional"});
        flags.put("author", new String[]{"Required", "Requisite", "Sufficient", "Optional"});
        flags.put("mapping", new String[]{"principal", "credential", "role", "attribute"});
        codes.put("authen", new String[]{"Client", "Certificate", "CertificateUsers", "CertificateRoles", "Database", "DatabaseCertificate", "DatabaseUsers", "Identity", "Ldap", "LdapExtended", "RoleMapping", "RunAs", "Simple", "ConfiguredIdentity", "SecureIdentity", "PropertiesUsers", "SimpleUsers", "LdapUsers", "Kerberos", "SPNEGOUsers", "AdvancedLdap", "AdvancedADLdap", "UsersRoles"});
        codes.put("author", new String[]{"DenyAll", "PermitAll", "Delegating", "Web", "JACC", "XACML"});
        codes.put("mapping", new String[]{"PropertiesRoles", "SimpleRoles", "DeploymentRoles", "DatabaseRoles", "LdapRoles"});
    }
}

