/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.UiResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class PatternflyButtonUI
extends BasicButtonUI {
    private Color topButtonColor;
    private Color bottomButtonColor;
    private Color buttonPressedShadow;
    private Color buttonStroke;
    private Color buttonFocus;
    private Color enabledForeground;
    private Border disabledBorder;
    private Border enabledBorder;

    public PatternflyButtonUI() {
    }

    public PatternflyButtonUI(Color enabledForeground, Color top, Color bottom, Color shadow, Color stroke, Color focus) {
        this.enabledForeground = enabledForeground;
        this.topButtonColor = top;
        this.bottomButtonColor = bottom;
        this.buttonPressedShadow = shadow;
        this.buttonStroke = stroke;
        this.buttonFocus = focus;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isEnabled()) {
            c.setForeground(this.enabledForeground);
            c.setBorder(this.enabledBorder);
            if (model.isRollover() && !model.isPressed()) {
                this.drawHoverButton(g, c);
            } else {
                this.drawButton(g, c, this.topButtonColor, this.bottomButtonColor);
            }
        } else {
            c.setForeground(UiResources.grayDisabledText);
            c.setBorder(this.disabledBorder);
            this.drawDisabledButton(g, c, UiResources.grayDisabledButton, UiResources.grayDisabledStroke);
        }
        this.paint(g2d, c);
    }

    private void drawDisabledButton(Graphics g, JComponent c, Color grayDisabledButton, Color grayDisabledStroke) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        g2d.setPaint(grayDisabledButton);
        g2d.fill(rect);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.draw(rect);
    }

    private void drawHoverButton(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.bottomButtonColor);
        Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        g2d.fill(rect);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.drawButton(g, b, this.buttonPressedShadow, this.bottomButtonColor);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.buttonFocus);
        g2d.setStroke(new BasicStroke());
        g2d.draw(new Rectangle(viewRect.x + 1, viewRect.y + 1, viewRect.width - 3, viewRect.height - 3));
    }

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyButtonUI();
    }

    private void drawButton(Graphics g, JComponent c, Color top, Color bottom) {
        Graphics2D g2d = (Graphics2D)g;
        GradientPaint gradient = new GradientPaint(c.getWidth() / 2, 0.0f, top, c.getWidth() / 2, c.getHeight(), bottom);
        g2d.setPaint(gradient);
        Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        g2d.fill(rect);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installColors(c);
    }

    private void installColors(JComponent c) {
        this.topButtonColor = this.topButtonColor == null ? UiResources.grayButtonLight : this.topButtonColor;
        this.bottomButtonColor = this.bottomButtonColor == null ? UiResources.grayButtonDark : this.bottomButtonColor;
        this.buttonPressedShadow = this.buttonPressedShadow == null ? UiResources.grayButtonShadow : this.buttonPressedShadow;
        this.buttonStroke = this.buttonStroke == null ? UiResources.grayButtonStroke : this.buttonStroke;
        this.enabledForeground = this.enabledForeground == null ? Color.BLACK : this.enabledForeground;
        this.buttonFocus = this.buttonFocus == null ? UiResources.blueFocus : this.buttonFocus;
        this.installBorders();
    }

    private void installBorders() {
        this.enabledBorder = BorderFactory.createLineBorder(this.buttonStroke);
        this.disabledBorder = BorderFactory.createLineBorder(UiResources.grayDisabledStroke);
    }
}

