/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.UiResources;
import com.izforge.izpack.util.CustomDefaultListCellRenderer;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class PatternflyComboBoxUI
extends MetalComboBoxUI {
    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        ((JComboBox)c).setRenderer(new CustomDefaultListCellRenderer());
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = super.createArrowButton();
        button.setHorizontalAlignment(0);
        button.setHorizontalTextPosition(2);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(true);
        return button;
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Graphics2D g2d = (Graphics2D)g;
        Paint paint = this.comboBox.isEnabled() ? UiResources.getGradientPaint(bounds, UiResources.grayButtonLight, UiResources.grayButtonDark) : UiResources.getGradientPaint(bounds, UiResources.grayDisabledStroke, UiResources.grayDisabledStroke);
        g2d.setPaint(paint);
        g2d.fill(bounds);
    }

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyComboBoxUI();
    }

    public class ComboBoxCustomButton
    extends JButton {
        private final JList listBox;
        private final CellRendererPane rendererPane;
        private JComboBox comboBox;
        private Icon arrowIcon;

        public ComboBoxCustomButton(JComboBox comboBox, Icon arrowIcon, CellRendererPane rendererPane, JList dropDown) {
            this.arrowIcon = arrowIcon;
            this.setIcon(arrowIcon);
            this.listBox = dropDown;
            this.rendererPane = rendererPane;
            this.comboBox = comboBox;
        }

        @Override
        public void paintComponent(Graphics g) {
            String selectedText;
            super.paintComponent(g);
            Object selected = this.comboBox.getSelectedItem();
            if (selected instanceof FileFilter) {
                FileFilter item = (FileFilter)selected;
                selectedText = item.getDescription();
            } else {
                selectedText = selected.toString();
            }
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int stringWidth = fm.stringWidth(selectedText);
            int iconWidth = this.getIcon().getIconWidth();
            int iconTextGap = this.getWidth() - stringWidth - iconWidth - this.getMargin().left - this.getMargin().right;
            this.setIconTextGap(iconTextGap);
            this.setText(selectedText);
        }
    }
}

