/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.AutomatedInstallData;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class PatternflyFileChooserUI
extends MetalFileChooserUI {
    JButton approveButton = null;
    JButton cancelButton = null;

    public PatternflyFileChooserUI(JFileChooser jfc) {
        super(jfc);
    }

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyFileChooserUI((JFileChooser)c);
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    public void installComponents(JFileChooser fc) {
        super.installComponents(fc);
        this.createNewControlButtons(fc);
    }

    private void createNewControlButtons(JFileChooser fc) {
        this.removeControlButtons();
        this.getButtonPanel().removeAll();
        ButtonFactory.clearButtonMnemonics();
        if (this.approveButton == null) {
            this.approveButton = ButtonFactory.createButton(this.getApproveButtonText(fc));
            this.approveButton.addActionListener(this.getApproveSelectionAction());
        }
        if (this.cancelButton == null) {
            this.cancelButton = ButtonFactory.createButton(UIManager.getString((Object)"FileChooser.cancelButtonText", fc.getLocale()));
            this.cancelButton.addActionListener(this.getCancelSelectionAction());
        }
        this.getButtonPanel().add(this.cancelButton);
        this.getButtonPanel().add(this.approveButton);
        this.addControlButtons();
    }

    @Override
    public String getApproveButtonText(JFileChooser fc) {
        String buttonText = AutomatedInstallData.getInstance().langpack.getString("BrowseDialog.openButton");
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }
}

