/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.ButtonFactory;
import java.awt.Container;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class PatternflyOptionPaneUI
extends BasicOptionPaneUI {
    private static JButton okButton;
    private static JButton cancelButton;
    private static JButton yesButton;
    private static JButton noButton;

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyOptionPaneUI();
    }

    @Override
    protected Object[] getButtons() {
        JButton[] defaultOptions = null;
        if (this.optionPane != null) {
            Object[] options = this.optionPane.getOptions();
            String leftButtonText = null;
            String rightButtonText = null;
            JButton leftButton = null;
            JButton rightButton = null;
            if (options != null) {
                if (options[0] instanceof JButton && options[1] instanceof JButton) {
                    leftButton = (JButton)options[0];
                    rightButton = (JButton)options[1];
                } else {
                    leftButtonText = (String)options[0];
                    rightButtonText = (String)options[1];
                }
            }
            int type = this.optionPane.getOptionType();
            Locale l = this.optionPane.getLocale();
            defaultOptions = type == 0 ? new JButton[]{leftButton == null ? this.getYesButton(leftButtonText, l) : leftButton, rightButton == null ? this.getNoButton(rightButtonText, l) : rightButton} : (type == 1 ? new JButton[]{this.getYesButton(leftButtonText, l), this.getNoButton(rightButtonText, l), this.getCancelButton(l)} : (type == 2 ? new JButton[]{leftButton == null ? this.getOkButton(leftButtonText, l) : leftButton, rightButton == null ? this.getCancelButton(rightButtonText, l) : rightButton} : new JButton[]{this.getOkButton(l)}));
        }
        return defaultOptions;
    }

    private JButton getYesButton(String text, Locale l) {
        if (text == null) {
            return this.getYesButton(l);
        }
        if (yesButton == null || !yesButton.getLocale().equals(l) || !text.equals(yesButton.getText())) {
            yesButton = ButtonFactory.createButton(text, text.charAt(0));
        }
        return yesButton;
    }

    private JButton getYesButton(Locale l) {
        if (yesButton == null || !yesButton.getLocale().equals(l)) {
            yesButton = ButtonFactory.createButton(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l));
        }
        return yesButton;
    }

    private JButton getNoButton(String text, Locale l) {
        if (text == null) {
            return this.getNoButton(l);
        }
        if (text != null && noButton == null || !noButton.getLocale().equals(l) || !text.equals(noButton.getText())) {
            noButton = ButtonFactory.createButton(text, text.charAt(0));
        }
        return noButton;
    }

    private JButton getNoButton(Locale l) {
        if (noButton == null || !noButton.getLocale().equals(l)) {
            noButton = ButtonFactory.createButton(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l));
        }
        return noButton;
    }

    private JButton getCancelButton(String text, Locale l) {
        if (text == null) {
            return this.getCancelButton(l);
        }
        if (cancelButton == null || !cancelButton.getLocale().equals(l) || !text.equals(cancelButton.getText())) {
            cancelButton = ButtonFactory.createButton(text, text.charAt(0));
        }
        return cancelButton;
    }

    private JButton getCancelButton(Locale l) {
        if (cancelButton == null || !cancelButton.getLocale().equals(l)) {
            cancelButton = ButtonFactory.createButton(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l));
        }
        return cancelButton;
    }

    private JButton getOkButton(String text, Locale l) {
        if (text == null) {
            return this.getOkButton(l);
        }
        if (text != null && okButton == null || !okButton.getLocale().equals(l) || !text.equals(okButton.getText())) {
            okButton = ButtonFactory.createButton(text, text.charAt(0));
        }
        return okButton;
    }

    private JButton getOkButton(Locale l) {
        if (okButton == null || !okButton.getLocale().equals(l)) {
            okButton = ButtonFactory.createButton(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l));
        }
        return okButton;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        super.addButtonComponents(container, buttons, initialIndex);
        for (int index = 0; index < buttons.length; ++index) {
            JButton aButton = (JButton)buttons[index];
            aButton.addActionListener(this.createButtonActionListener(index));
        }
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

