/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.UiResources;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class PatternflyProgressBarUI
extends BasicProgressBarUI {
    protected Rectangle componentInnards = new Rectangle();
    protected Rectangle oldComponentInnards = new Rectangle();
    protected double animationDelta;
    protected int maxPosition;

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        UIManager.put("ProgressBar.cycleTime", 1000);
        UIManager.put("ProgressBar.repaintInterval", 10);
        super.installDefaults();
        this.progressBar.setForeground(UiResources.progressBarGradientDark);
        this.progressBar.setBackground(Color.WHITE);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(-3, 0, -3, 0));
    }

    @Override
    protected Rectangle getBox(Rectangle rectangle) {
        int currentFrame = this.getAnimationIndex();
        if (this.sizeChanged() || this.animationDelta == 0.0 || (double)this.maxPosition == 0.0) {
            this.updateSizes();
        }
        rectangle = this.getGenericBox(rectangle);
        int filledAmount = this.getAmountFull(this.progressBar.getInsets(), this.getComponentInnards().width, this.getComponentInnards().height);
        this.adjustDelta(filledAmount);
        if (rectangle == null) {
            return null;
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.x = filledAmount + (int)Math.round(this.animationDelta * (double)currentFrame);
            if (rectangle.x >= this.maxPosition) {
                rectangle.x = filledAmount;
            }
        } else {
            rectangle.y = rectangle.y >= this.maxPosition ? this.getAmountFull(this.progressBar.getInsets(), this.getComponentInnards().width, this.getComponentInnards().height) + (int)Math.round(this.animationDelta * (double)currentFrame) : this.maxPosition - (int)Math.round(this.animationDelta * (double)currentFrame);
        }
        return rectangle;
    }

    private void adjustDelta(int filledAmount) {
        this.animationDelta = (this.getComponentInnards().width - filledAmount) / (this.getFrameCount() + 1);
    }

    protected Rectangle getGenericBox(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.width = this.getBoxLength(this.getComponentInnards().width, this.getComponentInnards().height);
            if (rectangle.width < 0) {
                rectangle = null;
            } else {
                rectangle.height = this.getComponentInnards().height;
                rectangle.y = this.getComponentInnards().y;
            }
        }
        return rectangle;
    }

    private void updateSizes() {
        if (this.progressBar.getOrientation() == 0) {
            int length = this.getBoxLength(this.getComponentInnards().width, this.getComponentInnards().height);
            this.maxPosition = this.getComponentInnards().x + this.getComponentInnards().width - length;
        } else {
            int length = this.getBoxLength(this.getComponentInnards().height, this.getComponentInnards().width);
            this.maxPosition = this.getComponentInnards().y + this.getComponentInnards().height - length;
        }
    }

    protected boolean sizeChanged() {
        if (this.oldComponentInnards == null || this.componentInnards == null) {
            return true;
        }
        this.oldComponentInnards.setRect(this.componentInnards);
        this.componentInnards = SwingUtilities.calculateInnerArea(this.progressBar, this.componentInnards);
        return !this.oldComponentInnards.equals(this.componentInnards);
    }

    protected Rectangle getComponentInnards() {
        return this.componentInnards;
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return Math.round(availableLength / 75);
    }

    @Override
    protected void paintIndeterminate(Graphics originalGraphic, JComponent c) {
        this.paintDeterminate(originalGraphic, c);
        super.paintIndeterminate(originalGraphic, c);
    }

    @Override
    protected void paintDeterminate(Graphics originalGraphic, JComponent c) {
        if (originalGraphic instanceof Graphics2D) {
            Insets barInsets = this.progressBar.getInsets();
            int graphicWidth = this.progressBar.getWidth() - (barInsets.right + barInsets.left);
            int graphicHeight = this.progressBar.getHeight() - (barInsets.top + barInsets.bottom);
            if (graphicWidth > 0 && graphicHeight > 0) {
                int amountToFill = this.getAmountFull(barInsets, graphicWidth, graphicHeight);
                Graphics2D g2d = (Graphics2D)originalGraphic;
                g2d.setPaint(new GradientPaint(barInsets.left, graphicHeight / 2 + barInsets.top, UiResources.progressBarGradientLight, amountToFill + barInsets.left, graphicHeight / 2 + barInsets.top, UiResources.progressBarGradientDark));
                g2d.fillRect(barInsets.left, barInsets.bottom, amountToFill + barInsets.left, graphicHeight);
                if (this.progressBar.isStringPainted()) {
                    this.paintString(originalGraphic, barInsets.left, barInsets.top, graphicWidth, graphicHeight, amountToFill, barInsets);
                }
            }
        }
    }
}

