/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.UiResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class PatternflyScrollBarUI
extends BasicScrollBarUI {
    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new CustomArrowButton(orientation, new Color(0xEFEFEF), new Color(0xEFEFEF), Color.GRAY, new Color(0xEFEFEF));
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new CustomArrowButton(orientation, new Color(0xEFEFEF), new Color(0xEFEFEF), Color.GRAY, new Color(0xEFEFEF));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        JScrollBar jsp = (JScrollBar)c;
        Container parent = jsp.getParent();
        if (parent.hasFocus() && parent instanceof JScrollPane) {
            this.focusThumb(g, this.getThumbBounds());
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.translate(thumbBounds.x, thumbBounds.y);
        g.setColor(new Color(0xCDCDCD));
        g.fillRect(0, 0, w - 1, h - 1);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    protected void focusThumb(Graphics g, Rectangle thumbBounds) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(UiResources.blueFocus);
        g2d.setStroke(new BasicStroke());
        g2d.draw(new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width - 1, thumbBounds.height - 1));
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyScrollBarUI();
    }

    public class CustomArrowButton
    extends BasicArrowButton {
        Color shadow;
        Color darkShadow;
        Color highlight;

        public CustomArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
            this.shadow = shadow;
            this.darkShadow = darkShadow;
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            Color origColor = g.getColor();
            boolean isPressed = this.getModel().isPressed();
            boolean isEnabled = this.isEnabled();
            g.setColor(this.getBackground());
            g.fillRect(1, 1, w, h);
            if (this.getBorder() != null && !(this.getBorder() instanceof UIResource)) {
                this.paintBorder(g);
            } else {
                g.drawLine(0, 0, 0, h);
                g.drawLine(1, 0, w, 0);
                g.setColor(this.darkShadow);
            }
            if (h < 5 || w < 5) {
                g.setColor(origColor);
                return;
            }
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
            g.setColor(origColor);
        }
    }
}

