/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.gui.patternfly.PatternflyProgressBarUI;
import com.izforge.izpack.installer.AbstractProgressDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ActionProgressDialog
extends AbstractProgressDialog {
    private String msg;
    private static final int dialogWidth = 400;
    private static final int dialogHeight = 100;
    private static final int barWidth = 400;
    private static final int barHeight = 10;
    private static final int progressPadding = 5;
    private static final int hGap = 20;

    public ActionProgressDialog(JFrame parent, String msg) {
        this.parent = parent;
        this.msg = msg;
        this.initDialog();
        this.thread = new AbstractProgressDialog.ProgressDialogThread();
    }

    protected void initDialog() {
        this.setSize(400, 100);
        JPanel main = this.initMainPanel();
        JLabel label = this.initLabel();
        this.progressBar = this.initProgressBar();
        main.add(label);
        main.add(this.progressBar);
        this.setWindowLocation();
        this.add(main);
    }

    private JPanel initMainPanel() {
        JPanel main = new JPanel();
        GridLayout layout = new GridLayout(0, 1);
        layout.setHgap(20);
        main.setLayout(layout);
        main.setSize(400, 100);
        main.setBorder(BorderFactory.createRaisedBevelBorder());
        return main;
    }

    private JLabel initLabel() {
        JLabel label = new JLabel(this.msg);
        label.setHorizontalAlignment(0);
        label.setBackground(Color.DARK_GRAY);
        return label;
    }

    private JProgressBar initProgressBar() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setUI(new PatternflyProgressBarUI());
        progressBar.setOpaque(false);
        progressBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        progressBar.setIndeterminate(true);
        progressBar.setPreferredSize(new Dimension(400, 10));
        progressBar.setMaximum(400);
        progressBar.setValue(0);
        return progressBar;
    }

    private void setWindowLocation() {
        if (this.parent == null) {
            this.centerToScreen();
        } else {
            this.centerToParent();
        }
    }

    private void centerToScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height / 2;
        int width = screenSize.width / 2;
        Dimension dialogSize = this.getSize();
        int myheight = dialogSize.height;
        int mywidth = dialogSize.width;
        this.setLocation(width - mywidth, height - myheight);
    }

    private void centerToParent() {
        Point loc = this.parent.getLocation();
        int pX = (int)loc.getX();
        int pY = (int)loc.getY();
        Dimension childSize = this.getSize();
        Dimension parentSize = this.parent.getSize();
        this.setLocation(pX + this.getDelta(parentSize.getWidth(), childSize.getWidth()), pY + this.getDelta(parentSize.getHeight(), childSize.getHeight()));
    }

    private int getDelta(double parentDim, double childDim) {
        return (int)((parentDim - childDim) / 2.0);
    }
}

