/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Info;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipOutputStream;

public class AutomatedInstallData
implements Serializable {
    public static final String MODIFY_INSTALLATION = "modify.izpack.install";
    public static final String INSTALLATION_INFORMATION = ".installationinformation";
    static final String[] CUSTOM_ACTION_TYPES = new String[]{"/installerListeners", "/uninstallerListeners", "/uninstallerLibs", "/uninstallerJars"};
    public static final int INSTALLER_LISTENER_INDEX = 0;
    public static final int UNINSTALLER_LISTENER_INDEX = 1;
    public static final int UNINSTALLER_LIBS_INDEX = 2;
    public static final int UNINSTALLER_JARS_INDEX = 3;
    private RulesEngine rules;
    public String localeISO3;
    public Locale locale;
    public LocaleDatabase langpack;
    public ZipOutputStream uninstallOutJar;
    public Info info;
    public List<Pack> allPacks;
    public List<Pack> availablePacks = new ArrayList<Pack>();
    public static Map<String, Pack> availablePacksMap = new HashMap<String, Pack>();
    public List<Pack> selectedPacks = new ArrayList<Pack>();
    public List<IzPanel> panels = new ArrayList<IzPanel>();
    public List<ConsoleInfo> consoles = new ArrayList<ConsoleInfo>();
    public List<Panel> panelsOrder = new ArrayList<Panel>();
    public int curPanelNumber;
    public boolean canClose = false;
    public boolean installSuccess = true;
    public IXMLElement xmlData;
    public Map<String, List> customData;
    protected Properties variables;
    protected Map<String, Object> attributes;
    public List<String> autoPromptVars = new ArrayList<String>();
    public List<String> tmpFiles;
    private static AutomatedInstallData self = null;

    public static AutomatedInstallData getInstance() {
        return self;
    }

    public AutomatedInstallData() {
        this.xmlData = new XMLElementImpl("AutomatedInstallation");
        this.variables = new Properties();
        this.attributes = new HashMap<String, Object>();
        this.customData = new HashMap<String, List>();
        this.tmpFiles = new ArrayList<String>();
        if (self != null) {
            throw new RuntimeException("Panic!! second call of the InstallData Ctor!!");
        }
        self = this;
    }

    public Properties getVariables() {
        return this.variables;
    }

    public void setVariable(String var, String val) {
        this.variables.setProperty(var, val);
    }

    public String getVariable(String var) {
        return this.variables.getProperty(var);
    }

    public void setInstallPath(String path) {
        if (new File(path).exists()) {
            this.setVariable("PRE_EXISTING_INSTALL_PATH", "true");
        } else {
            this.setVariable("PRE_EXISTING_INSTALL_PATH", "false");
        }
        this.setVariable("INSTALL_PATH", path);
    }

    public String getInstallPath() {
        return this.getVariable("INSTALL_PATH");
    }

    public Object getAttribute(String attr) {
        return this.attributes.get(attr);
    }

    public void setAttribute(String attr, Object val) {
        if (val == null) {
            this.attributes.remove(attr);
        } else {
            this.attributes.put(attr, val);
        }
    }

    public void addTmpFile(String path) {
        this.tmpFiles.add(path);
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    public void removePackFromSelected(String packId) {
        Pack pack = this.getPackage(packId);
        if (!this.selectedPacks.contains(pack)) {
            Debug.log("Attempted to deselect pack " + packId + ": but pack was not selected.");
            return;
        }
        Debug.log("Deselected pack " + packId + ".");
        this.selectedPacks.remove(pack);
    }

    public void addPackToSelected(String packId) {
        Pack pack = this.getPackage(packId);
        if (pack == null) {
            Debug.log("No pack found: " + packId + ".");
            return;
        }
        if (this.selectedPacks.contains(pack)) {
            Debug.log("Pack is already in selected list: " + packId + ".");
            return;
        }
        Debug.log("Selected pack " + packId + ".");
        this.selectedPacks.add(pack);
    }

    public void setPackSelectable(String packId, boolean selectable) {
        Pack pack = this.getPackage(packId);
        if (pack == null) {
            Debug.log("No pack found: " + packId + ".");
            return;
        }
        pack.selectable = selectable;
    }

    public void setPackPreselected(String packId, boolean preselected) {
        Pack pack = this.getPackage(packId);
        if (pack == null) {
            Debug.log("No pack found: " + packId + ".");
            return;
        }
        pack.preselected = preselected;
    }

    public Pack getPackage(String packId) {
        if (!availablePacksMap.containsKey(packId)) {
            Debug.log(packId + ": pack id not found.");
            return null;
        }
        return availablePacksMap.get(packId);
    }

    public static class ConsoleInfo {
        public Panel panel;
        public PanelConsole console;

        ConsoleInfo(PanelConsole iConsole, Panel iP) {
            this.panel = iP;
            this.console = iConsole;
        }
    }
}

