/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.CompileHandler;
import com.izforge.izpack.installer.CompileResult;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class CompileWorker
implements Runnable {
    private ArrayList<CompilationJob> jobs;
    private static final String SPEC_RESOURCE_NAME = "CompilePanel.Spec.xml";
    private static final String ECLIPSE_COMPILER_NAME = "Integrated Eclipse JDT Compiler";
    private static final String ECLIPSE_COMPILER_CLASS = "org.eclipse.jdt.internal.compiler.batch.Main";
    private VariableSubstitutor vs;
    private IXMLElement spec;
    private AutomatedInstallData idata;
    private CompileHandler handler;
    private IXMLElement compilerSpec;
    private ArrayList<String> compilerList;
    private String compilerToUse;
    private IXMLElement compilerArgumentsSpec;
    private ArrayList<String> compilerArgumentsList;
    private String compilerArgumentsToUse;
    private CompileResult result = null;

    public CompileWorker(AutomatedInstallData idata, CompileHandler handler) throws IOException {
        this.idata = idata;
        this.handler = handler;
        this.vs = new VariableSubstitutor(idata.getVariables());
        if (!this.readSpec()) {
            throw new IOException("Error reading compilation specification");
        }
    }

    public ArrayList<String> getAvailableCompilers() {
        this.readChoices(this.compilerSpec, this.compilerList);
        return this.compilerList;
    }

    public void setCompiler(String compiler) {
        this.compilerToUse = compiler;
    }

    public String getCompiler() {
        return this.compilerToUse;
    }

    public ArrayList<String> getAvailableArguments() {
        this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
        return this.compilerArgumentsList;
    }

    public void setCompilerArguments(String arguments) {
        this.compilerArgumentsToUse = arguments;
    }

    public String getCompilerArguments() {
        return this.compilerArgumentsToUse;
    }

    public CompileResult getResult() {
        return this.result;
    }

    public void startThread() {
        Thread compilationThread = new Thread((Runnable)this, "compilation thread");
        compilationThread.start();
    }

    @Override
    public void run() {
        try {
            if (!this.collectJobs()) {
                ArrayList<String> args = new ArrayList<String>();
                args.add("nothing to do");
                this.result = new CompileResult(this.idata.langpack.getString("CompilePanel.worker.nofiles"), args, "", "");
            } else {
                this.result = this.compileJobs();
            }
        }
        catch (Exception e) {
            this.result = new CompileResult(e);
        }
        this.handler.stopAction();
    }

    private boolean readSpec() {
        InputStream input;
        try {
            input = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        XMLParser parser = new XMLParser();
        try {
            this.spec = parser.parse(input);
        }
        catch (Exception e) {
            System.out.println("Error parsing XML specification for compilation.");
            e.printStackTrace();
            return false;
        }
        if (!this.spec.hasChildren()) {
            return false;
        }
        this.compilerArgumentsList = new ArrayList();
        this.compilerList = new ArrayList();
        IXMLElement global = this.spec.getFirstChildNamed("global");
        if (global != null) {
            this.compilerSpec = global.getFirstChildNamed("compiler");
            if (this.compilerSpec != null) {
                this.readChoices(this.compilerSpec, this.compilerList);
            }
            this.compilerArgumentsSpec = global.getFirstChildNamed("arguments");
            if (this.compilerArgumentsSpec != null) {
                this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
            }
        }
        if (this.compilerList.size() == 0) {
            this.compilerList.add("javac");
            this.compilerList.add("jikes");
        }
        if (this.compilerArgumentsList.size() == 0) {
            this.compilerArgumentsList.add("-O -g:none");
            this.compilerArgumentsList.add("-O");
            this.compilerArgumentsList.add("-g");
            this.compilerArgumentsList.add("");
        }
        return true;
    }

    private void readChoices(IXMLElement element, ArrayList<String> choiceList) {
        Vector<IXMLElement> choices = element.getChildrenNamed("choice");
        if (choices == null) {
            return;
        }
        choiceList.clear();
        for (IXMLElement choice : choices) {
            List<OsConstraint> osconstraints;
            String value = choice.getAttribute("value");
            if (value == null || !OsConstraint.oneMatchesCurrentSystem(osconstraints = OsConstraint.getOsList(choice))) continue;
            if (value.equalsIgnoreCase(ECLIPSE_COMPILER_NAME)) {
                try {
                    Class.forName(ECLIPSE_COMPILER_CLASS);
                    choiceList.add(value);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            choiceList.add(this.vs.substitute(value, "plain"));
        }
    }

    private boolean collectJobs() throws Exception {
        IXMLElement data = this.spec.getFirstChildNamed("jobs");
        if (data == null) {
            return false;
        }
        ArrayList classpath = new ArrayList();
        this.jobs = new ArrayList();
        this.collectJobsRecursive(data, classpath);
        return true;
    }

    private CompileResult compileJobs() {
        CompilationJob first_job;
        CompileResult check_result;
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.compilerArgumentsToUse);
        while (tokenizer.hasMoreTokens()) {
            args.add(tokenizer.nextToken());
        }
        Iterator<CompilationJob> job_it = this.jobs.iterator();
        this.handler.startAction("Compilation", this.jobs.size());
        if (job_it.hasNext() && !(check_result = (first_job = this.jobs.get(0)).checkCompiler(this.compilerToUse, args)).isContinue()) {
            return check_result;
        }
        int job_no = 0;
        while (job_it.hasNext()) {
            CompilationJob job = job_it.next();
            this.handler.nextStep(job.getName(), job.getSize(), job_no++);
            CompileResult job_result = job.perform(this.compilerToUse, args);
            if (job_result.isContinue()) continue;
            return job_result;
        }
        Debug.trace("compilation finished.");
        return new CompileResult();
    }

    private CompilationJob collectJobsRecursive(IXMLElement node, ArrayList classpath) throws Exception {
        Vector<IXMLElement> toplevel_tags = node.getChildren();
        ArrayList ourclasspath = (ArrayList)classpath.clone();
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < toplevel_tags.size(); ++i) {
            String finalname;
            String name;
            IXMLElement child = toplevel_tags.elementAt(i);
            if ("classpath".equals(child.getName())) {
                this.changeClassPath(ourclasspath, child);
                continue;
            }
            if ("job".equals(child.getName())) {
                CompilationJob subjob = this.collectJobsRecursive(child, ourclasspath);
                if (subjob == null) continue;
                this.jobs.add(subjob);
                continue;
            }
            if ("directory".equals(child.getName())) {
                name = child.getAttribute("name");
                if (name == null) continue;
                finalname = this.vs.substitute(name, "plain");
                files.addAll(this.scanDirectory(new File(finalname)));
                continue;
            }
            if ("file".equals(child.getName())) {
                name = child.getAttribute("name");
                if (name == null) continue;
                finalname = this.vs.substitute(name, "plain");
                files.add(new File(finalname));
                continue;
            }
            if (!"packdepency".equals(child.getName())) continue;
            name = child.getAttribute("name");
            if (name == null) {
                System.out.println("invalid compilation spec: <packdepency> without name attribute");
                return null;
            }
            Iterator<Pack> pack_it = this.idata.selectedPacks.iterator();
            boolean found = false;
            while (pack_it.hasNext()) {
                Pack pack = pack_it.next();
                if (!pack.name.equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Debug.trace("skipping job because pack " + name + " was not selected.");
            return null;
        }
        if (files.size() > 0) {
            return new CompilationJob(this.handler, this.idata, node.getAttribute("name"), files, ourclasspath);
        }
        return null;
    }

    private void changeClassPath(ArrayList classpath, IXMLElement child) throws Exception {
        String sub;
        String add = child.getAttribute("add");
        if (add != null) {
            if (!new File(add = this.vs.substitute(add, "plain")).exists()) {
                if (!this.handler.emitWarning("Invalid classpath", "The path " + add + " could not be found.\nCompilation may fail.")) {
                    throw new Exception("Classpath " + add + " does not exist.");
                }
            } else {
                classpath.add(this.vs.substitute(add, "plain"));
            }
        }
        if ((sub = child.getAttribute("sub")) != null) {
            int cpidx = -1;
            sub = this.vs.substitute(sub, "plain");
            do {
                cpidx = classpath.indexOf(sub);
                classpath.remove(cpidx);
            } while (cpidx >= 0);
        }
    }

    private ArrayList<File> scanDirectory(File path) {
        File[] entries;
        Debug.trace("scanning directory " + path.getAbsolutePath());
        ArrayList<File> scan_result = new ArrayList<File>();
        if (!path.isDirectory()) {
            return scan_result;
        }
        for (File f : entries = path.listFiles()) {
            if (f == null) continue;
            if (f.isDirectory()) {
                scan_result.addAll(this.scanDirectory(f));
                continue;
            }
            if (!f.isFile() || !f.getName().toLowerCase().endsWith(".java")) continue;
            scan_result.add(f);
        }
        return scan_result;
    }

    private static class StdErrParser
    extends StreamParser {
        int errorCount;

        private StdErrParser() {
        }

        @Override
        int parse(byte[] buf, int off, int len) {
            super.init(buf, off, len);
            this.errorCount = 0;
            while (this.findString(". ERROR in ")) {
                ++this.errorCount;
            }
            return this.errorCount;
        }

        int getErrorCount() {
            return this.errorCount;
        }
    }

    private static class StdOutParser
    extends StreamParser {
        int fileno;
        int jobSize;
        String lastFilename;

        private StdOutParser() {
        }

        @Override
        int parse(byte[] buf, int off, int len) {
            super.init(buf, off, len);
            this.fileno = -1;
            this.jobSize = -1;
            this.lastFilename = null;
            while (this.findString("[completed ") && this.skipSpaces() && this.readIdentifier()) {
                String filename = new String(this.lastIdentifier);
                if (!this.skipSpaces()) continue;
                int _c = this.getNext();
                if (_c == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (_c != 45 || !this.skipSpaces()) continue;
                _c = this.getNext();
                if (_c == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (_c != 35) continue;
                if (!this.readNumber()) {
                    return this.fileno;
                }
                int _fileno = this.lastDigit;
                _c = this.getNext();
                if (_c == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (_c != 47) continue;
                if (!this.readNumber()) {
                    return this.fileno;
                }
                _c = this.getNext();
                if (_c == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (_c != 93) continue;
                this.lastFilename = filename;
                this.fileno = _fileno;
                this.jobSize = this.lastDigit;
            }
            return this.fileno;
        }

        String getLastFilename() {
            return this.lastFilename;
        }

        int getJobSize() {
            return this.jobSize;
        }
    }

    private static abstract class StreamParser {
        int idx;
        byte[] buffer;
        int offset;
        int length;
        byte[] lastIdentifier;
        int lastDigit;

        private StreamParser() {
        }

        abstract int parse(byte[] var1, int var2, int var3);

        void init(byte[] buf, int off, int len) {
            this.buffer = buf;
            this.offset = off;
            this.length = len;
            this.idx = 0;
            this.lastIdentifier = null;
            this.lastDigit = -1;
        }

        int getNext() {
            if (this.offset + this.idx == this.length) {
                return Integer.MIN_VALUE;
            }
            return this.buffer[this.offset + this.idx++];
        }

        boolean findString(String aString) {
            byte[] _search_bytes = aString.getBytes();
            int _search_idx = 0;
            do {
                int _c;
                if ((_c = this.getNext()) == Integer.MIN_VALUE) {
                    return false;
                }
                if (_c == _search_bytes[_search_idx]) {
                    ++_search_idx;
                    continue;
                }
                _search_idx = 0;
                if (_c != _search_bytes[_search_idx]) continue;
                ++_search_idx;
            } while (_search_idx < _search_bytes.length);
            return true;
        }

        boolean readIdentifier() {
            int _c;
            int _start_idx = this.idx;
            do {
                if ((_c = this.getNext()) != Integer.MIN_VALUE) continue;
                return false;
            } while (!Character.isWhitespace((char)_c));
            --this.idx;
            this.lastIdentifier = new byte[this.idx - _start_idx];
            System.arraycopy(this.buffer, _start_idx, this.lastIdentifier, 0, this.idx - _start_idx);
            return true;
        }

        boolean readNumber() {
            int _c;
            int _start_idx = this.idx;
            do {
                if ((_c = this.getNext()) != Integer.MIN_VALUE) continue;
                return false;
            } while (Character.isDigit((char)_c));
            --this.idx;
            String _digit_str = new String(this.buffer, _start_idx, this.idx - _start_idx);
            try {
                this.lastDigit = Integer.parseInt(_digit_str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }

        boolean skipSpaces() {
            int _c;
            do {
                if ((_c = this.getNext()) != Integer.MIN_VALUE) continue;
                return false;
            } while (Character.isWhitespace((char)_c));
            --this.idx;
            return true;
        }
    }

    private static class EclipseStdErrHandler
    extends PrintStream {
        private int errorCount = 0;
        private StdErrParser parser = new StdErrParser();

        public EclipseStdErrHandler(OutputStream anOutputStream, CompileHandler aHandler) {
            super(anOutputStream);
        }

        @Override
        public void println(String x) {
            if (x.indexOf(". ERROR in ") > 0) {
                ++this.errorCount;
            }
            super.println(x);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            int _errno = this.parser.parse(buf, off, len);
            if (_errno > 0) {
                this.errorCount += _errno;
            }
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }

    private static class EclipseStdOutHandler
    extends PrintStream {
        private CompileHandler listener;
        private StdOutParser parser;

        public EclipseStdOutHandler(OutputStream anOutputStream, CompileHandler aHandler) {
            super(anOutputStream);
            this.listener = aHandler;
            this.parser = new StdOutParser();
        }

        @Override
        public void println(String x) {
            if (x.startsWith("[completed ")) {
                int pos = x.lastIndexOf("#");
                int endpos = x.lastIndexOf("/");
                String fileno_str = x.substring(pos + 1, endpos - pos - 1);
                try {
                    int fileno = Integer.parseInt(fileno_str);
                    this.listener.progress(fileno, x);
                }
                catch (NumberFormatException _nfe) {
                    Debug.log("could not parse eclipse compiler output: '" + x + "': " + _nfe.getMessage());
                }
            }
            super.println(x);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            int _fileno = this.parser.parse(buf, off, len);
            if (_fileno > -1) {
                this.listener.setSubStepNo(this.parser.getJobSize());
                this.listener.progress(_fileno, this.parser.getLastFilename());
            }
        }
    }

    private static class CompilationJob {
        private CompileHandler listener;
        private String name;
        private ArrayList<File> files;
        private ArrayList classpath;
        private LocaleDatabase langpack;
        private AutomatedInstallData idata;
        private static final int MAX_CMDLINE_SIZE = 4096;

        public CompilationJob(CompileHandler listener, AutomatedInstallData idata, String name, ArrayList<File> files, ArrayList classpath) {
            this.listener = listener;
            this.idata = idata;
            this.langpack = idata.langpack;
            this.name = name;
            this.files = files;
            this.classpath = classpath;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return "";
        }

        public int getSize() {
            return this.files.size();
        }

        public CompileResult perform(String compiler, ArrayList<String> arguments) {
            Debug.trace("starting job " + this.name);
            int cmdline_len = 0;
            LinkedList<String> args = new LinkedList<String>(arguments);
            Iterator arg_it = args.iterator();
            while (arg_it.hasNext()) {
                cmdline_len += ((String)arg_it.next()).length() + 1;
            }
            boolean isEclipseCompiler = compiler.equalsIgnoreCase(CompileWorker.ECLIPSE_COMPILER_NAME);
            args.add(0, compiler);
            cmdline_len += compiler.length() + 1;
            StringBuffer classpath_sb = new StringBuffer();
            for (String cp : this.classpath) {
                if (classpath_sb.length() > 0) {
                    classpath_sb.append(File.pathSeparatorChar);
                }
                classpath_sb.append(new File(cp).getAbsolutePath());
            }
            String classpath_str = classpath_sb.toString();
            if (classpath_str.length() > 0) {
                args.add("-classpath");
                cmdline_len += 11;
                args.add(classpath_str);
                cmdline_len += classpath_str.length() + 1;
            }
            int common_args_no = args.size();
            int common_args_len = cmdline_len;
            FileExecutor executor = new FileExecutor();
            String[] output = new String[2];
            String jobfiles = "";
            int fileno = 0;
            int last_fileno = 0;
            for (File f : this.files) {
                String fpath = f.getAbsolutePath();
                Debug.trace("processing " + fpath);
                ++fileno;
                jobfiles = jobfiles + f.getName() + " ";
                args.add(fpath);
                if (isEclipseCompiler || (cmdline_len += fpath.length()) < 4096) continue;
                Debug.trace("compiling " + jobfiles);
                this.listener.progress(last_fileno, jobfiles);
                last_fileno = fileno;
                int retval = this.runCompiler(executor, output, args);
                this.listener.progress(fileno, jobfiles);
                if (retval != 0) {
                    CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error"), args, output[0], output[1]);
                    this.listener.handleCompileError(result);
                    if (!result.isContinue()) {
                        return result;
                    }
                } else {
                    ListIterator<String> arg_it2 = args.listIterator(common_args_no);
                    while (arg_it2.hasNext()) {
                        File java_file = new File((String)arg_it2.next());
                        String basename = java_file.getName();
                        int dotpos = basename.lastIndexOf(46);
                        basename = basename.substring(0, dotpos) + ".class";
                        File class_file = new File(java_file.getParentFile(), basename);
                        if (class_file.exists()) continue;
                        CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error.noclassfile") + java_file.getAbsolutePath(), args, output[0], output[1]);
                        this.listener.handleCompileError(result);
                        if (result.isContinue()) break;
                        return result;
                    }
                }
                for (int i = args.size() - 1; i >= common_args_no; --i) {
                    args.removeLast();
                }
                cmdline_len = common_args_len;
                jobfiles = "";
            }
            if (cmdline_len > common_args_len) {
                this.listener.progress(last_fileno, jobfiles);
                int retval = this.runCompiler(executor, output, args);
                if (!isEclipseCompiler) {
                    this.listener.progress(fileno, jobfiles);
                }
                if (retval != 0) {
                    CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error"), args, output[0], output[1]);
                    this.listener.handleCompileError(result);
                    if (!result.isContinue()) {
                        return result;
                    }
                } else {
                    ListIterator<String> arg_it3 = args.listIterator(common_args_no);
                    while (arg_it3.hasNext()) {
                        File java_file = new File((String)arg_it3.next());
                        String basename = java_file.getName();
                        int dotpos = basename.lastIndexOf(46);
                        basename = basename.substring(0, dotpos) + ".class";
                        File class_file = new File(java_file.getParentFile(), basename);
                        if (class_file.exists()) continue;
                        CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error.noclassfile") + java_file.getAbsolutePath(), args, output[0], output[1]);
                        this.listener.handleCompileError(result);
                        if (result.isContinue()) break;
                        return result;
                    }
                }
            }
            Debug.trace("job " + this.name + " done (" + fileno + " files compiled)");
            return new CompileResult();
        }

        private int runCompiler(FileExecutor executor, String[] output, List<String> cmdline) {
            if (cmdline.get(0).equals(CompileWorker.ECLIPSE_COMPILER_NAME)) {
                return this.runEclipseCompiler(output, cmdline);
            }
            return executor.executeCommand(cmdline.toArray(new String[cmdline.size()]), output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runEclipseCompiler(String[] output, List<String> cmdline) {
            try {
                LinkedList<String> final_cmdline = new LinkedList<String>(cmdline);
                final_cmdline.remove(0);
                Class<?> eclipseCompiler = Class.forName(CompileWorker.ECLIPSE_COMPILER_CLASS);
                Method compileMethod = eclipseCompiler.getMethod("main", String[].class);
                final_cmdline.add(0, "-noExit");
                final_cmdline.add(0, "-progress");
                final_cmdline.add(0, "-verbose");
                File _logfile = new File(this.idata.getInstallPath(), "compile-" + this.getName() + ".log");
                if (Debug.isTRACE()) {
                    final_cmdline.add(0, _logfile.getPath());
                    final_cmdline.add(0, "-log");
                }
                try {
                    PrintStream _orgStdout = System.out;
                    PrintStream _orgStderr = System.err;
                    int error_count = 0;
                    try {
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        EclipseStdOutHandler ownStdout = new EclipseStdOutHandler((OutputStream)outStream, this.listener);
                        System.setOut(ownStdout);
                        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
                        EclipseStdErrHandler ownStderr = new EclipseStdErrHandler((OutputStream)errStream, this.listener);
                        System.setErr(ownStderr);
                        compileMethod.invoke(null, new Object[]{final_cmdline.toArray(new String[final_cmdline.size()])});
                        output[0] = outStream.toString();
                        output[1] = errStream.toString();
                        error_count = ownStderr.getErrorCount();
                        if (error_count > 0 || Debug.isTRACE()) {
                            File _out = new File(_logfile.getPath() + ".stdout");
                            FileOutputStream _fout = new FileOutputStream(_out);
                            _fout.write(outStream.toByteArray());
                            _fout.close();
                            _out = new File(_logfile.getPath() + ".stderr");
                            _fout = new FileOutputStream(_out);
                            _fout.write(errStream.toByteArray());
                            _fout.close();
                        }
                    }
                    finally {
                        System.setOut(_orgStdout);
                        System.setErr(_orgStderr);
                    }
                    if (error_count == 0) {
                        return 0;
                    }
                    this.listener.emitNotification("Compiler reported " + error_count + " errors");
                    return 1;
                }
                catch (FileNotFoundException fnfe) {
                    this.listener.emitError("error compiling", fnfe.getMessage());
                    return -1;
                }
                catch (IOException ioe) {
                    this.listener.emitError("error compiling", ioe.getMessage());
                    return -1;
                }
            }
            catch (ClassNotFoundException cnfe) {
                output[0] = "error getting eclipse compiler";
                output[1] = cnfe.getMessage();
                return -1;
            }
            catch (NoSuchMethodException nsme) {
                output[0] = "error getting eclipse compiler method";
                output[1] = nsme.getMessage();
                return -1;
            }
            catch (IllegalAccessException iae) {
                output[0] = "error calling eclipse compiler";
                output[1] = iae.getMessage();
                return -1;
            }
            catch (InvocationTargetException ite) {
                output[0] = "error calling eclipse compiler";
                output[1] = ite.getMessage();
                return -1;
            }
        }

        public CompileResult checkCompiler(String compiler, ArrayList<String> arguments) {
            if (compiler.equalsIgnoreCase(CompileWorker.ECLIPSE_COMPILER_NAME)) {
                return new CompileResult();
            }
            int retval = 0;
            FileExecutor executor = new FileExecutor();
            String[] output = new String[2];
            Debug.trace("checking whether \"" + compiler + " -help\" works");
            AbstractList args = new ArrayList<String>();
            args.add(compiler);
            args.add("-help");
            retval = this.runCompiler(executor, output, args);
            if (retval != 0) {
                CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error.compilernotfound"), args, output[0], output[1]);
                this.listener.handleCompileError(result);
                if (!result.isContinue()) {
                    return result;
                }
            }
            Debug.trace("checking whether \"" + compiler + " -help +arguments\" works");
            args = new LinkedList<String>(arguments);
            ((LinkedList)args).add(0, (String)"-help");
            ((LinkedList)args).add(0, compiler);
            StringBuffer classpath_sb = new StringBuffer();
            for (String cp : this.classpath) {
                if (classpath_sb.length() > 0) {
                    classpath_sb.append(File.pathSeparatorChar);
                }
                classpath_sb.append(new File(cp).getAbsolutePath());
            }
            String classpath_str = classpath_sb.toString();
            if (classpath_str.length() > 0) {
                ((LinkedList)args).add("-classpath");
                ((LinkedList)args).add(classpath_str);
            }
            if ((retval = this.runCompiler(executor, output, args)) != 0) {
                CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error.invalidarguments"), args, output[0], output[1]);
                this.listener.handleCompileError(result);
                if (!result.isContinue()) {
                    return result;
                }
            }
            return new CompileResult();
        }
    }
}

