/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.adaptator.impl.XMLWriter;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.AutomatedInstaller;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ParameteredDataValidator;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.SetWarningDefault;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.SkippableDataValidator;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.ValidatorMap;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ConsoleInstaller
extends InstallerBase {
    private AutomatedInstallData installdata;
    private boolean result = false;
    private Properties properties;
    private PrintWriter printWriter;
    private ZipOutputStream outJar;
    private static String EAP = "eap";
    private static String DEFAULT_LANG = "eng";

    public ConsoleInstaller(String langcode) throws Exception {
        this.init(langcode);
    }

    public ConsoleInstaller(String langcode, Map<String, String> argVariables) throws Exception {
        this.init(langcode);
        this.loadCommandLineVariables(argVariables, this.installdata);
    }

    private void init(String langcode) throws Exception {
        block12: {
            block13: {
                int def;
                block10: {
                    block11: {
                        this.installdata = new AutomatedInstallData();
                        this.loadInstallData(this.installdata);
                        if (this.installdata.getVariable("product.name").equals("eap")) break block11;
                        this.installdata.localeISO3 = DEFAULT_LANG;
                        break block12;
                    }
                    if (langcode != null) break block13;
                    InstallerBase.setLangBackup(this.getAvailableLangPacks().get(0));
                    String firstMessage = (String)languagePickerInstructions.get(Locale.getDefault().getLanguage());
                    if (firstMessage == null) {
                        firstMessage = (String)languagePickerInstructions.get(Locale.ENGLISH.getLanguage());
                    }
                    System.out.println(firstMessage + " : ");
                    for (String lang : this.getAvailableLangPacks()) {
                        System.out.println(this.getAvailableLangPacks().indexOf(lang) + ": " + this.getNativeDisplayLanguage(lang));
                    }
                    int val = 0;
                    String iso3Default = Locale.getDefault().getISO3Language().toLowerCase();
                    if (iso3Default.equals("zho")) {
                        iso3Default = "chn";
                    }
                    def = (def = this.getAvailableLangPacks().indexOf(iso3Default)) < 0 ? 0 : def;
                    while (true) {
                        System.out.println("Please choose [" + def + "] : ");
                        String in = AeshReadlineConsole.readLine();
                        if (in.trim().length() == 0) break block10;
                        try {
                            val = Integer.valueOf(in);
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        if (val >= 0 && val <= this.getAvailableLangPacks().size() - 1) break;
                    }
                    this.installdata.localeISO3 = this.getAvailableLangPacks().get(val);
                    break block12;
                }
                this.installdata.localeISO3 = this.getAvailableLangPacks().get(def);
                break block12;
            }
            if (!this.getAvailableLangPacks().contains(langcode)) {
                if (this.installdata.localeISO3 != null) {
                    System.out.println("Language " + langcode + " not found in supported langpacks");
                }
                this.installdata.localeISO3 = this.getAvailableLangPacks().get(0);
            } else {
                this.installdata.localeISO3 = langcode;
            }
        }
        this.installdata.xmlData.setAttribute("langpack", this.installdata.localeISO3);
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.installdata.localeISO3 + ".xml");
        XMLElementImpl productNameNode = new XMLElementImpl(AutomatedInstaller.PRODUCT_NAME_TAG, this.installdata.xmlData);
        productNameNode.setContent(this.installdata.getVariable("product.name").toUpperCase());
        this.installdata.xmlData.addChild(productNameNode);
        XMLElementImpl productVersionNode = new XMLElementImpl(AutomatedInstaller.PRODUCT_VERSION_TAG, this.installdata.xmlData);
        productVersionNode.setContent(this.installdata.info.getAppVersion());
        this.installdata.xmlData.addChild(productVersionNode);
        this.installdata.langpack = new LocaleDatabase(in);
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        ResourceManager.create(this.installdata);
        this.loadConditions(this.installdata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        this.addBackupLangpack(this.installdata);
        this.addCustomLangpack(this.installdata);
        this.checkJavaVersion();
        this.installdata.setVariable("installerMode", "CLI");
    }

    private void checkJavaVersion() throws Exception {
        String required;
        String version = System.getProperty("java.version");
        if (version.compareTo(required = this.installdata.info.getJavaVersion()) < 0) {
            String msgError = this.installdata.langpack.getString("java.mismatch.error");
            msgError = msgError.replaceFirst("@@", required).replaceFirst("@@", version);
            System.out.println(StringTool.formatForNewLine(msgError));
            AeshReadlineConsole.closeConnection();
            System.exit(1);
        }
    }

    private String read() throws Exception {
        byte[] byteArray = new byte[]{(byte)System.in.read()};
        return new String(byteArray);
    }

    private String readln() throws Exception {
        String input = this.read();
        int available = System.in.available();
        if (available > 0) {
            byte[] byteArray = new byte[available];
            System.in.read(byteArray);
            input = input + new String(byteArray);
        }
        return input.trim();
    }

    protected void iterateAndPerformAction(String strAction) throws Exception {
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        Debug.log("[ Starting console installation ] " + strAction);
        try {
            this.result = true;
            Iterator<Panel> panelsIterator = this.installdata.panelsOrder.iterator();
            this.installdata.curPanelNumber = -1;
            VariableSubstitutor substitutor = new VariableSubstitutor(this.installdata.getVariables());
            while (panelsIterator.hasNext()) {
                Panel p = panelsIterator.next();
                ++this.installdata.curPanelNumber;
                String praefix = "com.izforge.izpack.panels.";
                if (p.className.compareTo(".") > -1) {
                    praefix = "";
                }
                if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
                XMLElementImpl panelRoot = new XMLElementImpl(p.className, this.installdata.xmlData);
                String panelId = p.getPanelid();
                if (panelId != null) {
                    panelRoot.setAttribute("id", panelId);
                }
                this.installdata.xmlData.addChild(panelRoot);
                String panelClassName = p.className;
                String consoleHelperClassName = praefix + panelClassName + "ConsoleHelper";
                Class<?> consoleHelperClass = null;
                Debug.log("ConsoleHelper:" + consoleHelperClassName);
                try {
                    this.runPreConstructionActions(p);
                    consoleHelperClass = Class.forName(consoleHelperClassName);
                }
                catch (ClassNotFoundException e) {
                    String panelCondition;
                    Debug.log("ClassNotFoundException-skip :" + consoleHelperClassName);
                    if (consoleHelperClassName.endsWith("SummaryPanelConsoleHelper") && ((panelCondition = p.getCondition()) == null || this.installdata.getRules().isConditionTrue(panelCondition))) {
                        this.runPostValidationActions(p);
                    }
                    this.installdata.consoles.add(null);
                    continue;
                }
                PanelConsole consoleHelperInstance = null;
                if (consoleHelperClass != null) {
                    try {
                        Debug.log("Instantiate :" + consoleHelperClassName);
                        this.refreshDynamicVariables(substitutor, this.installdata);
                        consoleHelperInstance = (PanelConsole)consoleHelperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        Debug.log("ERROR: no default constructor for " + consoleHelperClassName + ", skipping...");
                        this.installdata.consoles.add(new AutomatedInstallData.ConsoleInfo(consoleHelperInstance, p));
                        continue;
                    }
                }
                this.installdata.consoles.add(new AutomatedInstallData.ConsoleInfo(consoleHelperInstance, p));
                if (consoleHelperInstance == null) continue;
                try {
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " entered.");
                    boolean bActionResult = true;
                    boolean bIsConditionFulfilled = true;
                    String strCondition = p.getCondition();
                    if (strCondition != null) {
                        bIsConditionFulfilled = this.installdata.getRules().isConditionTrue(strCondition);
                    }
                    if (strAction.equals("doInstall") && bIsConditionFulfilled) {
                        this.runPreActivateActions(p);
                        while ((bActionResult = consoleHelperInstance.runConsole(this.installdata, this)) && !this.validatePanel(p)) {
                        }
                    } else if (strAction.equals("doGeneratePropertiesFile")) {
                        bActionResult = consoleHelperInstance.runGeneratePropertiesFile(this.installdata, this.printWriter);
                    } else if (strAction.equals("doInstallFromPropertiesFile") && bIsConditionFulfilled) {
                        bActionResult = consoleHelperInstance.runConsoleFromPropertiesFile(this.installdata, this.properties);
                    }
                    if (!bActionResult) {
                        this.result = false;
                        return;
                    }
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " successfully done.");
                    if (!bIsConditionFulfilled) continue;
                    this.runPostValidationActions(p);
                }
                catch (InstallerException e) {
                    Debug.log("ERROR: console installation failed for panel " + panelClassName);
                    System.out.println("Console Installation failed for panel " + panelClassName);
                    this.result = false;
                    Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                    AeshReadlineConsole.closeConnection();
                    System.exit(1);
                }
                catch (Exception e) {
                    Debug.log("Exception Caught: " + e.getMessage());
                }
            }
            AeshReadlineConsole.closeConnectionClean();
            if (this.result) {
                this.outJar = this.installdata.uninstallOutJar;
                this.writeUninstallData();
                System.out.println("[ Console installation done ]");
            } else {
                System.out.println("[ Console installation FAILED! ]");
            }
        }
        catch (Exception e) {
            this.result = false;
            System.err.println(e.toString());
            e.printStackTrace();
            System.out.println("[ Console installation FAILED! ]");
            AeshReadlineConsole.closeConnection();
        }
    }

    private void runPreConstructionActions(Panel p) {
        List<String> preConstructionActions = p.getPreConstructionActions();
        if (preConstructionActions != null) {
            for (int actionIndex = 0; actionIndex < preConstructionActions.size(); ++actionIndex) {
                String panelActionClass = preConstructionActions.get(actionIndex);
                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                action.initialize(p.getPanelActionConfiguration(panelActionClass));
                action.executeAction(this.installdata, null);
            }
        }
    }

    private void runPreActivateActions(Panel p) {
        List<String> preActivateActions = p.getPreActivationActions();
        if (preActivateActions != null) {
            for (int actionIndex = 0; actionIndex < preActivateActions.size(); ++actionIndex) {
                String panelActionClass = preActivateActions.get(actionIndex);
                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                action.initialize(p.getPanelActionConfiguration(panelActionClass));
                action.executeAction(this.installdata, null);
            }
        }
    }

    private void runPreValidateActions(Panel p) {
        List<String> preValidateActions = p.getPreValidationActions();
        if (preValidateActions != null) {
            for (int actionIndex = 0; actionIndex < preValidateActions.size(); ++actionIndex) {
                String panelActionClass = preValidateActions.get(actionIndex);
                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                action.initialize(p.getPanelActionConfiguration(panelActionClass));
                action.executeAction(this.installdata, null);
            }
        }
    }

    private void runPostValidationActions(Panel p) {
        List<String> postValidateActions = p.getPostValidationActions();
        if (postValidateActions != null) {
            for (int actionIndex = 0; actionIndex < postValidateActions.size(); ++actionIndex) {
                String panelActionClass = postValidateActions.get(actionIndex);
                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                action.initialize(p.getPanelActionConfiguration(panelActionClass));
                action.executeAction(this.installdata, null);
            }
        }
    }

    private void writeUninstallData() {
        String logfile = this.installdata.getVariable("InstallerFrame.logfilePath");
        BufferedWriter extLogWriter = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = this.installdata.info.getUninstallerPath() + "/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, new VariableSubstitutor(this.installdata.getVariables())))).getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                Debug.trace("Cannot create logfile!");
                Debug.error(e);
            }
            if (out != null) {
                extLogWriter = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        try {
            String condition = this.installdata.getVariable("UNINSTALLER_CONDITION");
            if (condition != null && !RulesEngine.getCondition(condition).isTrue()) {
                return;
            }
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getUninstalableFilesList();
            ZipOutputStream outJar = this.installdata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(this.installdata.getInstallPath());
            logWriter.newLine();
            Iterator iter = files.iterator();
            String quickstarts = this.installdata.getVariable("installQuickStarts");
            if (quickstarts != null && quickstarts.equals("true")) {
                logWriter.write("installQuickStarts=true");
                logWriter.newLine();
                logWriter.write(this.installdata.getVariable("install.quickstarts.path") + "/" + this.installdata.getVariable("quickstarts.subdir"));
                logWriter.newLine();
            }
            if (extLogWriter != null) {
                while (iter.hasNext()) {
                    String txt = (String)iter.next();
                    logWriter.write(txt);
                    extLogWriter.write(txt);
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                    extLogWriter.newLine();
                }
                logWriter.flush();
                extLogWriter.flush();
                extLogWriter.close();
            } else {
                while (iter.hasNext()) {
                    logWriter.write((String)iter.next());
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                }
                logWriter.flush();
            }
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            Map<String, Object> additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator<String> keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            ArrayList<String> unInstallScripts = udata.getUninstallScripts();
            Iterator<String> unInstallIter = unInstallScripts.iterator();
            int idx = 0;
            while (unInstallIter.hasNext()) {
                outJar.putNextEntry(new ZipEntry("rootscript" + Integer.toString(idx)));
                ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
                String unInstallScript = unInstallIter.next();
                rootStream.writeUTF(unInstallScript);
                rootStream.flush();
                outJar.closeEntry();
                ++idx;
            }
            outJar.flush();
            outJar.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    protected void doInstall() throws Exception {
        try {
            this.iterateAndPerformAction("doInstall");
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doGeneratePropertiesFile(String strFile) throws Exception {
        try {
            this.printWriter = new PrintWriter(strFile);
            this.iterateAndPerformAction("doGeneratePropertiesFile");
            this.printWriter.flush();
            this.printWriter.close();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.printWriter.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doInstallFromPropertiesFile(String strFile) throws Exception {
        FileInputStream in = new FileInputStream(strFile);
        try {
            this.properties = new Properties();
            this.properties.load(in);
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                in.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        in.close();
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private boolean validatePanel(Panel p) throws InstallerException {
        boolean returnVal = true;
        ValidatorMap dataValidators = p.getValidators();
        this.runPreValidateActions(p);
        if (dataValidators != null) {
            for (int i = 0; i < dataValidators.size(); ++i) {
                String name = dataValidators.getName(i);
                Map<String, String> params = dataValidators.getParams(i);
                Boolean warningDefault = false;
                try {
                    DataValidator validator = ParameteredDataValidator.class.isAssignableFrom(Class.forName(name)) ? DataValidatorFactory.createParameteredValidator(name, params) : DataValidatorFactory.createDataValidator(name);
                    DataValidator.Status validationResult = validator.validateData(this.installdata);
                    if (validationResult == DataValidator.Status.OK) continue;
                    if (validationResult == DataValidator.Status.WARNING) {
                        int answer;
                        String message = this.installdata.langpack.containsKey(validator.getWarningMessageId() + ".console") ? this.installdata.langpack.getString(validator.getWarningMessageId() + ".console") : (this.installdata.langpack.containsKey(validator.getErrorMessageId() + ".console") ? this.installdata.langpack.getString(validator.getErrorMessageId() + ".console") : validator.getFormattedMessage());
                        if (validator instanceof SetWarningDefault) {
                            warningDefault = ((SetWarningDefault)((Object)validator)).warningDefault();
                        }
                        if ((answer = PanelConsoleHelper.askYesNo(message, warningDefault)) == 47) {
                            returnVal = true;
                            continue;
                        }
                        return false;
                    }
                    if (validationResult == DataValidator.Status.SKIP) {
                        if (SkippableDataValidator.class.isAssignableFrom(validator.getClass())) {
                            SkippableDataValidator skipValidator = (SkippableDataValidator)validator;
                            String msg = skipValidator.getFormattedMessage() + System.getProperty("line.separator") + this.installdata.langpack.getString(skipValidator.getConsoleOptionsId()) + System.getProperty("line.separator");
                            int userInput = PanelConsoleHelper.askEndOfConsolePanel(this.installdata, msg);
                            returnVal = skipValidator.skipActions(this.installdata, userInput);
                            if (returnVal) continue;
                            return false;
                        }
                        returnVal = true;
                        continue;
                    }
                    if (validationResult == DataValidator.Status.ERROR) {
                        System.out.println("\n" + this.installdata.langpack.getString("UserInputPanel.console.error") + " " + validator.getFormattedMessage() + "\n");
                        return false;
                    }
                    throw new InstallerException("Validating data for panel " + p.getPanelid() + " was not successfull");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return returnVal;
    }

    public void run(int type, String path) throws Exception {
        switch (type) {
            case 1: {
                this.doGeneratePropertiesFile(path);
                break;
            }
            case 2: {
                this.doInstallFromPropertiesFile(path);
                break;
            }
            default: {
                this.doInstall();
            }
        }
    }

    public void writeXMLTree(IXMLElement root, OutputStream out) throws Exception {
        XMLWriter writer = new XMLWriter(out);
        for (int i = 0; i < this.installdata.consoles.size(); ++i) {
            String strCondition;
            PanelConsole panel;
            AutomatedInstallData.ConsoleInfo consoleInfo = this.installdata.consoles.get(i);
            if (consoleInfo == null || !((panel = consoleInfo.console) instanceof PanelConsoleHelper) || (strCondition = this.installdata.consoles.get((int)i).panel.getCondition()) != null && !this.installdata.getRules().isConditionTrue(strCondition)) continue;
            ((PanelConsoleHelper)((Object)panel)).makeXMLData(this.installdata.xmlData.getChildAtIndex(i + 2), this.installdata);
        }
        writer.write(root);
    }
}

