/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.LoggedInputStream;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class DownloadPanel
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4458769435196053866L;
    JLabel statusLabel = new JLabel("", 4);
    JLabel fileLabel = new JLabel("File", 2);
    JButton button = ButtonFactory.createButton("Cancel");
    JProgressBar progressBar = new JProgressBar();
    String statusText;
    String fileText;
    LoggedInputStream lis;

    public DownloadPanel(LoggedInputStream lis) {
        Dimension dialogSize = new Dimension(406, 150);
        this.setLayout(null);
        this.setMinimumSize(dialogSize);
        this.setMaximumSize(dialogSize);
        this.setPreferredSize(dialogSize);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setSize(dialogSize);
        this.lis = lis;
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(false);
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(null);
        contents.setSize(dialogSize);
        this.setDefaultCloseOperation(0);
        contents.add(this.fileLabel);
        contents.add(this.statusLabel);
        contents.add(this.progressBar);
        contents.add(this.button);
        this.button.addActionListener(this);
        this.fileLabel.setBounds(10, 10, 260, 20);
        this.statusLabel.setBounds(270, 10, 120, 20);
        this.progressBar.setBounds(10, 35, 380, 20);
        this.button.setBounds(150, 70, 100, 25);
        this.pack();
    }

    public void setStatusLabel(String text) {
        this.statusText = text;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadPanel.this.statusLabel.setText(DownloadPanel.this.statusText);
                }
            });
        }
    }

    public void setFileLabel(String text) {
        int maxStr = 35;
        int lastSeparator = text.lastIndexOf("/");
        int length = (text = text.substring(lastSeparator + 1, text.length())).length();
        this.fileText = length > maxStr ? ".." + text.substring(length - maxStr, length) : text;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadPanel.this.fileLabel.setText(DownloadPanel.this.fileText);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.lis.setCancelled(true);
        this.dispose();
    }

    public void setProgressMax(int total) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximum(total);
        this.progressBar.setMinimum(0);
    }

    public void setProgressCurrent(int curr) {
        this.progressBar.setValue(curr);
    }
}

