/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.ComboBoxFactory;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.UiResources;
import com.izforge.izpack.gui.patternfly.PatternflyButtonUI;
import com.izforge.izpack.gui.patternfly.PatternflyComboBoxUI;
import com.izforge.izpack.gui.patternfly.PatternflyFileChooserUI;
import com.izforge.izpack.gui.patternfly.PatternflyJTextPaneUI;
import com.izforge.izpack.gui.patternfly.PatternflyJTreeUI;
import com.izforge.izpack.gui.patternfly.PatternflyOptionPaneUI;
import com.izforge.izpack.gui.patternfly.PatternflyPasswordFieldUI;
import com.izforge.izpack.gui.patternfly.PatternflyScrollBarUI;
import com.izforge.izpack.gui.patternfly.PatternflyTextFieldUI;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class GUIInstaller
extends InstallerBase {
    private InstallData installdata;
    protected String lnf;
    private static final String[] LANGUAGE_DISPLAY_TYPES = new String[]{"iso3", "native", "default"};
    private static Map<String, String> isoTable = new HashMap<String, String>();
    private static String LANG_DISPLAY = "langDisplay";
    private static String NO = "no";
    private static String DEFAULT_LANG = "eng";

    public GUIInstaller() throws Exception {
        try {
            this.init();
        }
        catch (Exception e) {
            this.showFatalError(e);
            throw e;
        }
        catch (Error e) {
            this.showFatalError(e);
            throw e;
        }
    }

    public GUIInstaller(Map<String, String> argVariables) throws Exception {
        try {
            this.init(argVariables);
        }
        catch (Exception e) {
            this.showFatalError(e);
            throw e;
        }
        catch (Error e) {
            this.showFatalError(e);
            throw e;
        }
    }

    private void showFatalError(Throwable e) {
        try {
            JOptionPane.showMessageDialog(null, "Error: " + e.toString(), "Error", 0);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init(Map<String, String> argVariables) throws Exception {
        try {
            this.init();
        }
        catch (Exception e) {
            this.showFatalError(e);
            throw e;
        }
        catch (Error e) {
            this.showFatalError(e);
            throw e;
        }
        this.loadCommandLineVariables(argVariables, this.installdata);
    }

    private void init() throws Exception {
        this.installdata = new InstallData();
        this.loadInstallData(this.installdata);
        this.loadGUIInstallData();
        URL sp = this.getClass().getResource("/res/Installer.splash");
        if (sp != null) {
            ImageIcon splash = new ImageIcon(sp);
            JWindow frame = new JWindow();
            JLabel splashLabel = new JLabel(splash);
            frame.add(splashLabel);
            frame.setSize(splash.getIconWidth(), splash.getIconHeight());
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            String duration = this.installdata.getVariable("Installer.splash.duration");
            int iDuration = 5000;
            if (duration != null) {
                try {
                    iDuration = Integer.parseInt(duration);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Thread.sleep(iDuration);
            frame.setVisible(false);
        }
        this.loadLookAndFeel();
        GUIInstaller.setUIFont(new FontUIResource(FontResources.getOpenSansRegular()));
        UIManager.put("Panel.background", Color.WHITE);
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("PasswordField.inactiveBackground", UiResources.inactiveTextField);
        UIManager.put("TextArea.inactiveBackground", UiResources.inactiveTextField);
        UIManager.put("TextField.inactiveBackground", UiResources.inactiveTextField);
        UIManager.put("TextFieldUI", PatternflyTextFieldUI.class.getName());
        UIManager.put("PasswordFieldUI", PatternflyPasswordFieldUI.class.getName());
        UIManager.put("TextPaneUI", PatternflyJTextPaneUI.class.getName());
        UIManager.put("ScrollBarUI", PatternflyScrollBarUI.class.getName());
        UIManager.put("Button.rollover", true);
        UIManager.put("ComboBoxUI", PatternflyComboBoxUI.class.getName());
        UIManager.put("TreeUI", PatternflyJTreeUI.class.getName());
        UIManager.put("ButtonUI", PatternflyButtonUI.class.getName());
        UIManager.put("FileChooserUI", PatternflyFileChooserUI.class.getName());
        UIManager.put("OptionPaneUI", PatternflyOptionPaneUI.class.getName());
        this.checkJDKAvailable();
        this.checkLockFile();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    GUIInstaller.this.loadLangPack();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ResourceManager.create(this.installdata);
        this.loadConditions(this.installdata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            System.exit(-1);
            return;
        }
        this.addBackupLangpack(this.installdata);
        this.addCustomLangpack(this.installdata);
        this.checkJavaVersion();
        this.installdata.setVariable("installerMode", "GUI");
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource) || key.equals("PasswordField.font")) continue;
            UIManager.put(key, f);
        }
    }

    protected void doInstall() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GUIInstaller.this.loadGUI();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void showMissingRequirementMessage(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    public void loadGUIInstallData() throws Exception {
        InputStream in = GUIInstaller.class.getResourceAsStream("/GUIPrefs");
        ObjectInputStream objIn = new ObjectInputStream(in);
        this.installdata.guiPrefs = (GUIPrefs)objIn.readObject();
        objIn.close();
    }

    private void checkLockFile() throws Exception {
        String tempDir = System.getProperty("java.io.tmpdir");
        String appName = this.installdata.info.getAppName();
        String fileName = "iz-" + appName + ".tmp";
        Debug.trace("Making temp file: " + fileName);
        Debug.trace("In temp directory: " + tempDir);
        File file = new File(tempDir, fileName);
        if (file.exists()) {
            Debug.trace("Lock File Exists, asking user for permission to proceed.");
            StringBuffer msg = new StringBuffer();
            msg.append("<html>");
            msg.append("The " + appName + " installer you are attempting to run seems to have a copy already running.<br><br>");
            msg.append("This could be from a previous failed installation attempt or you may have accidentally launched <br>");
            msg.append("the installer twice. <b>The recommended action is to select 'Exit'</b> and wait for the other copy of <br>");
            msg.append("the installer to start. If you are sure there is no other copy of the installer running, click <br>");
            msg.append("the 'Continue' button to allow this installer to run. <br><br>");
            msg.append("Are you sure you want to continue with this installation?");
            msg.append("</html>");
            JLabel label = new JLabel(msg.toString());
            label.setFont(new Font("Sans Serif", 0, 12));
            Object[] optionValues = new String[]{"Continue", "Exit"};
            int selectedOption = JOptionPane.showOptionDialog(null, label, "Warning", 0, 2, null, optionValues, optionValues[1]);
            Debug.trace("Selected option: " + selectedOption);
            if (selectedOption == 0) {
                Debug.trace("Setting temp file to delete on exit");
                file.deleteOnExit();
            } else {
                Debug.trace("Leaving temp file alone and exiting");
                System.exit(1);
            }
        } else {
            try {
                if (file.createNewFile()) {
                    Debug.trace("Temp file created");
                    file.deleteOnExit();
                } else {
                    Debug.trace("Temp file could not be created");
                    Debug.trace("*** Multiple instances of installer will be allowed ***");
                }
            }
            catch (Exception e) {
                Debug.trace("Temp file could not be created: " + e);
                Debug.trace("*** Multiple instances of installer will be allowed ***");
            }
        }
    }

    private void checkJavaVersion() throws Exception {
        String required;
        String version = System.getProperty("java.version");
        if (version.compareTo(required = this.installdata.info.getJavaVersion()) < 0) {
            String msgError = this.installdata.langpack.getString("java.mismatch.error");
            msgError = msgError.replaceFirst("@@", required).replaceFirst("@@", version);
            JOptionPane.showMessageDialog(null, StringTool.formatForNewLine(msgError), this.installdata.langpack.getString("installer.error"), 0);
            System.exit(1);
        }
    }

    private void checkJDKAvailable() {
        String[] message;
        int status;
        if (!this.installdata.info.isJdkRequired()) {
            return;
        }
        FileExecutor exec = new FileExecutor();
        String[] params = new String[]{"javac", "-help"};
        String[] output = new String[2];
        if (exec.executeCommand(params, output) != 0 && (status = JOptionPane.showConfirmDialog(null, message = new String[]{"It looks like your system does not have a Java Development Kit (JDK) available.", "The software that you plan to install requires a JDK for both its installation and execution.", "\n", "Do you still want to proceed with the installation process?"}, "Warning", 0, 2)) == 1) {
            System.exit(1);
        }
    }

    private void loadLangPack() throws Exception {
        String selectedPack = "";
        if (this.installdata.guiPrefs.modifier.containsKey(LANG_DISPLAY) && this.installdata.guiPrefs.modifier.get(LANG_DISPLAY).equals(NO)) {
            selectedPack = DEFAULT_LANG;
        } else {
            ArrayList<Image> imgs;
            List<String> availableLangPacks = this.getAvailableLangPacks();
            int npacks = availableLangPacks.size();
            if (npacks == 0) {
                throw new Exception("no language pack available");
            }
            InstallerBase.setLangBackup(availableLangPacks.get(0));
            try {
                imgs = new ArrayList<Image>(Arrays.asList(new ImageIcon(this.getClass().getResource("/res/installer.langsel.icon")).getImage()));
            }
            catch (NullPointerException err) {
                imgs = new ArrayList<Image>(Arrays.asList(new ImageIcon(this.getClass().getResource("/img/JFrameIcon128x128.png")).getImage(), new ImageIcon(this.getClass().getResource("/img/JFrameIcon64x64.png")).getImage(), new ImageIcon(this.getClass().getResource("/img/JFrameIcon32x32.png")).getImage(), new ImageIcon(this.getClass().getResource("/img/JFrameIcon16x16.png")).getImage()));
            }
            if (npacks != 1) {
                LanguageDialog picker = new LanguageDialog(availableLangPacks);
                picker.setSelection(Locale.getDefault().getISO3Language().toLowerCase());
                picker.setModal(true);
                picker.toFront();
                picker.setIconImages(imgs);
                picker.setVisible(true);
                selectedPack = (String)picker.getSelection();
                String iso2 = (String)iso3Toiso2.get(selectedPack);
                this.installdata.locale = new Locale(iso2);
                if (selectedPack == null) {
                    throw new Exception("installation canceled");
                }
            } else {
                selectedPack = availableLangPacks.get(0);
            }
        }
        this.installdata.xmlData.setAttribute("langpack", selectedPack);
        this.installdata.localeISO3 = selectedPack;
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + selectedPack + ".xml");
        this.installdata.langpack = new LocaleDatabase(in);
    }

    protected void loadLookAndFeel() throws Exception {
        TreeMap<String, String> variants;
        String syskey = "unix";
        if (OsVersion.IS_WINDOWS) {
            syskey = "windows";
        } else if (OsVersion.IS_OSX) {
            syskey = "mac";
        }
        String laf = null;
        if (this.installdata.guiPrefs.lookAndFeelMapping.containsKey(syskey)) {
            laf = this.installdata.guiPrefs.lookAndFeelMapping.get(syskey);
        }
        boolean useButtonIcons = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useButtonIcons") && "no".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("useButtonIcons"))) {
            useButtonIcons = false;
        }
        ButtonFactory.useButtonIcons(useButtonIcons);
        boolean useLabelIcons = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useLabelIcons") && "no".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("useLabelIcons"))) {
            useLabelIcons = false;
        }
        LabelFactory.setUseLabelIcons(useLabelIcons);
        if (this.installdata.guiPrefs.modifier.containsKey("labelFontSize")) {
            String valStr = this.installdata.guiPrefs.modifier.get("labelFontSize");
            try {
                LabelFactory.setLabelFontSize(Float.parseFloat(valStr));
            }
            catch (NumberFormatException ex) {
                Debug.log("Error parsing guiprefs 'labelFontSize' value (" + valStr + ')');
            }
        }
        if (laf == null) {
            if (!"mac".equals(syskey)) {
                if ("unix".equals(syskey)) {
                    Locale.setDefault(Locale.ENGLISH);
                }
                String syslaf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(syslaf);
                if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                    ButtonFactory.useButtonIcons(useButtonIcons);
                }
            }
            this.lnf = "swing";
            return;
        }
        if ("kunststoff".equals(laf)) {
            ButtonFactory.useHighlightButtons();
            ButtonFactory.useButtonIcons(useButtonIcons);
            this.installdata.buttonsHColor = new Color(255, 255, 255);
            Class<?> lafClass = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> mtheme = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] params = new Class[]{mtheme};
            Class<?> theme = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method setCurrentThemeMethod = lafClass.getMethod("setCurrentTheme", params);
            LookAndFeel kunststoff = (LookAndFeel)lafClass.newInstance();
            MetalTheme ktheme = (MetalTheme)theme.newInstance();
            Object[] kparams = new Object[]{ktheme};
            UIManager.setLookAndFeel(kunststoff);
            setCurrentThemeMethod.invoke((Object)kunststoff, kparams);
            this.lnf = "kunststoff";
            return;
        }
        if ("liquid".equals(laf)) {
            String value;
            UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
            this.lnf = "liquid";
            Map<String, String> params = this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("decorate.frames") && "yes".equals(value = params.get("decorate.frames"))) {
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
            if (params.containsKey("decorate.dialogs") && "yes".equals(value = params.get("decorate.dialogs"))) {
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            return;
        }
        if ("metouia".equals(laf)) {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
            this.lnf = "metouia";
            return;
        }
        if ("nimbus".equals(laf)) {
            UIManager.setLookAndFeel("org.jdesktop.swingx.plaf.nimbus.NimbusLookAndFeel");
            return;
        }
        if ("looks".equals(laf)) {
            String param;
            variants = new TreeMap<String, String>();
            variants.put("windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            variants.put("plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            variants.put("plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            variants.put("plasticXP", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            String variant = (String)variants.get("plasticXP");
            Map<String, String> params = this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("variant") && variants.containsKey(param = params.get("variant"))) {
                variant = (String)variants.get(param);
            }
            UIManager.setLookAndFeel(variant);
            return;
        }
        if ("substance".equals(laf)) {
            String param;
            variants = new TreeMap();
            variants.put("default", "org.jvnet.substance.SubstanceLookAndFeel");
            variants.put("business", "org.jvnet.substance.skin.SubstanceBusinessLookAndFeel");
            variants.put("business-blue", "org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel");
            variants.put("business-black", "org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel");
            variants.put("creme", "org.jvnet.substance.skin.SubstanceCremeLookAndFeel");
            variants.put("sahara", "org.jvnet.substance.skin.SubstanceSaharaLookAndFeel");
            variants.put("moderate", "org.jvnet.substance.skin.SubstanceModerateLookAndFeel");
            variants.put("officesilver", "org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel");
            String variant = (String)variants.get("default");
            Map<String, String> params = this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("variant") && variants.containsKey(param = params.get("variant"))) {
                variant = (String)variants.get(param);
            }
            UIManager.setLookAndFeel(variant);
        }
    }

    private void loadGUI() throws Exception {
        String title;
        UIManager.put("OptionPane.yesButtonText", this.installdata.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.installdata.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.installdata.langpack.getString("installer.cancel"));
        String key = "installer.reversetitle";
        String message = this.installdata.langpack.getString("installer.reversetitle");
        if (message.indexOf("installer.reversetitle") > -1) {
            title = this.installdata.langpack.getString("installer.title") + this.installdata.info.getAppName();
        } else {
            VariableSubstitutor vs = new VariableSubstitutor(this.installdata.getVariables());
            title = vs.substitute(message, null);
        }
        new InstallerFrame(title, this.installdata, this);
    }

    protected boolean useFlags() {
        return !this.installdata.guiPrefs.modifier.containsKey("useFlags") || !"no".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("useFlags"));
    }

    protected String getLangType() {
        if (this.installdata.guiPrefs.modifier.containsKey("langDisplayType")) {
            String val = this.installdata.guiPrefs.modifier.get("langDisplayType");
            val = val.toLowerCase();
            for (String aLANGUAGE_DISPLAY_TYPES : LANGUAGE_DISPLAY_TYPES) {
                if (!val.equalsIgnoreCase(aLANGUAGE_DISPLAY_TYPES)) continue;
                return val;
            }
            Debug.trace("Value for language display type not valid; value: " + val);
        }
        return LANGUAGE_DISPLAY_TYPES[0];
    }

    private static class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3832899961942782769L;
        private TreeMap<String, ImageIcon> icons = new TreeMap();
        private TreeMap<String, ImageIcon> grayIcons = new TreeMap();

        public FlagRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String iso3 = (String)value;
            this.setText(iso3);
            if (isoTable != null) {
                iso3 = (String)isoTable.get(iso3);
            }
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            if (!this.icons.containsKey(iso3)) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/res/flag." + iso3));
                this.icons.put(iso3, icon);
                icon = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
                this.grayIcons.put(iso3, icon);
            }
            if (isSelected || index == -1) {
                this.setIcon(this.icons.get(iso3));
            } else {
                this.setIcon(this.grayIcons.get(iso3));
            }
            return this;
        }
    }

    private final class LanguageDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 3256443616359887667L;
        private JComboBox comboBox;
        private boolean isoMapExpanded;

        public LanguageDialog(List<String> items) {
            super((Dialog)null);
            this.isoMapExpanded = false;
            try {
                GUIInstaller.this.loadLookAndFeel();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            this.addWindowListener(new WindowHandler());
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setBackground(new Color(0xFFFFFF));
            this.setTitle(((GUIInstaller)GUIInstaller.this).installdata.info.getAppName() + " " + ((GUIInstaller)GUIInstaller.this).installdata.info.getAppVersion());
            GridBagLayout layout = new GridBagLayout();
            contentPane.setLayout(layout);
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.anchor = 10;
            gbConstraints.insets = new Insets(5, 5, 5, 5);
            gbConstraints.fill = 2;
            gbConstraints.gridx = 0;
            gbConstraints.weightx = 1.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.ipadx = 0;
            gbConstraints.ipady = 6;
            ImageIcon img = this.getImage();
            JLabel imgLabel = new JLabel(img);
            gbConstraints.gridy = 0;
            contentPane.add(imgLabel);
            String firstMessage = InstallerBase.languagePickerInstructions.get(Locale.getDefault().getLanguage());
            if (firstMessage == null) {
                firstMessage = InstallerBase.languagePickerInstructions.get(Locale.ENGLISH.getLanguage());
            }
            JLabel label1 = new JLabel(firstMessage, 10);
            gbConstraints.gridy = 1;
            gbConstraints.insets = new Insets(15, 5, 5, 5);
            layout.addLayoutComponent(label1, gbConstraints);
            contentPane.add(label1);
            gbConstraints.insets = new Insets(5, 5, 5, 5);
            items = this.reviseItems(items);
            this.comboBox = ComboBoxFactory.createComboBox(items.toArray());
            if (GUIInstaller.this.useFlags()) {
                this.comboBox.setRenderer(new FlagRenderer());
            }
            this.comboBox.setBackground(new Color(0xFFFFFF));
            this.comboBox.setFont(new Font("Dialog", 0, 13));
            gbConstraints.gridy = 3;
            layout.addLayoutComponent(this.comboBox, gbConstraints);
            contentPane.add(this.comboBox);
            gbConstraints.insets = new Insets(15, 5, 15, 5);
            JButton okButton = ButtonFactory.createButton("OK");
            okButton.addActionListener(this);
            gbConstraints.fill = 0;
            gbConstraints.gridy = 4;
            gbConstraints.anchor = 10;
            layout.addLayoutComponent(okButton, gbConstraints);
            contentPane.add(okButton);
            this.getRootPane().setDefaultButton(okButton);
            if (System.getProperty("mrj.version") == null) {
                this.pack();
            }
            this.setSize(this.getPreferredSize());
            Dimension frameSize = this.getSize();
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            this.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
            okButton.grabFocus();
            this.setResizable(false);
        }

        private List<String> reviseItems(List<String> items) {
            String langType = GUIInstaller.this.getLangType();
            if (langType.equals(LANGUAGE_DISPLAY_TYPES[0])) {
                return items;
            }
            if (langType.equals(LANGUAGE_DISPLAY_TYPES[1])) {
                return this.expandItems(items, new Font("Dialog", 0, 13));
            }
            if (langType.equals(LANGUAGE_DISPLAY_TYPES[2])) {
                return this.expandItems(items, null);
            }
            return items;
        }

        private List<String> expandItems(List<String> items, Font testFont) {
            ArrayList<String> expandedItems = new ArrayList<String>();
            for (String iso3 : items) {
                String it = this.expandItem(iso3, testFont);
                isoTable.put(it, iso3);
                expandedItems.add(it);
            }
            return expandedItems;
        }

        private String expandItem(String item, Font testFont) {
            String iso2Str = InstallerBase.iso3Toiso2.get(item);
            if (iso2Str == null && !this.isoMapExpanded) {
                this.isoMapExpanded = true;
                Locale[] loc = Locale.getAvailableLocales();
                for (int i = 0; i < loc.length; ++i) {
                    InstallerBase.iso3Toiso2.put(loc[i].getISO3Language(), loc[i].getLanguage());
                }
                iso2Str = InstallerBase.iso3Toiso2.get(item);
            }
            if (iso2Str == null) {
                return item;
            }
            Locale locale = new Locale(iso2Str);
            if (testFont == null) {
                return locale.getDisplayLanguage();
            }
            String str = locale.getDisplayLanguage(locale);
            int cdut = testFont.canDisplayUpTo(str);
            if (cdut > -1) {
                str = locale.getDisplayLanguage();
            }
            return str;
        }

        public ImageIcon getImage() {
            ImageIcon img;
            try {
                img = new ImageIcon(LanguageDialog.class.getResource("/res/installer.langsel.img"));
            }
            catch (NullPointerException err) {
                img = null;
            }
            return img;
        }

        public Object getSelection() {
            Object retval = null;
            if (isoTable != null) {
                retval = isoTable.get(this.comboBox.getSelectedItem());
            }
            return retval != null ? retval : this.comboBox.getSelectedItem();
        }

        public void setSelection(Object item) {
            Object mapped = null;
            if (item.toString().equals("zho")) {
                item = "chn";
            }
            if (isoTable != null) {
                for (Object key : isoTable.keySet()) {
                    if (!((String)isoTable.get(key)).equals(item)) continue;
                    mapped = key;
                    break;
                }
            }
            if (mapped == null) {
                mapped = item;
            }
            this.comboBox.setSelectedItem(mapped);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dispose();
        }

        private class WindowHandler
        extends WindowAdapter {
            private WindowHandler() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        }
    }
}

