/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Info;
import com.izforge.izpack.installer.AutomatedInstaller;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.GUIInstaller;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.PrintHelp;
import com.izforge.izpack.installer.PrivilegedRunner;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.JavaProcess;
import com.izforge.izpack.util.StringTool;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class Installer {
    public static final int INSTALLER_GUI = 0;
    public static final int INSTALLER_AUTO = 1;
    public static final int INSTALLER_CONSOLE = 2;
    public static final int CONSOLE_INSTALL = 0;
    public static final int CONSOLE_GEN_TEMPLATE = 1;
    public static final int CONSOLE_FROM_TEMPLATE = 2;
    private static final String ADD_MODULES = "--add-modules=";
    private static final String ADD_MODULES_F = "--add-modules=%s";
    private static final List<String> JAVA_REQUIRED_MODULES = Arrays.asList("java.se");

    public static void main(String[] args) {
        String noForkVm = System.getProperty("noForkVm");
        if (noForkVm == null || !noForkVm.equals("true")) {
            Installer.checkForMissingAddModules(args);
        }
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        HashMap<String, String> argVariables = new HashMap<String, String>();
        Debug.log(" - Logger initialized at '" + new Date(System.currentTimeMillis()) + "'.");
        Debug.log(" - commandline args: " + StringTool.stringArrayToSpaceSeparatedString(args));
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IzPack");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        Info inf = null;
        try {
            InputStream in = InstallerBase.class.getResourceAsStream("/info");
            ObjectInputStream objIn = new ObjectInputStream(in);
            inf = (Info)objIn.readObject();
            objIn.close();
            Installer.checkForPrivilegedExecution(inf, args);
        }
        catch (Exception in) {
            // empty catch block
        }
        try {
            Iterator<String> args_it = Arrays.asList(args).iterator();
            int type = 0;
            int consoleAction = 0;
            String path = null;
            String langcode = null;
            while (args_it.hasNext()) {
                String arg = args_it.next().trim();
                try {
                    if ("-h".equalsIgnoreCase(arg) || "-help".equalsIgnoreCase(arg)) {
                        PrintHelp ph = new PrintHelp();
                        ph.printHelp();
                        System.exit(0);
                        continue;
                    }
                    if ("-console".equalsIgnoreCase(arg)) {
                        type = 2;
                        continue;
                    }
                    if ("-options-template".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 1;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 2;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-language".equalsIgnoreCase(arg)) {
                        type = 2;
                        langcode = args_it.next().trim();
                        continue;
                    }
                    if ("-version".equalsIgnoreCase(arg)) {
                        System.out.println("Product: " + inf.getAppName());
                        System.out.println("Version: " + inf.getAppVersion());
                        System.exit(0);
                        continue;
                    }
                    if ("-variables".equalsIgnoreCase(arg)) {
                        String[] keyValPairs;
                        String newVars = args_it.next().trim();
                        for (String pair : keyValPairs = newVars.split(",")) {
                            String[] keyVal = pair.split("=");
                            argVariables.put(keyVal[0], keyVal[1]);
                        }
                        continue;
                    }
                    if ("-variablefile".equalsIgnoreCase(arg)) {
                        String pwdFilePath = args_it.next().trim();
                        File pwdFile = new File(pwdFilePath);
                        if (pwdFile.exists()) {
                            Installer.loadVariablesFromFile(pwdFile, argVariables);
                            continue;
                        }
                        System.err.println("- ERROR -");
                        System.err.println("Given properties file does not exist.");
                        continue;
                    }
                    type = 1;
                    path = arg;
                }
                catch (NoSuchElementException e) {
                    PrintHelp ph = new PrintHelp();
                    ph.printHelp();
                    System.exit(1);
                }
            }
            if (type == 0 && GraphicsEnvironment.isHeadless()) {
                type = 2;
            }
            switch (type) {
                case 0: {
                    GUIInstaller gi = new GUIInstaller(argVariables);
                    gi.doInstall();
                    break;
                }
                case 1: {
                    AutomatedInstaller ai = new AutomatedInstaller(path, argVariables);
                    ai.doInstall();
                    break;
                }
                case 2: {
                    ConsoleInstaller consoleInstaller = new ConsoleInstaller(langcode, argVariables);
                    consoleInstaller.run(consoleAction, path);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Invalid file.");
            System.out.println("Please specify the correct XML file.");
            Debug.trace(e);
            System.exit(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkForMissingAddModules(String[] installerArgs) {
        ArrayList<String> jvmArgs = new ArrayList<String>(ManagementFactory.getRuntimeMXBean().getInputArguments());
        if (!(Installer.getJavaMajorVersionDouble() >= 11.0)) return;
        List<String> existingModules = jvmArgs.stream().filter(arg -> arg.startsWith(ADD_MODULES)).map(a -> a.split("=", -1)[1]).flatMap(a -> Arrays.stream(a.split(","))).collect(Collectors.toList());
        if (!existingModules.isEmpty()) {
            if (Installer.containsRequiredModules(existingModules)) return;
            existingModules.addAll(JAVA_REQUIRED_MODULES);
        } else {
            existingModules.addAll(JAVA_REQUIRED_MODULES);
        }
        jvmArgs.removeIf(arg -> arg.startsWith(ADD_MODULES));
        jvmArgs.add(String.format(ADD_MODULES_F, String.join((CharSequence)",", existingModules)));
        Path installerJar = null;
        try {
            installerJar = Paths.get(Installer.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(JavaProcess.forkJvm(installerJar, jvmArgs, installerArgs));
    }

    private static double getJavaMajorVersionDouble() {
        String javaSpecString = System.getProperty("java.vm.specification.version");
        if (javaSpecString.matches("(\\d+.)?\\d+")) {
            return Double.parseDouble(javaSpecString);
        }
        return Double.MAX_VALUE;
    }

    private static boolean containsRequiredModules(List<String> addedModules) {
        return addedModules.containsAll(JAVA_REQUIRED_MODULES);
    }

    public static void loadVariablesFromFile(File variablesFile, Map<String, String> argVariables) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(variablesFile));
        }
        catch (IOException ioe) {
            System.err.println("There was an error reading the variable file.");
            ioe.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("The variable file seems to be malformed.");
            iae.printStackTrace();
        }
        if (!props.stringPropertyNames().isEmpty()) {
            for (String key : props.stringPropertyNames()) {
                argVariables.put(key, props.getProperty(key));
            }
        } else {
            System.err.println("The variable file was empty.");
        }
    }

    private static void checkForPrivilegedExecution(Info info, String[] args) {
        if (PrivilegedRunner.isPrivilegedMode()) {
            return;
        }
        if (info.isPrivilegedExecutionRequired()) {
            boolean shouldElevate = true;
            String conditionId = info.getPrivilegedExecutionConditionID();
            if (conditionId != null) {
                shouldElevate = RulesEngine.getCondition(conditionId).isTrue();
            }
            PrivilegedRunner runner = new PrivilegedRunner(!shouldElevate);
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null) {
                programFiles = "C:\\Program Files";
            }
            if (runner.isPlatformSupported() && runner.isElevationNeeded(programFiles)) {
                try {
                    if (runner.relaunchWithElevatedRights(args) != 0) {
                        throw new RuntimeException("Launching an installer with elevated permissions failed.");
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "The installer could not launch itself with administrator permissions.\nThe installation will still continue but you may encounter problems due to insufficient permissions.");
                }
            } else if (!runner.isPlatformSupported()) {
                JOptionPane.showMessageDialog(null, "This installer should be run by an administrator.\nThe installation will still continue but you may encounter problems due to insufficient permissions.");
            }
        }
    }
}

