/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.adaptator.impl.XMLWriter;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.gui.UiResources;
import com.izforge.izpack.gui.patternfly.PatternflyButtonUI;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.AutomatedInstaller;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.GUIListener;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.ParameteredDataValidator;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.installer.UnpackerFactory;
import com.izforge.izpack.panels.FinishPanel;
import com.izforge.izpack.panels.HTMLLicencePanel;
import com.izforge.izpack.panels.InstallPanel;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.ValidatorMap;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class InstallerFrame
extends JFrame {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String ICON_RESOURCE = "Installer.image";
    private static final String ICON_RESOURCE_EXT_VARIABLE_NAME = "installerimage.ext";
    private static final String HEADING_ICON_RESOURCE = "Heading.image";
    public LocaleDatabase langpack;
    protected InstallData installdata;
    public IconsDatabase icons;
    protected JPanel centerPanel;
    private JPanel containerPanel;
    protected JPanel contentPane;
    protected JButton helpButton = null;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton quitButton;
    protected JButton doneButton;
    private NavigationHandler navHandler;
    protected ArrayList<Integer> visiblePanelMapping;
    protected ArrayList<GUIListener> guiListener;
    protected JLabel[] headingLabels;
    protected JPanel headingPanel;
    protected JComponent headingCounterComponent;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    protected RulesEngine rules;
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";
    private VariableSubstitutor substitutor;
    private Debugger debugger;
    private boolean imageLeft = false;
    public boolean hasBackground = false;
    private InstallerBase parentInstaller;
    private JTree sideNavigationTree;
    private JPanel sideNavExtention;
    private Map<Panel, PanelNode> panelNodeMap;
    private boolean sideNavigationActive;
    private JPanel navPanel;
    private boolean isBack = false;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(String title, InstallData installdata, InstallerBase parentInstaller) throws Exception {
        super(title);
        InstallerFrame.setUIFont(new FontUIResource(FontResources.getOpenSansRegular()));
        BackPanel bPanel = new BackPanel();
        this.setContentPane(bPanel);
        this.hasBackground = true;
        this.parentInstaller = parentInstaller;
        this.rules = this.parentInstaller.getRules();
        this.substitutor = new VariableSubstitutor(installdata.variables);
        this.guiListener = new ArrayList();
        this.visiblePanelMapping = new ArrayList();
        this.installdata = installdata;
        this.langpack = installdata.langpack;
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.loadIcons();
        this.loadCustomIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    private String[] frameButtonNames() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String[] shortcuts = new String[]{idata.langpack.getString("installer.quit"), idata.langpack.getString("installer.prev"), idata.langpack.getString("installer.next"), idata.langpack.getString("installer.help")};
        return shortcuts;
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource) || key.equals("PasswordField.font")) continue;
            UIManager.put(key, f);
        }
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    private void loadPanels() throws Exception {
        AutomatedInstallData installData = AutomatedInstallData.getInstance();
        List panelsOrder = this.installdata.panelsOrder;
        int size = panelsOrder.size();
        Class[] paramsClasses = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] params = new Object[]{this, this.installdata};
        int curVisPanelNumber = 0;
        int lastVis = 0;
        int count = 0;
        XMLElementImpl productNameNode = new XMLElementImpl(AutomatedInstaller.PRODUCT_NAME_TAG, installData.xmlData);
        productNameNode.setContent(installData.getVariable("product.name").toUpperCase());
        installData.xmlData.addChild(productNameNode);
        XMLElementImpl productVersionNode = new XMLElementImpl(AutomatedInstaller.PRODUCT_VERSION_TAG, installData.xmlData);
        productVersionNode.setContent(installData.info.getAppVersion());
        installData.xmlData.addChild(productVersionNode);
        for (int i = 0; i < size; ++i) {
            List<String> postValidateActions;
            List<String> preValidateActions;
            ButtonFactory.clearButtonMnemonics();
            Panel p = (Panel)panelsOrder.get(i);
            if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
            String className = p.className;
            String praefix = "com.izforge.izpack.panels.";
            if (className.indexOf(46) > -1) {
                praefix = "";
            }
            Class<?> objectClass = Class.forName(praefix + className);
            Constructor<?> constructor = objectClass.getDeclaredConstructor(paramsClasses);
            this.installdata.currentPanel = p;
            List<String> preConstgructionActions = p.getPreConstructionActions();
            if (preConstgructionActions != null) {
                for (int actionIndex = 0; actionIndex < preConstgructionActions.size(); ++actionIndex) {
                    PanelAction action = PanelActionFactory.createPanelAction(preConstgructionActions.get(actionIndex));
                    action.initialize(p.getPanelActionConfiguration(preConstgructionActions.get(actionIndex)));
                    action.executeAction(AutomatedInstallData.getInstance(), null);
                }
            }
            Object object = constructor.newInstance(params);
            IzPanel panel = (IzPanel)object;
            ValidatorMap dataValidators = p.getValidators();
            if (dataValidators != null) {
                ArrayList<DataValidator> validationServices = new ArrayList<DataValidator>();
                for (int j = 0; j < dataValidators.size(); ++j) {
                    String name = dataValidators.getName(j);
                    Map<String, String> parameters = dataValidators.getParams(j);
                    DataValidator validator = ParameteredDataValidator.class.isAssignableFrom(Class.forName(name)) ? DataValidatorFactory.createParameteredValidator(name, parameters) : DataValidatorFactory.createDataValidator(name);
                    validationServices.add(validator);
                }
                panel.setValidationServices(!validationServices.isEmpty() ? validationServices : null);
            }
            panel.setHelps(p.getHelpsMap());
            panel.setDelay(p.isDelayed());
            panel.setDelayLength(p.getDelayLength());
            panel.setInSummaryPanel(p.isInSummaryPanel());
            panel.displayHidden(p.isDisplayingHidden());
            List<String> preActivateActions = p.getPreActivationActions();
            if (preActivateActions != null) {
                for (int actionIndex = 0; actionIndex < preActivateActions.size(); ++actionIndex) {
                    String panelActionClass = preActivateActions.get(actionIndex);
                    PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                    action.initialize(p.getPanelActionConfiguration(panelActionClass));
                    panel.addPreActivationAction(action);
                }
            }
            if ((preValidateActions = p.getPreValidationActions()) != null) {
                for (int actionIndex = 0; actionIndex < preValidateActions.size(); ++actionIndex) {
                    String panelActionClass = preValidateActions.get(actionIndex);
                    PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                    action.initialize(p.getPanelActionConfiguration(panelActionClass));
                    panel.addPreValidationAction(action);
                }
            }
            if ((postValidateActions = p.getPostValidationActions()) != null) {
                for (int actionIndex = 0; actionIndex < postValidateActions.size(); ++actionIndex) {
                    String panelActionClass = postValidateActions.get(actionIndex);
                    PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                    action.initialize(p.getPanelActionConfiguration(panelActionClass));
                    panel.addPostValidationAction(action);
                }
            }
            this.installdata.panels.add(panel);
            if (panel.isHidden()) {
                this.visiblePanelMapping.add(count, -1);
            } else {
                this.visiblePanelMapping.add(count, curVisPanelNumber);
                ++curVisPanelNumber;
                lastVis = count;
            }
            ++count;
            XMLElementImpl panelRoot = new XMLElementImpl(className, this.installdata.xmlData);
            String panelId = p.getPanelid();
            if (panelId != null) {
                panelRoot.setAttribute("id", panelId);
            }
            this.installdata.xmlData.addChild(panelRoot);
        }
        this.visiblePanelMapping.add(count, lastVis);
    }

    private void loadIcons() throws Exception {
        ImageIcon img;
        URL url;
        IXMLElement icon;
        int i;
        this.icons = new IconsDatabase();
        InputStream inXML = InstallerFrame.class.getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(inXML);
        Vector<IXMLElement> children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i = 0; i < size; ++i) {
            icon = children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i = 0; i < size; ++i) {
            icon = children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    protected void loadCustomIcons() throws Exception {
        ImageIcon img;
        URL url;
        IXMLElement icon;
        int i;
        InputStream inXML = null;
        try {
            inXML = ResourceManager.getInstance().getInputStream(CUSTOM_ICONS_RESOURCEFILE);
        }
        catch (Throwable exception) {
            Debug.trace("Resource customicons.xml not defined. No custom icons available.");
            return;
        }
        Debug.trace("Custom icons available.");
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(inXML);
        Vector<IXMLElement> children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i = 0; i < size; ++i) {
            icon = children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            Debug.trace("Icon with id found: " + icon.getAttribute("id"));
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i = 0; i < size; ++i) {
            icon = children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    private void buildGUI() {
        this.setDefaultCloseOperation(0);
        this.setIconImages(new ArrayList<Image>(Arrays.asList(this.icons.getImageIcon("JFrameIcon16x16").getImage(), this.icons.getImageIcon("JFrameIcon32x32").getImage(), this.icons.getImageIcon("JFrameIcon64x64").getImage(), this.icons.getImageIcon("JFrameIcon128x128").getImage())));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setBackground(new Color(0xFFFFFF));
        this.contentPane.setLayout(new BorderLayout());
        this.containerPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)this.containerPanel, "Center");
        this.centerPanel = new JPanel();
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.centerPanel.setLayout(new GridLayout(1, 1));
        if (this.hasBackground) {
            this.centerPanel.setOpaque(false);
        }
        this.containerPanel.add((Component)this.centerPanel, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel panel_0 = (IzPanel)this.installdata.panels.get(0);
        this.centerPanel.add(panel_0);
        this.navHandler = new NavigationHandler();
        this.navPanel = new JPanel();
        this.navPanel.setLayout(new GridBagLayout());
        this.navPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagConstraints gbcGlue = new GridBagConstraints();
        gbcGlue.weightx = 1.0;
        gbcGlue.weighty = 1.0;
        gbcGlue.fill = 1;
        this.navPanel.add(Box.createGlue(), gbcGlue);
        this.helpButton = ButtonFactory.createButton(this.langpack.getString("installer.help"), (Icon)this.icons.getImageIcon("help"), this.installdata.buttonsHColor, true);
        this.navPanel.add(this.helpButton);
        this.helpButton.addActionListener(new HelpHandler());
        this.navPanel.add(Box.createHorizontalGlue(), gbcGlue);
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 22;
        this.navPanel.add((Component)this.quitButton, gbc);
        this.quitButton.addActionListener(this.navHandler);
        this.navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.prevButton = ButtonFactory.createButton("<html><font size='2' face='FontAwesome'>\uf053</font> " + this.langpack.getString("installer.prev") + "</html>", true);
        this.prevButton.addActionListener(this.navHandler);
        this.navPanel.add((Component)this.prevButton, gbc);
        this.nextButton = ButtonFactory.createButton("<html>" + this.langpack.getString("installer.next") + " " + "<font size='2' face='FontAwesome'>\uf054</font>" + "</html>", true);
        this.nextButton.setFocusPainted(true);
        this.nextButton.setUI(new PatternflyButtonUI(Color.WHITE, UiResources.blueButtonLight, UiResources.blueButtonDark, UiResources.blueButtonShadow, UiResources.blueButtonStroke, Color.WHITE));
        this.nextButton.setForeground(Color.WHITE);
        this.navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton.addActionListener(this.navHandler);
        this.navPanel.add((Component)this.nextButton, gbc);
        this.navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.containerPanel.add((Component)this.navPanel, "South");
        if (this.useSideNavigationPanel()) {
            this.panelNodeMap = new HashMap<Panel, PanelNode>();
            Panel root = new Panel();
            root.setPanelid("Root Panel");
            PanelNode rootNode = new PanelNode(root);
            this.addNodes(rootNode);
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            treeModel.addTreeModelListener(new SideNavTreeNodeListener());
            this.sideNavigationTree = new JTree(treeModel);
            this.sideNavigationTree.setFocusable(false);
            this.sideNavigationTree.setRowHeight(0);
            this.sideNavigationTree.putClientProperty("JTree.lineStyle", "None");
            this.sideNavigationTree.updateUI();
            ((BasicTreeUI)this.sideNavigationTree.getUI()).setExpandedIcon(null);
            ((BasicTreeUI)this.sideNavigationTree.getUI()).setCollapsedIcon(null);
            this.sideNavigationTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                    TreePath path = event.getPath();
                    if (path.getLastPathComponent() instanceof PanelNode && !((PanelNode)path.getLastPathComponent()).isExpandable()) {
                        throw new ExpandVetoException(event, "node not expandable");
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                    TreePath path = event.getPath();
                    if (path.getLastPathComponent() instanceof PanelNode && !((PanelNode)path.getLastPathComponent()).isCollapsable()) {
                        throw new ExpandVetoException(event, "node not collapsable");
                    }
                }
            });
            SideNavigationRenderer renderer = new SideNavigationRenderer();
            this.sideNavigationTree.setCellRenderer(renderer);
            this.sideNavigationTree.setOpaque(true);
            this.sideNavigationTree.setBackground(UiResources.sideNavigationBackGround);
            this.sideNavigationTree.setRootVisible(false);
            this.sideNavigationTree.putClientProperty("JTree.lineStyle", "None");
            this.sideNavigationTree.getSelectionModel().setSelectionMode(1);
            this.sideNavigationTree.setShowsRootHandles(true);
            this.sideNavigationTree.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.sideNavExtention = new JPanel();
            this.sideNavExtention.setPreferredSize(new Dimension(this.getSideNavigationWidth(), 0));
            this.sideNavExtention.setBackground(UiResources.sideNavigationBackGround);
            this.sideNavExtention.setBorder(new MatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
            this.sideNavExtention.setFocusable(false);
            this.addSideNavigation();
        }
        AccessibleContext ac = this.prevButton.getAccessibleContext();
        ac.setAccessibleDescription("This button moves the installation process back one panel");
        this.prevButton.setActionCommand("Previous Button");
        ac = this.nextButton.getAccessibleContext();
        ac.setAccessibleDescription("This button moves the installation process forward one panel");
        this.nextButton.setActionCommand("Next Button");
        ac = this.quitButton.getAccessibleContext();
        ac.setAccessibleDescription("This button quits the installation process");
        this.quitButton.setActionCommand("Quit Button");
        this.debugger = new Debugger(this.installdata, this.icons, this.rules);
        JPanel debugpanel = this.debugger.getDebugPanel();
        if (Debug.isTRACE()) {
            if (this.installdata.guiPrefs.modifier.containsKey("showDebugWindow") && Boolean.valueOf(this.installdata.guiPrefs.modifier.get("showDebugWindow")).booleanValue()) {
                JFrame debugframe = new JFrame("Debug information");
                debugframe.setContentPane(debugpanel);
                debugframe.setSize(new Dimension(400, 400));
                debugframe.setVisible(true);
            } else {
                debugpanel.setPreferredSize(new Dimension(200, 400));
                this.contentPane.add((Component)debugpanel, "East");
            }
        }
        try {
            ImageIcon icon = this.loadIcon(ICON_RESOURCE, 0, true);
            if (icon != null) {
                JPanel imgPanel = new JPanel();
                imgPanel.setLayout(new BorderLayout());
                imgPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
                this.iconLabel = new JLabel(icon);
                this.iconLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                imgPanel.add((Component)this.iconLabel, "North");
                this.contentPane.add((Component)imgPanel, "West");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadAndShowImage(0);
        this.getRootPane().setDefaultButton(this.nextButton);
        this.callGUIListener(0, this.navPanel);
        this.createHeading(this.navPanel);
    }

    private void addNodes(DefaultMutableTreeNode root) {
        for (Panel panel : this.installdata.panelsOrder) {
            if (panel.getPanelNumber() != panel.getParentPanel()) continue;
            PanelNode panelNode = new PanelNode(panel);
            root.add(panelNode);
            this.panelNodeMap.put(panel, panelNode);
        }
    }

    private void callGUIListener(int what) {
        this.callGUIListener(what, null);
    }

    private void callGUIListener(int what, Object param) {
        Iterator<GUIListener> iter = this.guiListener.iterator();
        while (iter.hasNext()) {
            iter.next().guiActionPerformed(what, param);
        }
    }

    public void addDoneButton() {
        ButtonFactory.clearButtonMnemonics();
        ButtonFactory.clearInstallerFrameShortcuts();
        this.doneButton = ButtonFactory.createButton(this.langpack.getString("FinishPanel.done"), true);
        this.navPanel.remove(this.quitButton);
        this.navPanel.add(this.doneButton);
        this.doneButton.addActionListener(this.navHandler);
        this.doneButton.setUI(new PatternflyButtonUI(Color.WHITE, UiResources.blueButtonLight, UiResources.blueButtonDark, UiResources.blueButtonShadow, UiResources.blueButtonStroke, Color.WHITE));
        this.getRootPane().setDefaultButton(this.doneButton);
        this.doneButton.grabFocus();
    }

    private ImageIcon loadIcon(String resPrefix, int PanelNo, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        String iconext = this.getIconResourceNameExtension();
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e) {
                icon = rm.getImageIconResource(resPrefix + "." + PanelNo + iconext);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + PanelNo + iconext);
        }
        return icon;
    }

    private ImageIcon loadIcon(String resPrefix, String panelid, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        String iconext = this.getIconResourceNameExtension();
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e) {
                icon = rm.getImageIconResource(resPrefix + "." + panelid + iconext);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + panelid + iconext);
        }
        return icon;
    }

    private String getIconResourceNameExtension() {
        try {
            String iconext = this.installdata.getVariable(ICON_RESOURCE_EXT_VARIABLE_NAME);
            if (iconext == null) {
                iconext = "";
            } else if (iconext.length() > 0 && iconext.charAt(0) != '.') {
                iconext = "." + iconext;
            }
            iconext = iconext.trim();
            return iconext;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void loadAndShowImage(int panelNo) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo);
    }

    private void loadAndShowImage(int panelNo, String panelid) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo, panelid);
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelno, String panelid) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelid, false);
        }
        catch (Exception e) {
            try {
                icon = this.loadIcon(resPrefix, panelno, false);
            }
            catch (Exception ex) {
                try {
                    icon = this.loadIcon(resPrefix, panelid, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelNo) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelNo, false);
        }
        catch (Exception e) {
            try {
                icon = this.loadIcon(resPrefix, panelNo, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
    }

    protected void switchPanel(int last) {
        Class<?> processPanel;
        try {
            processPanel = Class.forName("com.izforge.izpack.panels.ProcessPanel");
        }
        catch (ClassNotFoundException e) {
            processPanel = null;
        }
        this.parentInstaller.refreshDynamicVariables(this.substitutor, this.installdata);
        try {
            if (this.installdata.curPanelNumber < last) {
                this.isBack = true;
            }
            this.centerPanel.setVisible(false);
            IzPanel panel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
            IzPanel l_panel = (IzPanel)this.installdata.panels.get(last);
            this.showHelpButton(panel.canShowHelp());
            if (Debug.isTRACE()) {
                this.debugger.switchPanel(panel.getMetadata(), l_panel.getMetadata());
            }
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: try switching panel from {0} to {1} ({2} to {3})", new String[]{l_panel.getClass().getName(), panel.getClass().getName(), Integer.toString(last), Integer.toString(this.installdata.curPanelNumber)}, "PanelTrace", null);
            if (this.visiblePanelMapping.get(this.installdata.curPanelNumber) == 0) {
                this.prevButton.setVisible(false);
                this.lockPrevButton();
                this.unlockNextButton();
            } else if (this.visiblePanelMapping.get(this.installdata.panels.size()) == this.installdata.curPanelNumber) {
                this.prevButton.setVisible(false);
                this.nextButton.setVisible(false);
                this.lockNextButton();
            } else if (this.installdata.panels.get(this.installdata.curPanelNumber - 1) instanceof InstallPanel || processPanel != null && processPanel.isInstance(this.installdata.panels.get(this.installdata.curPanelNumber - 1))) {
                this.lockPrevButton();
            } else {
                if (this.hasNavigatePrevious(this.installdata.curPanelNumber, true) != -1) {
                    this.prevButton.setVisible(true);
                    this.unlockPrevButton();
                } else {
                    this.lockPrevButton();
                    this.prevButton.setVisible(false);
                }
                if (this.hasNavigateNext(this.installdata.curPanelNumber, true) != -1) {
                    this.nextButton.setVisible(true);
                    this.unlockNextButton();
                } else {
                    this.lockNextButton();
                    this.nextButton.setVisible(false);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String buttonName = "next";
                    InstallerFrame.this.getRootPane().setDefaultButton(InstallerFrame.this.nextButton);
                    Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: setting {0} as default button", new String[]{buttonName}, "PanelTrace", null);
                }
            });
            this.centerPanel.remove(l_panel);
            l_panel.panelDeactivate();
            this.centerPanel.add(panel);
            this.performHeading(panel);
            this.performHeadingCounter(panel);
            panel.executePreActivationActions();
            if (this.useSideNavigationPanel()) {
                Panel lastPanel = (Panel)this.installdata.panelsOrder.get(last);
                PanelNode lastPanelNode = this.panelNodeMap.get(lastPanel);
                if (!this.sideNavigationActive) {
                    this.addSideNavigation();
                }
                if (this.isBack) {
                    for (Panel p : this.installdata.panelsOrder.subList(this.installdata.curPanelNumber, this.installdata.panelsOrder.size())) {
                        if (!this.panelNodeMap.containsKey(p)) continue;
                        this.panelNodeMap.get(p).removeAllChildren();
                    }
                } else {
                    for (Panel p : this.installdata.panelsOrder.subList(lastPanel.getPanelNumber() + 1, this.installdata.panelsOrder.size())) {
                        if (p.getParentPanel() != lastPanel.getPanelNumber() || !this.installdata.getRules().isConditionTrue(p.getCondition())) continue;
                        PanelNode child = new PanelNode(p);
                        lastPanelNode.add(child);
                        this.panelNodeMap.put(p, child);
                    }
                }
                ((DefaultTreeModel)this.sideNavigationTree.getModel()).reload();
                for (Panel pan : this.installdata.panelsOrder.subList(0, this.installdata.curPanelNumber)) {
                    if (!this.panelNodeMap.containsKey(pan)) continue;
                    this.sideNavigationTree.expandPath(new TreePath(this.panelNodeMap.get(pan).getPath()));
                }
            }
            panel.panelActivate();
            if (panel.getInitialFocus() != null) {
                JTextComponent inText;
                Component inFoc = panel.getInitialFocus();
                this.setFocus(inFoc);
                if (inFoc instanceof JTextComponent && (inText = (JTextComponent)inFoc).isEditable() && inText.getDocument() != null) {
                    inText.setCaretPosition(inText.getDocument().getLength());
                }
            }
            this.centerPanel.setVisible(true);
            Panel metadata = panel.getMetadata();
            if (metadata != null && !"UNKNOWN".equals(metadata.getPanelid())) {
                this.loadAndShowImage(this.visiblePanelMapping.get(this.installdata.curPanelNumber), metadata.getPanelid());
            } else {
                this.loadAndShowImage(this.visiblePanelMapping.get(this.installdata.curPanelNumber));
            }
            this.isBack = false;
            this.callGUIListener(3);
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: switched", null, "PanelTrace", null);
            this.sideNavigationTree.scrollRowToVisible(this.installdata.curPanelNumber);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void setFocus(final Component inFoc) {
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            inFoc.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    inFoc.requestFocusInWindow();
                }
            });
        }
    }

    private void writeUninstallData() {
        String logfile = this.installdata.getVariable("InstallerFrame.logfilePath");
        BufferedWriter extLogWriter = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = this.installdata.info.getUninstallerPath() + "/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, new VariableSubstitutor(this.installdata.getVariables())))).getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                Debug.trace("Cannot create logfile!");
                Debug.error(e);
            }
            if (out != null) {
                extLogWriter = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        try {
            String condition = this.installdata.getVariable("UNINSTALLER_CONDITION");
            if (condition != null && !RulesEngine.getCondition(condition).isTrue()) {
                return;
            }
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getUninstalableFilesList();
            ZipOutputStream outJar = this.installdata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outJar, "UTF-8"));
            logWriter.write(this.installdata.getInstallPath());
            logWriter.newLine();
            Iterator iter = files.iterator();
            String quickstarts = this.installdata.getVariable("installQuickStarts");
            if (quickstarts != null && quickstarts.equals("true")) {
                logWriter.write("installQuickStarts=true");
                logWriter.newLine();
                logWriter.write(this.installdata.getVariable("install.quickstarts.path") + "/" + this.installdata.getVariable("quickstarts.subdir"));
                logWriter.newLine();
            }
            if (extLogWriter != null) {
                while (iter.hasNext()) {
                    String txt = (String)iter.next();
                    logWriter.write(txt);
                    extLogWriter.write(txt);
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                    extLogWriter.newLine();
                }
                logWriter.flush();
                extLogWriter.flush();
                extLogWriter.close();
            } else {
                while (iter.hasNext()) {
                    logWriter.write((String)iter.next());
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                }
                logWriter.flush();
            }
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            Map<String, Object> additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator<String> keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            ArrayList<String> unInstallScripts = udata.getUninstallScripts();
            Iterator<String> unInstallIter = unInstallScripts.iterator();
            int idx = 0;
            while (unInstallIter.hasNext()) {
                outJar.putNextEntry(new ZipEntry("rootscript" + Integer.toString(idx)));
                ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
                String unInstallScript = unInstallIter.next();
                rootStream.writeUTF(unInstallScript);
                rootStream.flush();
                outJar.closeEntry();
                rootStream.close();
                ++idx;
            }
            outJar.flush();
            outJar.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public InputStream getResource(String res) throws Exception {
        String basePath = "";
        ResourceManager rm = null;
        try {
            rm = ResourceManager.getInstance();
            basePath = rm.resourceBasePath;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream result = this.getClass().getResourceAsStream(basePath + res);
        if (result == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + res);
        }
        return result;
    }

    public void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    public Dimension getCenterPanelSize() {
        return this.centerPanel.getSize();
    }

    public void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public void exit() {
        IzPanel curPanel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
        if (!(!this.installdata.canClose && (this.nextButton.isVisible() && this.nextButton.isEnabled() || this.prevButton.isVisible() && this.prevButton.isEnabled()) || !(curPanel instanceof HTMLLicencePanel) && !(curPanel instanceof FinishPanel))) {
            this.writeUninstallData();
            Housekeeper.getInstance().shutDown(0);
        } else {
            if (Unpacker.isDiscardInterrupt() && this.interruptCount < 3) {
                ++this.interruptCount;
                return;
            }
            String mkey = "installer.quit.reversemessage";
            String tkey = "installer.quit.reversetitle";
            String message = this.langpack.getString("installer.quit.reversemessage");
            String title = this.langpack.getString("installer.quit.reversetitle");
            if (message.indexOf("installer.quit.reversemessage") > -1) {
                message = this.langpack.getString("installer.quit.message");
            }
            if (title.indexOf("installer.quit.reversetitle") > -1) {
                title = this.langpack.getString("installer.quit.title");
            }
            VariableSubstitutor vs = new VariableSubstitutor(this.installdata.getVariables());
            message = vs.substitute(message, null);
            title = vs.substitute(title, null);
            JOptionPane.setDefaultLocale(this.installdata.locale);
            int res = curPanel.askQuestion(title, message, 37, 47);
            if (res == 47) {
                this.installdata.setVariable("install.aborted", "true");
                Housekeeper housekeeper = Housekeeper.getInstance();
                housekeeper.runCleanup();
                housekeeper.wipeFiles();
                housekeeper.shutDownNoCleanUp(0);
            } else if (curPanel.getInitialFocus() != null) {
                curPanel.getInitialFocus().requestFocus();
            }
        }
    }

    private void removeCleanFolders(String rootPath) {
        Stack<File> folderStack = new Stack<File>();
        ArrayList<File> folderQueue = new ArrayList<File>();
        folderStack.push(new File(rootPath));
        while (!folderStack.isEmpty()) {
            File thisFile = (File)folderStack.pop();
            if (!thisFile.isDirectory()) continue;
            folderQueue.add(thisFile);
            for (File child : thisFile.listFiles()) {
                if (!child.isDirectory()) continue;
                folderStack.push(child);
            }
        }
        for (int i = folderQueue.size() - 1; i >= 0; --i) {
            if (((File)folderQueue.get(i)).listFiles().length > 0) continue;
            ((File)folderQueue.get(i)).delete();
        }
    }

    public void install(AbstractUIProgressHandler listener) {
        IUnpacker unpacker = UnpackerFactory.getUnpacker(this.installdata.info.getUnpackerClassName(), this.installdata, listener);
        unpacker.setRules(this.rules);
        Thread unpackerthread = new Thread((Runnable)unpacker, "IzPack - Unpacker thread");
        unpackerthread.start();
    }

    public void writeXMLTree(IXMLElement root, OutputStream out) throws Exception {
        XMLWriter writer = new XMLWriter(out);
        for (int i = 0; i < this.installdata.panels.size(); ++i) {
            if (!this.canShow(i)) continue;
            IzPanel panel = (IzPanel)this.installdata.panels.get(i);
            panel.makeXMLData(this.installdata.xmlData.getChildAtIndex(i + 2));
        }
        writer.write(root);
    }

    public void setQuitButtonText(String text) {
        String text1 = text;
        if (text1 == null) {
            text1 = this.langpack.getString("installer.quit");
        }
        this.quitButton.setText(text1);
    }

    public void setQuitButtonIcon(String iconName) {
        String useButtonIcons = this.installdata.guiPrefs.modifier.get("useButtonIcons");
        if (useButtonIcons == null || "yes".equalsIgnoreCase(useButtonIcons)) {
            this.quitButton.setIcon(this.icons.getImageIcon(iconName));
        }
    }

    public void setQuitButtonUI(ButtonUI ui) {
        this.quitButton.setUI(ui);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
        this.callGUIListener(1);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
        this.callGUIListener(2);
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.unlockNextButton(true);
    }

    public void lockQuitButton() {
        this.quitButton.setEnabled(false);
    }

    public void unlockNextButton(boolean requestFocus) {
        this.nextButton.setEnabled(true);
        if (requestFocus) {
            this.nextButton.requestFocusInWindow();
            this.getRootPane().setDefaultButton(this.nextButton);
            if (this.getFocusOwner() != null && Debug.isTRACE()) {
                Debug.trace("Current focus owner: " + this.getFocusOwner().getName());
            }
            if (this.getRootPane().getDefaultButton() != this.nextButton) {
                Debug.trace("Next button not default button, setting...");
                this.quitButton.setDefaultCapable(false);
                this.prevButton.setDefaultCapable(false);
                this.nextButton.setDefaultCapable(true);
                this.getRootPane().setDefaultButton(this.nextButton);
            }
        }
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            if (this.isBack) {
                this.navigatePrevious(this.installdata.curPanelNumber);
            } else {
                this.navigateNext(this.installdata.curPanelNumber, false);
            }
        }
    }

    public boolean canShow(int panelnumber) {
        IzPanel panel = (IzPanel)this.installdata.panels.get(panelnumber);
        Panel panelmetadata = panel.getMetadata();
        String panelid = panelmetadata.getPanelid();
        Debug.trace("Current Panel: " + panelid);
        if (panelmetadata.hasCondition()) {
            Debug.log("Checking panelcondition");
            return this.rules.isConditionTrue(panelmetadata.getCondition());
        }
        if (!this.rules.canShowPanel(panelid, this.installdata.variables)) {
            Debug.log("Skip panel with panelid=" + panelid);
            return false;
        }
        return true;
    }

    public void navigateNext() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        this.navigateNext(this.installdata.curPanelNumber, true);
    }

    public void navigateNext(int startPanel, boolean doValidation) {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            IzPanel panel = (IzPanel)this.installdata.panels.get(startPanel);
            panel.executePreValidationActions();
            boolean isValid = doValidation ? panel.panelValidated() : true;
            panel.executePostValidationActions();
            if (!this.nextButton.isEnabled()) {
                return;
            }
            if (!isValid) {
                return;
            }
            int nextPanel = this.hasNavigateNext(startPanel, false);
            if (-1 != nextPanel) {
                this.installdata.curPanelNumber = nextPanel;
                this.switchPanel(startPanel);
            }
        }
    }

    public int hasNavigateNext(int startPanel, boolean visibleOnly) {
        int res = -1;
        for (int panel = startPanel + 1; res == -1 && panel < this.installdata.panels.size(); ++panel) {
            if (visibleOnly && this.visiblePanelMapping.get(panel) == -1 || !this.canShow(panel)) continue;
            res = panel;
        }
        return res;
    }

    public int hasNavigatePrevious(int endingPanel, boolean visibleOnly) {
        int res = -1;
        for (int panel = endingPanel - 1; res == -1 && panel >= 0; --panel) {
            if (visibleOnly && this.visiblePanelMapping.get(panel) == -1 || !this.canShow(panel)) continue;
            res = panel;
        }
        return res;
    }

    public void navigatePrevious() {
        if (!this.prevButton.isEnabled()) {
            return;
        }
        this.navigatePrevious(this.installdata.curPanelNumber);
    }

    public void navigatePrevious(int endingPanel) {
        int prevPanel = this.hasNavigatePrevious(endingPanel, false);
        if (-1 != prevPanel) {
            IzPanel panel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
            panel.saveToInstallData();
            this.installdata.curPanelNumber = prevPanel;
            this.switchPanel(endingPanel);
        }
    }

    public void showHelp() {
        ((IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber)).showHelp();
    }

    public List<GUIListener> getGuiListener() {
        return this.guiListener;
    }

    public void addGuiListener(GUIListener listener) {
        this.guiListener.add(listener);
    }

    private void createHeadingLabels(int headingLines, Color back) {
        float fontSize;
        this.headingLabels = new JLabel[headingLines + 1];
        this.headingLabels[0] = new JLabel("");
        this.headingLabels[0].setFont(FontResources.getOpenSansLight());
        Color foreground = null;
        if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
            foreground = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
            this.headingLabels[0].setForeground(foreground);
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingFontSize") && (double)(fontSize = Float.parseFloat(this.installdata.guiPrefs.modifier.get("headingFontSize"))) > 0.0 && (double)fontSize <= 5.0) {
            float currentSize = this.headingLabels[0].getFont().getSize2D();
            this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(currentSize * fontSize));
        }
        if (this.imageLeft) {
            this.headingLabels[0].setAlignmentX(1.0f);
        }
        for (int i = 1; i < headingLines; ++i) {
            this.headingLabels[i] = new JLabel();
            if (this.imageLeft) {
                this.headingLabels[i].setAlignmentX(1.0f);
                continue;
            }
            this.headingLabels[i].setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 8));
        }
    }

    private void createHeadingCounter(Color back, JPanel navPanel, JPanel leftHeadingPanel) {
        String counterPos = "inHeading";
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounterPos")) {
            counterPos = this.installdata.guiPrefs.modifier.get("headingPanelCounterPos");
        }
        if (leftHeadingPanel == null && "inHeading".equalsIgnoreCase(counterPos)) {
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounter")) {
            this.headingCounterComponent = null;
            if ("progressbar".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JProgressBar headingProgressBar = new JProgressBar();
                headingProgressBar.setStringPainted(true);
                headingProgressBar.setString("");
                headingProgressBar.setValue(0);
                this.headingCounterComponent = headingProgressBar;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                }
            } else if ("text".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JLabel headingCountPanels = new JLabel(" ");
                this.headingCounterComponent = headingCountPanels;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                } else {
                    this.headingCounterComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
                }
                Color foreground = null;
                if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
                    foreground = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
                    headingCountPanels.setForeground(foreground);
                }
            }
            if ("inHeading".equals(counterPos)) {
                leftHeadingPanel.add(this.headingCounterComponent);
            } else if ("inNavigationPanel".equals(counterPos)) {
                int i;
                Component[] comps = navPanel.getComponents();
                for (i = 0; i < comps.length && !comps[i].equals(this.prevButton); ++i) {
                }
                if (i <= comps.length) {
                    navPanel.add(Box.createHorizontalGlue(), i);
                    navPanel.add((Component)this.headingCounterComponent, i);
                }
            }
        }
    }

    private JPanel createHeadingIcon(Color back) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(HEADING_ICON_RESOURCE, 0, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel imgPanel = new JPanel();
        imgPanel.setLayout(new BoxLayout(imgPanel, 1));
        int borderSize = 8;
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageBorderSize")) {
            borderSize = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingImageBorderSize"));
        }
        imgPanel.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        if (back != null) {
            imgPanel.setBackground(back);
        }
        JLabel iconLab = new JLabel(icon);
        if (this.imageLeft) {
            imgPanel.add((Component)iconLab, "West");
        } else {
            imgPanel.add((Component)iconLab, "East");
        }
        this.headingLabels[this.headingLabels.length - 1] = iconLab;
        return imgPanel;
    }

    private void createHeading(JPanel navPanel) {
        this.headingPanel = null;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        Color back = null;
        int i = 0;
        back = UiResources.headingPanelBackground;
        if (!this.isHeading(null)) {
            this.createHeadingCounter(back, navPanel, null);
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageOnLeft") && (this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("yes") || this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("true"))) {
            this.imageLeft = true;
        }
        this.createHeadingLabels(headingLines, back);
        JPanel leftHeadingPanel = new JPanel();
        if (back != null) {
            leftHeadingPanel.setBackground(back);
        }
        leftHeadingPanel.setLayout(new BoxLayout(leftHeadingPanel, 1));
        if (this.imageLeft) {
            leftHeadingPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        for (i = 0; i < headingLines; ++i) {
            leftHeadingPanel.add(this.headingLabels[i]);
        }
        this.createHeadingCounter(back, navPanel, leftHeadingPanel);
        JPanel imgPanel = this.createHeadingIcon(back);
        JPanel northPanel = new JPanel();
        if (back != null) {
            northPanel.setBackground(back);
        }
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (this.imageLeft) {
            northPanel.add(imgPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(leftHeadingPanel);
        } else {
            northPanel.add(leftHeadingPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(imgPanel);
        }
        this.headingPanel = new JPanel(new BorderLayout());
        this.headingPanel.add(northPanel);
        this.headingPanel.add((Component)new JSeparator(), "South");
        this.contentPane.add((Component)this.headingPanel, "North");
    }

    public boolean isHeading(IzPanel caller) {
        if (!this.installdata.guiPrefs.modifier.containsKey("useHeadingPanel") || !this.installdata.guiPrefs.modifier.get("useHeadingPanel").equalsIgnoreCase("yes")) {
            return false;
        }
        if (caller == null) {
            return true;
        }
        return true;
    }

    private void performHeading(IzPanel panel) {
        int i;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        if (this.headingLabels == null) {
            return;
        }
        for (i = 0; i <= headingLines; ++i) {
            if (this.headingLabels[i] == null) continue;
            this.headingLabels[i].setVisible(false);
        }
        for (i = 0; i < headingLines - 1; ++i) {
            String info = panel.getI18nStringForClass("headinfo" + Integer.toString(i));
            if (info == null) {
                info = " ";
            }
            if (info.endsWith(":")) {
                info = info.substring(0, info.length() - 1) + ".";
            }
            this.headingLabels[i + 1].setText(info);
            this.headingLabels[i + 1].setVisible(true);
        }
        int curPanelNo = this.visiblePanelMapping.get(this.installdata.curPanelNumber);
        if (this.headingLabels[headingLines] != null) {
            this.loadAndShowImage(this.headingLabels[headingLines], HEADING_ICON_RESOURCE, curPanelNo);
            this.headingLabels[headingLines].setVisible(true);
        }
        this.headingPanel.setVisible(true);
    }

    private void performHeadingCounter(IzPanel panel) {
        if (this.headingCounterComponent != null) {
            int curPanelNo = this.visiblePanelMapping.get(this.installdata.curPanelNumber);
            int visPanelsCount = this.visiblePanelMapping.get(this.visiblePanelMapping.get(this.installdata.panels.size()));
            StringBuffer buf = new StringBuffer();
            buf.append(this.langpack.getString("installer.step")).append(" ").append(curPanelNo + 1).append(" ").append(this.langpack.getString("installer.of")).append(" ").append(visPanelsCount + 1);
            if (this.headingCounterComponent instanceof JProgressBar) {
                JProgressBar headingProgressBar = (JProgressBar)this.headingCounterComponent;
                headingProgressBar.setMaximum(visPanelsCount + 1);
                headingProgressBar.setValue(curPanelNo + 1);
                headingProgressBar.setString(buf.toString());
            } else {
                ((JLabel)this.headingCounterComponent).setText(buf.toString());
            }
        }
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public InstallerBase getParentInstaller() {
        return this.parentInstaller;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    private void showHelpButton(boolean show) {
        if (this.helpButton == null) {
            return;
        }
        this.helpButton.setVisible(show);
    }

    public void removeSideNavigation() {
        this.sideNavigationActive = false;
        this.contentPane.remove(this.sideNavigationTree);
    }

    public void addSideNavigation() {
        this.sideNavigationActive = true;
        JScrollPane scrollPane = this.makeTreeScrollPane();
        this.contentPane.add((Component)scrollPane, "West");
    }

    private JScrollPane makeTreeScrollPane() {
        JScrollPane scrollPane = ScrollPaneFactory.createScroller(this.sideNavigationTree);
        scrollPane.setBorder(new MatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
        return scrollPane;
    }

    private boolean useSideNavigationPanel() {
        String useSidenav = this.installdata.guiPrefs.modifier.get("useSideNavigation");
        if (useSidenav != null) {
            return this.installdata.guiPrefs.modifier.get("useSideNavigation").equalsIgnoreCase("yes");
        }
        return false;
    }

    private GridBagConstraints getSideNavExtensionConstraints() {
        GridBagConstraints sideExtensionConstraints = new GridBagConstraints();
        sideExtensionConstraints.weighty = 0.0;
        sideExtensionConstraints.weightx = 0.0;
        sideExtensionConstraints.gridx = 0;
        sideExtensionConstraints.gridy = 0;
        sideExtensionConstraints.anchor = 17;
        sideExtensionConstraints.fill = 3;
        sideExtensionConstraints.insets = new Insets(-8, -8, -8, -8);
        return sideExtensionConstraints;
    }

    public int getSideNavigationWidth() {
        return this.sideNavigationTree.getWidth();
    }

    class SideNavTreeNodeListener
    implements TreeModelListener {
        SideNavTreeNodeListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    public static class PanelNode
    extends DefaultMutableTreeNode {
        private boolean expandable = false;
        private boolean collapsable = false;
        private int number = 0;

        public PanelNode(Object userObject) {
            super(userObject);
        }

        public void setExpandable(boolean expandable) {
            this.expandable = expandable;
        }

        public boolean isExpandable() {
            return this.expandable;
        }

        public void setNumber(int n) {
            this.number = n;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean isCollapsable() {
            return this.collapsable;
        }

        public void setCollapsable(boolean collapsable) {
            this.collapsable = collapsable;
        }
    }

    private class SideNavigationRenderer
    implements TreeCellRenderer {
        private SideNavigationRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String htmlLabelWrapString = "<html><div style=\"width:100px;\">%s</div></html>";
            JPanel rendererPanel = new JPanel();
            rendererPanel.setLayout(new BoxLayout(rendererPanel, 0));
            rendererPanel.setOpaque(false);
            rendererPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            int gap = 28;
            JLabel imageLabel = new JLabel();
            JLabel panelLabel = new JLabel();
            panelLabel.setOpaque(false);
            panelLabel.setFont(FontResources.getOpenSansRegular());
            if (value instanceof PanelNode) {
                PanelNode panelNode = (PanelNode)value;
                Panel p = (Panel)panelNode.getUserObject();
                if (panelNode.isRoot()) {
                    return rendererPanel;
                }
                if (InstallerFrame.this.installdata.langpack.containsKey(p.getSideNavId())) {
                    panelLabel.setText(String.format("<html><div style=\"width:100px;\">%s</div></html>", InstallerFrame.this.installdata.langpack.getString(p.getSideNavId())));
                } else {
                    panelLabel.setText(String.format("<html><div style=\"width:100px;\">%s</div></html>", p.getSideNavId()));
                }
                if (this.isCurrentPanel(panelNode)) {
                    panelNode.setExpandable(true);
                    imageLabel.setFont(FontResources.getFontAwesome());
                    imageLabel.setText("\uf0a9");
                    imageLabel.setForeground(UiResources.progressBarGradientLight);
                    panelLabel.setForeground(UiResources.sidenavigationTextActive);
                } else if (this.isChecked(panelNode)) {
                    panelNode.setExpandable(true);
                    imageLabel.setFont(FontResources.getFontAwesome());
                    imageLabel.setText("\uf00c");
                    imageLabel.setForeground(UiResources.checkMarkGreen);
                    panelLabel.setForeground(UiResources.sidenavigationTextActive);
                } else {
                    panelNode.setExpandable(false);
                    Panel panel = (Panel)panelNode.getUserObject();
                    imageLabel.setFont(FontResources.getOpenSansRegular());
                    imageLabel.setText(this.getPanelNumber(panel));
                    imageLabel.setForeground(UiResources.sidenavigationTextInactive);
                    panelLabel.setForeground(UiResources.sidenavigationTextInactive);
                }
            }
            rendererPanel.add((Component)imageLabel, 0);
            rendererPanel.add(Box.createRigidArea(new Dimension(gap - imageLabel.getPreferredSize().width, 0)), 1);
            rendererPanel.add((Component)panelLabel, 2);
            return rendererPanel;
        }

        private String getPanelNumber(Panel panel) {
            StringBuffer returnValue = new StringBuffer();
            PanelNode curr = (PanelNode)InstallerFrame.this.panelNodeMap.get(panel);
            int parentNumber = ((PanelNode)curr.getParent()).getNumber();
            int number = curr.getParent().getIndex(curr) + 1;
            curr.setNumber(number);
            if (parentNumber > 0) {
                returnValue.append(parentNumber).append(".").append(number);
            } else {
                returnValue.append(number);
            }
            return returnValue.toString();
        }

        private boolean isCurrentPanel(PanelNode panelNode) {
            PanelNode currPanelNode = (PanelNode)InstallerFrame.this.panelNodeMap.get(InstallerFrame.this.installdata.panelsOrder.get(InstallerFrame.this.installdata.curPanelNumber));
            return currPanelNode != null && ((PanelNode)InstallerFrame.this.panelNodeMap.get(InstallerFrame.this.installdata.panelsOrder.get(InstallerFrame.this.installdata.curPanelNumber))).isNodeAncestor(panelNode);
        }

        protected boolean isChecked(PanelNode panelNode) {
            Panel panel = (Panel)panelNode.getUserObject();
            return InstallerFrame.this.installdata.curPanelNumber > panel.getPanelNumber();
        }
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        @Override
        protected boolean accept(Component aComp) {
            return aComp == InstallerFrame.this.getGlassPane();
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            InstallerFrame.this.exit();
        }
    }

    class HelpHandler
    implements ActionListener {
        HelpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstallerFrame.this.showHelp();
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InstallerFrame.this.blockGUI();
                        }
                    });
                    NavigationHandler.this.navigate(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InstallerFrame.this.releaseGUI();
                        }
                    });
                }
            }).start();
        }

        private void navigate(ActionEvent e) {
            Object source = e.getSource();
            if (source == InstallerFrame.this.prevButton) {
                InstallerFrame.this.navigatePrevious();
            } else if (source == InstallerFrame.this.nextButton) {
                InstallerFrame.this.navigateNext();
            } else if (source == InstallerFrame.this.quitButton || source == InstallerFrame.this.doneButton) {
                InstallerFrame.this.exit();
            }
        }
    }

    public class BackPanel
    extends JPanel {
        private static final long serialVersionUID = -8713775363502830437L;
        private Image image = null;

        BackPanel() {
            try {
                this.image = new ImageIcon(this.getClass().getResource("/res/Installer.background")).getImage();
            }
            catch (Exception e) {
                return;
            }
            InstallerFrame.this.hasBackground = true;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image, this.getWidth() / 2 - this.image.getWidth(this) / 2, this.getHeight() / 2 - this.image.getHeight(this) / 2, this.image.getWidth(this), this.image.getHeight(this), this);
            }
        }
    }
}

