/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.LayoutHelper;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionDialog;
import com.izforge.izpack.panels.HelpWindow;
import com.izforge.izpack.panels.JTextMessagePane;
import com.izforge.izpack.panels.SkippableDataValidator;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLDocument;

public class IzPanel
extends JPanel
implements AbstractUIHandler,
LayoutConstants {
    private static final long serialVersionUID = 3256442495255786038L;
    protected LayoutHelper layoutHelper;
    protected Component initialFocus = null;
    protected InstallData idata;
    protected InstallerFrame parent;
    protected String myFullClassname;
    protected String myClassname;
    protected String myPrefix;
    protected String headline;
    protected JLabel headLineLabel;
    protected boolean hidden;
    protected boolean delay;
    protected boolean displayHidden;
    protected int delayLength;
    protected Timer delayTimer;
    protected boolean inSummaryPanel;
    public static final String HEADLINE = "headline";
    private List<DataValidator> validationServices = null;
    private List<PanelAction> preActivateActions = null;
    private List<PanelAction> preValidateActions = null;
    private List<PanelAction> postValidateActions = null;
    private boolean view = false;
    public int maxMessageWidth;
    public static final int X_ORIGIN = 0;
    public static final int Y_ORIGIN = 0;
    public static final String D = ".";
    public static final String d = ".";
    public static final int COLS_1 = 1;
    public static final int ROWS_1 = 1;
    public Panel metadata;
    public FontMetrics fontMetrics;
    private HashMap<String, String> helps = null;
    private HelpWindow helpWindow = null;

    public IzPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, (LayoutManager2)null);
    }

    public IzPanel(InstallerFrame parent, InstallData idata, LayoutManager2 lm) {
        if (parent.hasBackground) {
            this.setOpaque(false);
        }
        this.init(parent, idata);
        if (lm != null) {
            this.getLayoutHelper().startLayout(lm);
        }
    }

    private void enableNextButton(Boolean requestFocus) {
        this.parent.unlockNextButton(requestFocus);
    }

    public IzPanel(InstallerFrame parent, InstallData idata, String iconName) {
        this(parent, idata, iconName, -1);
    }

    public IzPanel(InstallerFrame parent, InstallData idata, String iconName, int instance) {
        this(parent, idata);
        this.buildHeadline(iconName, instance);
    }

    protected boolean buildHeadline(String imageIconName, int instanceNumber) {
        String headline;
        boolean result = false;
        if (this.parent.isHeading(this)) {
            return false;
        }
        String headlineSearchBaseKey = this.myClassname + "." + HEADLINE;
        if (instanceNumber > -1) {
            String instanceSearchKey = headlineSearchBaseKey + "." + Integer.toString(instanceNumber);
            String instanceHeadline = this.getString(instanceSearchKey);
            if (Debug.isLOG()) {
                System.out.println("found headline: " + instanceHeadline + "." + " for instance # " + instanceNumber);
            }
            headline = !instanceSearchKey.equals(instanceHeadline) ? instanceHeadline : this.getString(headlineSearchBaseKey);
        } else {
            headline = this.getString(headlineSearchBaseKey);
        }
        if (headline != null) {
            this.headLineLabel = imageIconName != null && !"".equals(imageIconName) ? new JLabel(this.getImageIcon(imageIconName), 10) : new JLabel(headline);
            Font font = this.headLineLabel.getFont();
            float size = font.getSize();
            int style = 0;
            font = font.deriveFont(style, size * 1.5f);
            this.headLineLabel.setFont(font);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.headLineLabel.setName(HEADLINE);
            ((GridBagLayout)this.getLayout()).addLayoutComponent(this.headLineLabel, gbc);
            this.add(this.headLineLabel);
        }
        return result;
    }

    public String getString(String key) {
        return this.parent.langpack.getString(key);
    }

    public ImageIcon getImageIcon(String iconName) {
        return this.parent.icons.getImageIcon(iconName);
    }

    protected void initLayoutHelper() {
        this.layoutHelper = new LayoutHelper(this);
    }

    protected void getClassName() {
        this.myFullClassname = this.getClass().getName();
        this.myClassname = this.myFullClassname.substring(this.myFullClassname.lastIndexOf(".") + 1);
        this.myPrefix = this.myClassname + ".";
    }

    protected void init(InstallerFrame parent, InstallData idata) {
        this.getClassName();
        this.idata = idata;
        this.parent = parent;
        this.metadata = idata.currentPanel;
        this.fontMetrics = this.getFontMetrics(this.getFont());
        idata.currentPanel = null;
        this.maxMessageWidth = idata.guiPrefs.width - 175;
        this.initLayoutHelper();
    }

    protected boolean isValidated() {
        return true;
    }

    public boolean panelValidated() {
        return this.isValidated() && this.validatePanel();
    }

    public void panelActivate() {
        if (this.isDelayed()) {
            this.delayTimer = new Timer(this.delayLength, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    IzPanel.this.enableNextButton(false);
                }
            });
            this.delayTimer.setRepeats(false);
            this.parent.lockNextButton();
            this.delayTimer.start();
        }
    }

    public void panelDeactivate() {
    }

    public void makeXMLData(IXMLElement panelRoot) {
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    @Override
    public int askQuestion(String title, String question, int choices, int default_choice) {
        int jo_choices = 0;
        if (choices == 37) {
            jo_choices = 0;
        } else if (choices == 38) {
            jo_choices = 1;
        }
        int user_choice = JOptionPane.showConfirmDialog(this.parent.contentPane, this.createJTextMessagePane(question), title, jo_choices, 3);
        if (user_choice == 2) {
            return 45;
        }
        if (user_choice == 0) {
            return 47;
        }
        if (user_choice == -1) {
            return 49;
        }
        if (user_choice == 1) {
            return 49;
        }
        return default_choice;
    }

    public boolean emitNotificationFeedback(String message) {
        return JOptionPane.showConfirmDialog(this.parent.contentPane, this.createJTextMessagePane(message), this.idata.langpack.getString("installer.Message"), 2, 2) == 0;
    }

    @Override
    public void emitNotification(String message) {
        JOptionPane.showMessageDialog(this.parent.contentPane, this.createJTextMessagePane(message));
    }

    public void emitNotification(String message, boolean hasLinks) {
        if (!hasLinks) {
            this.emitNotification(message);
        } else {
            this.emitNotification(message, hasLinks, 400);
        }
    }

    public void emitNotification(String message, boolean hasLinks, int size) {
        if (!hasLinks) {
            this.emitNotification(message);
            return;
        }
        JEditorPane pane = new JEditorPane("text/html", "<html><div style=\"width:" + size + "px;\">" + message + "</div></html>");
        pane.setMaximumSize(new Dimension(this.idata.guiPrefs.width, this.idata.guiPrefs.height));
        pane.setMargin(new Insets(0, 0, 0, 0));
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setBackground(new JLabel().getBackground());
        Font font = this.getControlTextFont();
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)pane.getDocument()).getStyleSheet().addRule(bodyRule);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            if (e.getURL() != null) {
                                desktop.browse(URI.create(e.getURL().toString()));
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        JOptionPane.showMessageDialog(this.parent.contentPane, pane);
    }

    @Override
    public boolean emitWarning(String title, String message) {
        return JOptionPane.showConfirmDialog(this.parent.contentPane, this.createJTextMessagePane(message), title, 2, 2) == 0;
    }

    public int emitWarningWithSkip(String titleId, String message, Object[] optionLabels) {
        int ret = JOptionPane.showOptionDialog(this.parent.contentPane, this.createJTextMessagePane(message), this.idata.langpack.getString(titleId), 1, 2, null, optionLabels, optionLabels[0]);
        return ret;
    }

    public int emitWarningWithSkip(String title, String message) {
        Object[] options = new Object[]{"Continue", "Skip", "Cancel"};
        return this.emitWarningWithSkip(title, message, options);
    }

    @Override
    public void emitError(String title, String message) {
        JOptionPane.showMessageDialog(this.parent.contentPane, this.createJTextMessagePane(message), title, 0);
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        this.emitError(title, message);
        this.parent.lockNextButton();
    }

    public Component getInitialFocus() {
        return this.initialFocus;
    }

    public void setInitialFocus(Component component) {
        this.initialFocus = component;
    }

    public String getI18nStringForClass(String subkey) {
        String retval = null;
        Class<?> clazz = this.getClass();
        while (retval == null && !clazz.getName().endsWith(".IzPanel")) {
            retval = this.getI18nStringForClass(clazz.getName(), subkey, null);
            clazz = clazz.getSuperclass();
        }
        return retval;
    }

    public void loadFileChooserLang() {
        UIManager.put("FileChooser.fileNameHeaderText", this.getI18nStringForClass("fileNameHeaderText", "BrowseDialog"));
        UIManager.put("FileChooser.fileSizeHeaderText", this.getI18nStringForClass("fileSizeHeaderText", "BrowseDialog"));
        UIManager.put("FileChooser.fileDateHeaderText", this.getI18nStringForClass("fileDateHeaderText", "BrowseDialog"));
        UIManager.put("FileChooser.viewMenuLabelText", this.getI18nStringForClass("viewMenuLabelText", "BrowseDialog"));
        UIManager.put("FileChooser.refreshActionLabelText", this.getI18nStringForClass("refreshActionLabelText", "BrowseDialog"));
        UIManager.put("FileChooser.newFolderActionLabelText", this.getI18nStringForClass("newFolderActionLabelText", "BrowseDialog"));
        UIManager.put("FileChooser.detailsViewActionLabelText", this.getI18nStringForClass("detailsViewActionLabelText", "BrowseDialog"));
        UIManager.put("FileChooser.listViewActionLabelText", this.getI18nStringForClass("listViewActionLabelText", "BrowseDialog"));
        UIManager.put("FileChooser.fileNameLabelText", this.getI18nStringForClass("filename", "BrowseDialog"));
        UIManager.put("FileChooser.filesOfTypeLabelText", this.getI18nStringForClass("filetype", "BrowseDialog"));
        UIManager.put("FileChooser.openDialogTitleText", this.getI18nStringForClass("title", "BrowseDialog"));
        UIManager.put("FileChooser.saveDialogTitleText", this.getI18nStringForClass("title", "BrowseDialog"));
        UIManager.put("FileChooser.openButtonText", this.getI18nStringForClass("openButton", "BrowseDialog"));
        UIManager.put("FileChooser.saveButtonText", this.getI18nStringForClass("openButton", "BrowseDialog"));
        UIManager.put("FileChooser.cancelButtonText", this.getI18nStringForClass("closeButton", "BrowseDialog"));
        UIManager.put("FileChooser.newFolderToolTipText", this.getI18nStringForClass("newButton", "BrowseDialog"));
        UIManager.put("FileChooser.renameFileButtonText", this.getI18nStringForClass("renameButton", "BrowseDialog"));
        UIManager.put("FileChooser.deleteFileButtonText", this.getI18nStringForClass("deleteButton", "BrowseDialog"));
        UIManager.put("FileChooser.openButtonToolTipText", this.getI18nStringForClass("openButtonTT", "BrowseDialog"));
        UIManager.put("FileChooser.saveButtonToolTipText", this.getI18nStringForClass("openButtonTT", "BrowseDialog"));
        UIManager.put("FileChooser.cancelButtonToolTipText", this.getI18nStringForClass("cancelButtonTT", "BrowseDialog"));
        UIManager.put("FileChooser.lookInLabelText", this.getI18nStringForClass("selectionText", "BrowseDialog"));
        UIManager.put("FileChooser.saveInLabelText", this.getI18nStringForClass("selectionText", "BrowseDialog"));
        UIManager.put("FileChooser.foldersLabelText", this.getI18nStringForClass("folderLabelText", "BrowseDialog"));
        UIManager.put("FileChooser.pathLabelText", this.getI18nStringForClass("selectionText", "BrowseDialog"));
        UIManager.put("FileChooser.folderNameLabelText", this.getI18nStringForClass("selectionText", "BrowseDialog"));
        UIManager.put("FileChooser.homeFolderToolTipText", this.getI18nStringForClass("homeButton", "BrowseDialog"));
        UIManager.put("FileChooser.upFolderToolTipText", this.getI18nStringForClass("upButton", "BrowseDialog"));
        UIManager.put("FileChooser.listViewButtonToolTipText", this.getI18nStringForClass("listButton", "BrowseDialog"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", this.getI18nStringForClass("detailsButton", "BrowseDialog"));
    }

    public String getI18nStringForClass(String subkey, String alternateClass) {
        return this.getI18nStringForClass(this.getClass().getName(), subkey, alternateClass);
    }

    private String getI18nStringForClass(String curClassName, String subkey, String alternateClass) {
        int nameStart = curClassName.lastIndexOf(46) + 1;
        curClassName = curClassName.substring(nameStart, curClassName.length());
        StringBuffer buf = new StringBuffer();
        buf.append(curClassName).append(".").append(subkey);
        String fullkey = buf.toString();
        String panelid = null;
        if (this.getMetadata() != null) {
            panelid = this.getMetadata().getPanelid();
        }
        String retval = null;
        if (panelid != null) {
            buf.append(".");
            buf.append(panelid);
            retval = this.parent.langpack.getString(buf.toString());
        }
        if (retval == null || retval.startsWith(fullkey)) {
            retval = this.parent.langpack.getString(fullkey);
        }
        if (retval == null || retval.startsWith(fullkey)) {
            if (alternateClass == null) {
                return null;
            }
            buf.delete(0, buf.length());
            buf.append(alternateClass).append(".").append(subkey);
            retval = this.parent.langpack.getString(buf.toString());
        }
        if (retval != null && retval.indexOf(36) > -1) {
            VariableSubstitutor substitutor = new VariableSubstitutor(this.idata.getVariables());
            retval = substitutor.substitute(retval, null);
        }
        return retval;
    }

    public InstallerFrame getInstallerFrame() {
        return this.parent;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create(msg, ii, pos);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos, boolean isFullLine) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create(msg, ii, pos, isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String textId, String iconId, int pos) {
        return this.createLabel(textId, iconId, pos, false);
    }

    public JLabel createLabel(String textId, String iconId, int pos, boolean isFullLine) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        JLabel label = LabelFactory.create(this.parent.langpack.getString(textId), ii, pos, isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public MultiLineLabel createMultiLineLabelLang(String textId) {
        return this.createMultiLineLabel(this.parent.langpack.getString(textId));
    }

    public MultiLineLabel createMultiLineLabel(String text) {
        return this.createMultiLineLabel(text, null, 2);
    }

    public MultiLineLabel createMultiLineLabel(String text, String iconId, int pos) {
        MultiLineLabel mll = null;
        mll = new MultiLineLabel(text, 0, 1);
        if (mll != null) {
            mll.setFont(this.getControlTextFont());
        }
        return mll;
    }

    public Font getControlTextFont() {
        Font fontObj = IzPanel.getLAF() == null ? MetalLookAndFeel.getControlTextFont() : this.getFont();
        float val = LabelFactory.getLabelFontSize();
        if (val != 1.0f) {
            fontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
        return fontObj;
    }

    protected static MetalLookAndFeel getLAF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof MetalLookAndFeel) {
            return (MetalLookAndFeel)laf;
        }
        return null;
    }

    public GridBagConstraints getDefaultGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getDefaultConstraints();
    }

    public void setDefaultGridBagConstraints(GridBagConstraints constraints) {
        this.layoutHelper.setDefaultConstraints(constraints);
    }

    public void resetGridCounter() {
        this.layoutHelper.resetGridCounter();
    }

    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy);
    }

    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy, gridwidth, gridheight);
    }

    public GridBagConstraints getNextXGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextXConstraints();
    }

    public GridBagConstraints getNextYGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints();
    }

    public GridBagConstraints getNextYGridBagConstraints(int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints(gridwidth, gridheight);
    }

    public void startGridBagLayout() {
        this.layoutHelper.startLayout(new GridBagLayout());
    }

    public void completeGridBagLayout() {
    }

    public String getInstanceNumber() {
        return null;
    }

    public String getSummaryBody() {
        return null;
    }

    public String getSummaryCaption() {
        String caption = this.parent.isHeading(this) && this.idata.guiPrefs.modifier.containsKey("useHeadingForSummary") && this.idata.guiPrefs.modifier.get("useHeadingForSummary").equalsIgnoreCase("yes") ? this.getI18nStringForClass(HEADLINE, this.getClass().getName()) : (this.getClass().getName().equals("com.izforge.izpack.panels.UserInputPanel") ? this.getI18nStringForClass("summaryCaption." + this.getInstanceNumber(), this.getClass().getName()) : this.getI18nStringForClass("summaryCaption", this.getClass().getName()));
        return caption;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public LayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public Panel getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Panel p) {
        this.metadata = p;
    }

    public List<DataValidator> getValidationService() {
        return this.validationServices;
    }

    public void setValidationServices(List<DataValidator> validationService) {
        this.validationServices = validationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validatePanel() {
        boolean returnValue = false;
        if (this.validationServices != null) {
            Container guiComponent = this.getTopLevelAncestor();
            Cursor originalCursor = guiComponent.getCursor();
            Cursor newCursor = Cursor.getPredefinedCursor(3);
            try {
                guiComponent.setCursor(newCursor);
                for (DataValidator validationService : this.validationServices) {
                    DataValidator.Status returnStatus = validationService.validateData(this.idata);
                    if (returnStatus == DataValidator.Status.OK) {
                        returnValue = true;
                        continue;
                    }
                    Debug.trace("Validation did not pass!");
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    if (returnStatus == DataValidator.Status.WARNING) {
                        String warningMessage = validationService.getFormattedMessage();
                        if (this.emitWarning(this.getString("data.validation.warning.title"), vs.substitute(warningMessage, null))) {
                            returnValue = true;
                            Debug.trace("... but user decided to go on!");
                            continue;
                        }
                        returnValue = false;
                        Debug.trace("... and the user decided to stop.");
                    }
                    if (returnStatus == DataValidator.Status.SKIP) {
                        Debug.trace("... validator returned SKIP status.");
                        if (SkippableDataValidator.class.isAssignableFrom(validationService.getClass())) {
                            SkippableDataValidator skipValidator = (SkippableDataValidator)validationService;
                            int userInput = this.emitWarningWithSkip(skipValidator.getSkipMessageId(), skipValidator.getFormattedMessage(), skipValidator.getSkipOptionLabels(this.idata));
                            Debug.trace("...running SKIP action.");
                            returnValue = skipValidator.skipActions(this.idata, userInput);
                            if (returnValue) continue;
                            boolean bl = returnValue;
                            return bl;
                        }
                        returnValue = true;
                        continue;
                    }
                    String errorMessage = validationService.getFormattedMessage();
                    if (errorMessage != null) {
                        this.emitError(this.getString("data.validation.error.title"), vs.substitute(errorMessage, null));
                    } else {
                        this.emitError(this.getString("data.validation.error.title"), "Validation Error");
                    }
                    returnValue = false;
                }
            }
            finally {
                guiComponent.setCursor(originalCursor);
            }
        } else {
            returnValue = true;
        }
        return returnValue;
    }

    protected String parseText(String string_to_parse) {
        try {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            string_to_parse = vs.substitute(string_to_parse, null);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return string_to_parse;
    }

    private JTextMessagePane createJTextMessagePane(String message) {
        return new JTextMessagePane(message, this.maxMessageWidth, this.fontMetrics);
    }

    public boolean isDelayed() {
        return this.delay;
    }

    public void setDelay(boolean delay) {
        this.delay = delay;
    }

    public boolean isDisplayingHidden() {
        return this.displayHidden;
    }

    public void displayHidden(boolean displayHidden) {
        this.displayHidden = displayHidden;
    }

    public int getDelayLength() {
        return this.delayLength;
    }

    public boolean isInSummaryPanel() {
        return this.inSummaryPanel;
    }

    public void setInSummaryPanel(boolean inSummaryPanel) {
        this.inSummaryPanel = inSummaryPanel;
    }

    public void setDelayLength(int delayLength) {
        this.delayLength = delayLength;
    }

    public Timer getDelayTimer() {
        return this.delayTimer;
    }

    public void setDelayTimer(Timer delayTimer) {
        this.delayTimer = delayTimer;
    }

    public void setHelps(HashMap helps) {
        this.helps = helps;
    }

    public void setView() {
        this.view = true;
    }

    public boolean getView() {
        return this.view;
    }

    public String getHelpUrl(String isoCode) {
        String url = null;
        if (this.helps != null) {
            url = this.helps.get(isoCode);
        }
        return url;
    }

    public boolean canShowHelp() {
        return this.getHelpUrl(this.idata.localeISO3) != null;
    }

    public void showHelp() {
        String helpName = this.getHelpUrl(this.idata.localeISO3);
        if (helpName != null) {
            URL helpUrl = this.getClass().getResource("/res/" + helpName);
            this.getHelpWindow().showHelp(this.getString("installer.help"), helpUrl);
        }
    }

    private HelpWindow getHelpWindow() {
        if (this.helpWindow != null) {
            return this.helpWindow;
        }
        this.helpWindow = new HelpWindow((Frame)this.parent, this.getString("installer.prev"));
        return this.helpWindow;
    }

    public void addPreActivationAction(PanelAction preActivateAction) {
        if (this.preActivateActions == null) {
            this.preActivateActions = new ArrayList<PanelAction>();
        }
        this.preActivateActions.add(preActivateAction);
    }

    public void addPreValidationAction(PanelAction preValidateAction) {
        if (this.preValidateActions == null) {
            this.preValidateActions = new ArrayList<PanelAction>();
        }
        this.preValidateActions.add(preValidateAction);
    }

    public void addPostValidationAction(PanelAction postValidateAction) {
        if (this.postValidateActions == null) {
            this.postValidateActions = new ArrayList<PanelAction>();
        }
        this.postValidateActions.add(postValidateAction);
    }

    protected final void executePreActivationActions() {
        if (this.preActivateActions != null) {
            for (int actionIndex = 0; actionIndex < this.preActivateActions.size(); ++actionIndex) {
                PanelAction action = this.preActivateActions.get(actionIndex);
                this.initActionPanel(action);
                action.executeAction(this.idata, this);
            }
        }
    }

    protected final void executePreValidationActions() {
        if (this.preValidateActions != null) {
            for (int actionIndex = 0; actionIndex < this.preValidateActions.size(); ++actionIndex) {
                PanelAction action = this.preValidateActions.get(actionIndex);
                this.initActionPanel(action);
                action.executeAction(this.idata, this);
            }
        }
    }

    protected final void executePostValidationActions() {
        if (this.postValidateActions != null) {
            for (int actionIndex = 0; actionIndex < this.postValidateActions.size(); ++actionIndex) {
                PanelAction action = this.postValidateActions.get(actionIndex);
                this.initActionPanel(action);
                action.executeAction(this.idata, this);
            }
        }
    }

    private void initActionPanel(PanelAction action) {
        if (PanelActionDialog.class.isAssignableFrom(action.getClass())) {
            PanelActionDialog dialogAction = (PanelActionDialog)action;
            dialogAction.setParent(this.parent);
        }
    }

    public void saveToInstallData() {
    }

    public static class Filler
    extends JComponent {
        private static final long serialVersionUID = 3258416144414095153L;
    }
}

