/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.XPackFile;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IMultiVolumeUnpackerHelper;
import com.izforge.izpack.installer.MultiVolumeInstaller;
import com.izforge.izpack.installer.MultiVolumeUnpackerAutomationHelper;
import com.izforge.izpack.installer.MultiVolumeUnpackerHelper;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.io.CorruptVolumeException;
import com.izforge.izpack.io.FileSpanningInputStream;
import com.izforge.izpack.io.VolumeNotFoundException;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class MultiVolumeUnpacker
extends UnpackerBase {
    protected IMultiVolumeUnpackerHelper helper;

    public MultiVolumeUnpacker(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        super(idata, handler);
        if (handler instanceof PanelAutomation) {
            Debug.trace("running in auto installation mode.");
            this.helper = new MultiVolumeUnpackerAutomationHelper();
        } else {
            Debug.trace("running in normal installation mode.");
            this.helper = new MultiVolumeUnpackerHelper();
        }
        this.helper.init(idata, handler);
    }

    public IMultiVolumeUnpackerHelper getHelper() {
        return this.helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addToInstances();
        try {
            FileOutputStream out = null;
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updatechecks = new ArrayList<UpdateCheck>();
            List<Pack> packs = this.idata.selectedPacks;
            int npacks = packs.size();
            Debug.trace("Unpacker starting");
            this.handler.startAction("Unpacking", npacks);
            this.udata = UninstallData.getInstance();
            List[] customActions = this.getCustomActions();
            this.informListeners(customActions, 7, this.idata, npacks, this.handler);
            packs = this.idata.selectedPacks;
            npacks = packs.size();
            if (npacks == 0) {
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(customActions, 8, this.idata, this.handler, null);
                if (this.performInterrupted()) {
                    return;
                }
                this.handler.stopAction();
                return;
            }
            InputStream in = MultiVolumeUnpacker.class.getResourceAsStream("/volumes.info");
            ObjectInputStream metadataobj = new ObjectInputStream(in);
            int volumes = metadataobj.readInt();
            String volumename = metadataobj.readUTF();
            Debug.trace("Reading from " + volumes + " volumes with basename " + volumename + " ");
            metadataobj.close();
            String mediadirectory = MultiVolumeInstaller.getMediadirectory();
            if (mediadirectory == null || mediadirectory.length() <= 0) {
                Debug.trace("Mediadirectory wasn't set.");
                mediadirectory = System.getProperty("java.io.tmpdir");
            }
            Debug.trace("Using mediadirectory = " + mediadirectory);
            File volume = new File(mediadirectory + File.separator + volumename);
            if (!volume.exists()) {
                volume = this.helper.enterNextMediaMessage(volume.getAbsolutePath());
            }
            FileSpanningInputStream fin = new FileSpanningInputStream(volume, volumes);
            for (int i = 0; i < npacks; ++i) {
                String name;
                Pack p = packs.get(i);
                int n = this.idata.allPacks.indexOf(p);
                in = MultiVolumeUnpacker.class.getResourceAsStream("/packs/pack" + n);
                this.informListeners(customActions, 5, packs.get(i), npacks, this.handler);
                ObjectInputStream objIn = new ObjectInputStream(in);
                int nfiles = objIn.readInt();
                int fileCount = p.getFileCount();
                Pack pack = packs.get(i);
                if (pack.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pack.getCondition())) continue;
                String stepname = pack.name;
                if (this.langpack != null && pack.id != null && !"".equals(pack.id) && (name = this.langpack.getString(pack.id)) != null && !"".equals(name)) {
                    stepname = name;
                }
                this.handler.nextStep(stepname, i + 1, fileCount);
                for (int j = 0; j < nfiles; ++j) {
                    XPackFile pf = (XPackFile)objIn.readObject();
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) continue;
                    if (OsConstraint.oneMatchesCurrentSystem(pf.osConstraints())) {
                        File pathFile;
                        String path = IoHelper.translatePath(pf.getTargetPath(), this.vs);
                        File dest = pathFile = new File(path);
                        if (!pf.isDirectory()) {
                            dest = pathFile.getParentFile();
                        }
                        if (!dest.exists()) {
                            List fileListeners = customActions[customActions.length - 1];
                            if (fileListeners != null && fileListeners.size() > 0) {
                                this.mkDirsWithEnhancement(dest, pf, customActions);
                            } else if (!dest.mkdirs()) {
                                this.handler.emitError("Error creating directories", "Could not create directory\n" + dest.getPath());
                                this.handler.stopAction();
                                this.result = false;
                                return;
                            }
                        }
                        this.udata.addFile(path, pack.uninstall);
                        if (pf.isDirectory()) continue;
                        this.informListeners(customActions, 1, pathFile, pf, null);
                        this.handler.progress(j, path);
                        if (pathFile.exists() && pf.override() != 1) {
                            boolean overwritefile = false;
                            if (pf.override() != 0) {
                                if (pf.override() == 1) {
                                    overwritefile = true;
                                } else if (pf.override() == 4) {
                                    overwritefile = pathFile.lastModified() < pf.lastModified();
                                } else {
                                    int answer;
                                    int def_choice = -1;
                                    if (pf.override() == 2) {
                                        def_choice = 49;
                                    }
                                    if (pf.override() == 3) {
                                        def_choice = 47;
                                    }
                                    boolean bl = overwritefile = (answer = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + " - " + pathFile.getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + pathFile.getAbsolutePath(), 37, def_choice)) == 47;
                                }
                            }
                            if (!overwritefile) {
                                if (pf.isBackReference() || packs.get((int)i).loose) continue;
                                continue;
                            }
                        }
                        out = new FileOutputStream(pathFile);
                        byte[] buffer = new byte[5120];
                        long bytesCopied = 0L;
                        InputStream pis = fin;
                        if (packs.get((int)i).loose) {
                            pis = new FileInputStream(pf.sourcePath);
                        }
                        long fileposition = pf.getArchivefileposition();
                        while (fin.getFilepointer() < fileposition) {
                            File nextmedia;
                            Debug.trace("Skipping bytes to get to file " + pathFile.getName() + " (" + fin.getFilepointer() + "<" + fileposition + ") target is: " + (fileposition - fin.getFilepointer()));
                            try {
                                fin.skip(fileposition - fin.getFilepointer());
                                break;
                            }
                            catch (VolumeNotFoundException vnfe) {
                                nextmedia = this.helper.enterNextMediaMessage(vnfe.getVolumename());
                                fin.setVolumename(nextmedia.getAbsolutePath());
                            }
                            catch (CorruptVolumeException cve) {
                                Debug.trace("corrupt media found. magic number is not correct");
                                nextmedia = this.helper.enterNextMediaMessage(cve.getVolumename(), true);
                                fin.setVolumename(nextmedia.getAbsolutePath());
                            }
                        }
                        if (fin.getFilepointer() > fileposition) {
                            Debug.trace("Error, can't access file in pack.");
                        }
                        while (bytesCopied < pf.length()) {
                            block71: {
                                if (!this.performInterrupted()) break block71;
                                out.close();
                                if (pis != objIn) {
                                    pis.close();
                                }
                                return;
                            }
                            try {
                                int maxBytes = (int)Math.min(pf.length() - bytesCopied, (long)buffer.length);
                                int bytesInBuffer = pis.read(buffer, 0, maxBytes);
                                if (bytesInBuffer == -1) {
                                    Debug.trace("Unexpected end of stream (installer corrupted?)");
                                    throw new IOException("Unexpected end of stream (installer corrupted?)");
                                }
                                out.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            catch (VolumeNotFoundException vnfe) {
                                File nextmedia = this.helper.enterNextMediaMessage(vnfe.getVolumename());
                                fin.setVolumename(nextmedia.getAbsolutePath());
                            }
                            catch (CorruptVolumeException cve) {
                                Debug.trace("corrupt media found. magic number is not correct");
                                File nextmedia = this.helper.enterNextMediaMessage(cve.getVolumename(), true);
                                fin.setVolumename(nextmedia.getAbsolutePath());
                            }
                        }
                        out.close();
                        if (pf.lastModified() >= 0L) {
                            pathFile.setLastModified(pf.lastModified());
                        }
                        this.informListeners(customActions, 2, pathFile, pf, null);
                        continue;
                    }
                    if (pf.isBackReference()) continue;
                }
                int numParsables = objIn.readInt();
                Debug.trace("Looking for parsables");
                for (int k = 0; k < numParsables; ++k) {
                    ParsableFile pf = null;
                    while (true) {
                        File nextmedia;
                        try {
                            pf = (ParsableFile)objIn.readObject();
                        }
                        catch (VolumeNotFoundException vnfe) {
                            nextmedia = this.helper.enterNextMediaMessage(vnfe.getVolumename());
                            fin.setVolumename(nextmedia.getAbsolutePath());
                            continue;
                        }
                        catch (CorruptVolumeException cve) {
                            Debug.trace("corrupt media found. magic number is not correct");
                            nextmedia = this.helper.enterNextMediaMessage(cve.getVolumename(), true);
                            fin.setVolumename(nextmedia.getAbsolutePath());
                            continue;
                        }
                        catch (EOFException eofe) {
                            nextmedia = this.helper.enterNextMediaMessage("");
                            fin.setVolumename(nextmedia.getAbsolutePath());
                            continue;
                        }
                        break;
                    }
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) continue;
                    pf.path = IoHelper.translatePath(pf.path, this.vs);
                    Debug.trace("Found parsable: " + pf.path);
                    parsables.add(pf);
                }
                int numExecutables = objIn.readInt();
                Debug.trace("Looking for executables...");
                for (int k = 0; k < numExecutables; ++k) {
                    ExecutableFile ef = (ExecutableFile)objIn.readObject();
                    if (ef.hasCondition() && this.rules != null && !this.rules.isConditionTrue(ef.getCondition())) continue;
                    ef.path = IoHelper.translatePath(ef.path, this.vs);
                    if (null != ef.argList && !ef.argList.isEmpty()) {
                        String arg = null;
                        for (int j = 0; j < ef.argList.size(); ++j) {
                            arg = ef.argList.get(j);
                            arg = IoHelper.translatePath(arg, this.vs);
                            ef.argList.set(j, arg);
                        }
                    }
                    Debug.trace("Found executable: " + ef.path);
                    executables.add(ef);
                    if (ef.executionStage != 2) continue;
                    this.udata.addExecutable(ef);
                }
                this.handleAdditionalUninstallData(this.udata, customActions);
                int numUpdateChecks = objIn.readInt();
                Debug.trace("Looking for updatechecks");
                for (int k = 0; k < numUpdateChecks; ++k) {
                    UpdateCheck uc = (UpdateCheck)objIn.readObject();
                    Debug.trace("found updatecheck");
                    updatechecks.add(uc);
                }
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(customActions, 6, packs.get(i), i, this.handler);
            }
            Debug.trace("Trying to parse files");
            ScriptParser parser = new ScriptParser(parsables, this.vs);
            parser.parseFiles();
            Debug.trace("parsed files");
            if (this.performInterrupted()) {
                return;
            }
            Debug.trace("Trying to execute files");
            FileExecutor executor = new FileExecutor(executables);
            if (executor.executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
                this.result = false;
                Debug.trace("File execution failed");
            }
            if (this.performInterrupted()) {
                return;
            }
            Debug.trace("Create uninstaller");
            this.putUninstaller();
            Debug.trace("Uninstaller created");
            Debug.trace("Perform updateChecks");
            this.performUpdateChecks(updatechecks);
            Debug.trace("updatechecks performed.");
            if (this.performInterrupted()) {
                return;
            }
            this.informListeners(customActions, 8, this.idata, this.handler, null);
            if (this.performInterrupted()) {
                return;
            }
            this.writeInstallationInformation();
            this.writeConfigInformation();
            this.handler.stopAction();
            Debug.trace("Installation complete");
        }
        catch (Exception err) {
            this.handler.stopAction();
            String message = err.getMessage();
            if ("Installation cancelled".equals(message)) {
                this.handler.emitNotification("Installation cancelled");
            } else {
                if (message == null || "".equals(message)) {
                    message = "Internal error occured : " + err.toString();
                }
                this.handler.emitError("An error occured", message);
                err.printStackTrace();
            }
            this.result = false;
        }
        finally {
            this.removeFromInstances();
        }
    }

    protected void writeConfigInformation() {
        Properties installerproperties = this.idata.getVariables();
        Enumeration<Object> installerpropertieskeys = installerproperties.keys();
        try {
            String installpath = this.idata.getVariable("INSTALL_PATH");
            PrintWriter pw = new PrintWriter(new FileOutputStream(installpath + File.separator + "installer.properties"));
            pw.println("# Installer properties, written by MultiVolumeUnpacker.");
            while (installerpropertieskeys.hasMoreElements()) {
                String key = (String)installerpropertieskeys.nextElement();
                if (key.startsWith("SYSTEM_") || key.startsWith("password_")) continue;
                pw.println(key + "=" + installerproperties.getProperty(key));
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            Debug.trace("Error while writing config information in MultiVolumeUnpacker: " + e.getMessage());
        }
    }
}

