/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.VariableSubstitutor;

public abstract class PanelConsoleHelper {
    private static final String CONSOLE_ASK = "console.ask";

    public void makeXMLData(IXMLElement panelRoot, AutomatedInstallData idata) {
    }

    public String getSummaryBody(AutomatedInstallData idata) {
        return null;
    }

    public String getInstanceNumber() {
        return null;
    }

    public String getSummaryCaption(AutomatedInstallData idata) {
        String curClassname = this.getClass().getName();
        String caption = curClassname.equals("com.izforge.izpack.panels.UserInputPanelConsoleHelper") ? this.getI18nStringForClass("summaryCaption." + this.getInstanceNumber(), curClassname.replaceAll("ConsoleHelper", ""), idata) : this.getI18nStringForClass("summaryCaption", curClassname.replaceAll("ConsoleHelper", ""), idata);
        return caption;
    }

    private String getI18nStringForClass(String curClassName, String subkey, String alternateClass, AutomatedInstallData idata) {
        int nameStart = curClassName.lastIndexOf(46) + 1;
        curClassName = curClassName.substring(nameStart, curClassName.length());
        StringBuffer buf = new StringBuffer();
        buf.append(curClassName).append(".").append(subkey);
        String fullkey = buf.toString();
        String retval = null;
        if (retval == null || retval.startsWith(fullkey)) {
            retval = idata.langpack.getString(fullkey);
        }
        if (retval == null || retval.startsWith(fullkey)) {
            if (alternateClass == null) {
                return null;
            }
            buf.delete(0, buf.length());
            buf.append(alternateClass).append(".").append(subkey);
            retval = idata.langpack.getString(buf.toString());
        }
        if (retval != null && retval.indexOf(36) > -1) {
            VariableSubstitutor substitutor = new VariableSubstitutor(idata.getVariables());
            retval = substitutor.substitute(retval, null);
        }
        return retval;
    }

    public String getI18nStringForClass(String subkey, String alternateClass, AutomatedInstallData idata) {
        return this.getI18nStringForClass(this.getClass().getName().replaceAll("ConsoleHelper", ""), subkey, alternateClass, idata);
    }

    public String getI18nStringForClass(String subkey) {
        String retval = null;
        Class<?> clazz = this.getClass();
        while (retval == null && !clazz.getName().endsWith(".IzPanel")) {
            retval = this.getI18nStringForClass(clazz.getName(), subkey, null);
            clazz = clazz.getSuperclass();
        }
        return retval;
    }

    public static int askEndOfConsolePanel(AutomatedInstallData idata, String msg) {
        try {
            String strIn;
            do {
                System.out.println(msg);
                strIn = AeshReadlineConsole.readLine();
                System.out.println("");
                if (strIn.equals("1")) {
                    return 1;
                }
                if (!strIn.equals("2")) continue;
                Housekeeper housekeeper = Housekeeper.getInstance();
                housekeeper.runCleanup();
                housekeeper.wipeFiles();
                return 2;
            } while (!strIn.equals("3"));
            return 3;
        }
        catch (Exception ie) {
            ie.printStackTrace();
            return 2;
        }
    }

    public static int askEndOfConsolePanel(AutomatedInstallData idata) {
        String consoleAsk = idata.langpack.getString(CONSOLE_ASK);
        return PanelConsoleHelper.askEndOfConsolePanel(idata, consoleAsk);
    }

    public static int askYesNo(String question, boolean defaultanswer) {
        try {
            String rline;
            do {
                System.out.println(question + " (y/n) [" + (defaultanswer ? "y" : "n") + "]:");
                rline = AeshReadlineConsole.readLine();
                if (rline.equals("y") || rline.equals("yes")) {
                    return 47;
                }
                if (!rline.equals("n") && !rline.equals("no")) continue;
                return 49;
            } while (!rline.isEmpty());
            return defaultanswer ? 47 : 49;
        }
        catch (Exception exception) {
            return 49;
        }
    }
}

