/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import java.io.InputStream;

public class PrintHelp {
    private LocaleDatabase langpack;
    private static String DEFAULT_LANG = "eng";

    public PrintHelp() {
        this(DEFAULT_LANG);
    }

    public PrintHelp(String langcode) {
        try {
            InputStream izpackLangPack = this.getClass().getResourceAsStream("/langpacks/" + langcode + ".xml");
            this.langpack = new LocaleDatabase(izpackLangPack);
            InputStream customLangPack = this.getClass().getResourceAsStream("/res/CustomLangpack.xml_" + langcode);
            this.langpack.add(customLangPack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printHelp() {
        this.printToConsole(this.langpack.getString("installer.usage"));
        String append = this.langpack.getString("installer.usage.append");
        if (!append.equals("installer.usage.append")) {
            System.out.println();
            this.printToConsole(append);
        }
    }

    private void printToConsole(String toConsole) {
        String[] lines;
        for (String line : lines = toConsole.split("\\\\n")) {
            System.out.println(line);
        }
    }
}

