/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.installer.WebRepositoryAccessor;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class Unpacker
extends UnpackerBase {
    private static final String tempSubPath = "/IzpackWebTemp";

    public Unpacker(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        super(idata, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addToInstances();
        try {
            FileOutputStream out = null;
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updatechecks = new ArrayList<UpdateCheck>();
            List<Pack> packs = this.idata.selectedPacks;
            int npacks = packs.size();
            this.handler.startAction("Unpacking", npacks);
            this.udata = UninstallData.getInstance();
            List[] customActions = this.getCustomActions();
            this.informListeners(customActions, 7, this.idata, npacks, this.handler);
            packs = this.idata.selectedPacks;
            npacks = packs.size();
            for (int i = 0; i < npacks; ++i) {
                String name;
                Pack p = packs.get(i);
                if (p.hasCondition() && this.rules != null && !this.rules.isConditionTrue(p.getCondition())) continue;
                this.informListeners(customActions, 5, packs.get(i), npacks, this.handler);
                ObjectInputStream objIn = new ObjectInputStream(this.getPackAsStream(p.id, p.uninstall));
                int nfiles = objIn.readInt();
                int fileCount = p.getFileCount();
                Pack pack = packs.get(i);
                String stepname = this.idata.langpack.getString(pack.id);
                if (stepname == null || stepname == "") {
                    stepname = pack.name;
                }
                if (this.langpack != null && pack.id != null && !"".equals(pack.id) && (name = this.langpack.getString(pack.id)) != null && !"".equals(name)) {
                    stepname = name;
                }
                this.handler.nextStep(stepname, i + 1, fileCount);
                for (int j = 0; j < nfiles; ++j) {
                    PackFile pf = (PackFile)objIn.readObject();
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) {
                        if (pf.isBackReference()) continue;
                        objIn.skip(pf.length());
                        continue;
                    }
                    if (OsConstraint.oneMatchesCurrentSystem(pf.osConstraints())) {
                        int bytesInBuffer;
                        File pathFile;
                        String path = IoHelper.translatePath(pf.getTargetPath(), this.vs);
                        File dest = pathFile = new File(path);
                        if (!pf.isDirectory()) {
                            dest = pathFile.getParentFile();
                        }
                        if (!dest.exists()) {
                            List fileListeners = customActions[customActions.length - 1];
                            if (fileListeners != null && fileListeners.size() > 0) {
                                this.mkDirsWithEnhancement(dest, pf, customActions);
                            } else {
                                File currentNode = dest;
                                while (!currentNode.exists()) {
                                    this.udata.getInstalledFilesList().add(currentNode.getPath());
                                    currentNode = currentNode.getParentFile();
                                }
                                if (!dest.mkdirs()) {
                                    this.handler.emitError("Error creating directories", "Could not create directory\n" + dest.getPath());
                                    this.result = false;
                                    return;
                                }
                            }
                        }
                        this.udata.addFile(path, pack.uninstall);
                        if (pf.isDirectory()) {
                            if (pf.getPermissions() == null || !FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) continue;
                            Files.setPosixFilePermissions(Paths.get(path, new String[0]), pf.getPermissions());
                            continue;
                        }
                        this.informListeners(customActions, 1, pathFile, pf, null);
                        this.handler.progress(j, path);
                        if (pathFile.exists() && pf.override() != 1) {
                            boolean overwritefile = false;
                            if (pf.override() != 0) {
                                if (pf.override() == 1) {
                                    overwritefile = true;
                                } else if (pf.override() == 4) {
                                    overwritefile = pathFile.lastModified() < pf.lastModified();
                                } else {
                                    int answer;
                                    int def_choice = -1;
                                    if (pf.override() == 2) {
                                        def_choice = 49;
                                    }
                                    if (pf.override() == 3) {
                                        def_choice = 47;
                                    }
                                    boolean bl = overwritefile = (answer = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + " - " + pathFile.getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + pathFile.getAbsolutePath(), 37, def_choice)) == 47;
                                }
                            }
                            if (!overwritefile) {
                                if (pf.isBackReference() || packs.get((int)i).loose) continue;
                                if (pf.isPack200Jar()) {
                                    objIn.skip(4L);
                                    continue;
                                }
                                objIn.skip(pf.length());
                                continue;
                            }
                        }
                        InputStream pis = objIn;
                        if (pf.isBackReference()) {
                            InputStream is = this.getPackAsStream(pf.previousPackId, pack.uninstall);
                            pis = new ObjectInputStream(is);
                            is.skip(pf.offsetInPreviousPack - 4L);
                        } else if (packs.get((int)i).loose) {
                            File resolvedFile = new File(this.getAbsolutInstallSource(), pf.getRelativeSourcePath());
                            if (!resolvedFile.exists()) {
                                File userDir = new File(System.getProperty("user.dir"));
                                resolvedFile = new File(userDir, pf.getRelativeSourcePath());
                            }
                            if (resolvedFile.exists()) {
                                pis = new FileInputStream(resolvedFile);
                                pf = new PackFile(resolvedFile.getParentFile(), resolvedFile, pf.getTargetPath(), pf.osConstraints(), pf.override(), pf.getAdditionals());
                            } else {
                                System.out.println("Could not find loosely bundled file: " + pf.getRelativeSourcePath());
                                if (this.handler.emitWarning("File not found", "Could not find loosely bundled file: " + pf.getRelativeSourcePath())) continue;
                                throw new InstallerException("Installation cancelled");
                            }
                        }
                        out = new FileOutputStream(pathFile);
                        byte[] buffer = new byte[5120];
                        for (long bytesCopied = 0L; bytesCopied < pf.length(); bytesCopied += (long)bytesInBuffer) {
                            if (this.performInterrupted()) {
                                out.close();
                                if (pis != objIn) {
                                    pis.close();
                                }
                                return;
                            }
                            int maxBytes = (int)Math.min(pf.length() - bytesCopied, (long)buffer.length);
                            bytesInBuffer = pis.read(buffer, 0, maxBytes);
                            if (bytesInBuffer == -1) {
                                throw new IOException("Unexpected end of stream (installer corrupted?)");
                            }
                            out.write(buffer, 0, bytesInBuffer);
                        }
                        out.close();
                        if (pis != objIn) {
                            pis.close();
                        }
                        if (pf.lastModified() >= 0L) {
                            pathFile.setLastModified(pf.lastModified());
                        }
                        if (pf.getPermissions() != null && FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                            Files.setPosixFilePermissions(Paths.get(path, new String[0]), pf.getPermissions());
                        }
                        this.informListeners(customActions, 2, pathFile, pf, null);
                        continue;
                    }
                    if (pf.isBackReference()) continue;
                    objIn.skip(pf.length());
                }
                int numParsables = objIn.readInt();
                for (int k = 0; k < numParsables; ++k) {
                    ParsableFile pf = (ParsableFile)objIn.readObject();
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) continue;
                    pf.path = IoHelper.translatePath(pf.path, this.vs);
                    parsables.add(pf);
                }
                int numExecutables = objIn.readInt();
                for (int k = 0; k < numExecutables; ++k) {
                    ExecutableFile ef = (ExecutableFile)objIn.readObject();
                    if (ef.hasCondition() && this.rules != null && !this.rules.isConditionTrue(ef.getCondition())) continue;
                    ef.path = IoHelper.translatePath(ef.path, this.vs);
                    if (null != ef.argList && !ef.argList.isEmpty()) {
                        String arg = null;
                        for (int j = 0; j < ef.argList.size(); ++j) {
                            arg = ef.argList.get(j);
                            arg = IoHelper.translatePath(arg, this.vs);
                            ef.argList.set(j, arg);
                        }
                    }
                    executables.add(ef);
                    if (ef.executionStage != 2) continue;
                    this.udata.addExecutable(ef);
                }
                this.handleAdditionalUninstallData(this.udata, customActions);
                int numUpdateChecks = objIn.readInt();
                for (int k = 0; k < numUpdateChecks; ++k) {
                    UpdateCheck uc = (UpdateCheck)objIn.readObject();
                    updatechecks.add(uc);
                }
                objIn.close();
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(customActions, 6, packs.get(i), i, this.handler);
            }
            ScriptParser parser = new ScriptParser(parsables, this.vs);
            parser.parseFiles();
            if (this.performInterrupted()) {
                return;
            }
            FileExecutor executor = new FileExecutor(executables);
            if (executor.executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
                this.result = false;
            }
            if (this.performInterrupted()) {
                return;
            }
            this.putUninstaller();
            this.performUpdateChecks(updatechecks);
            if (this.performInterrupted()) {
                return;
            }
            this.informListeners(customActions, 8, this.idata, this.handler, null);
            if (this.performInterrupted()) {
                return;
            }
            this.writeInstallationInformation();
            this.handler.stopAction();
        }
        catch (Exception err) {
            this.handler.stopAction();
            String message = err.getMessage();
            if ("Installation cancelled".equals(message)) {
                this.handler.emitNotification("Installation cancelled");
            } else {
                if (message == null || "".equals(message)) {
                    message = "Internal error occured : " + err.toString();
                }
                this.handler.emitError("An error occured", message);
                err.printStackTrace();
            }
            this.result = false;
            Housekeeper.getInstance().shutDown(4);
        }
        finally {
            this.removeFromInstances();
        }
    }

    private InputStream getPackAsStream(String packid, boolean uninstall) throws Exception {
        InputStream in = null;
        String webDirURL = this.idata.info.getWebDirURL();
        packid = "-" + packid;
        if (webDirURL == null) {
            in = Unpacker.class.getResourceAsStream("/packs/pack" + packid);
        } else {
            String tempfile;
            String baseName = this.idata.info.getInstallerBase();
            String packURL = webDirURL + "/" + baseName + ".pack" + packid + ".jar";
            String tf = IoHelper.translatePath(this.idata.info.getUninstallerPath() + tempSubPath, this.vs);
            try {
                tempfile = WebRepositoryAccessor.getCachedUrl(packURL, tf);
                this.udata.addFile(tempfile, uninstall);
            }
            catch (Exception e) {
                if ("Cancelled".equals(e.getMessage())) {
                    throw new InstallerException("Installation cancelled", e);
                }
                throw new InstallerException("Installation failed", e);
            }
            URL url = new URL("jar:" + tempfile + "!/packs/pack" + packid);
            in = new WebAccessor(null).openInputStream(url);
            if (in == null) {
                throw new InstallerException(url.toString() + " not available", new FileNotFoundException(url.toString()));
            }
        }
        if (in != null && this.idata.info.getPackDecoderClassName() != null) {
            Class<?> decoder = Class.forName(this.idata.info.getPackDecoderClassName());
            Class[] paramsClasses = new Class[]{Class.forName("java.io.InputStream")};
            Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses);
            BufferedInputStream buffer = new BufferedInputStream(in);
            Object[] params = new Object[]{buffer};
            Object instance = null;
            instance = constructor.newInstance(params);
            if (!InputStream.class.isInstance(instance)) {
                throw new InstallerException("'" + this.idata.info.getPackDecoderClassName() + "' must be derived from " + InputStream.class.toString());
            }
            in = instance;
        }
        return in;
    }
}

