/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.PartialIcon;
import com.izforge.izpack.panels.TreePacksPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private static final JPanel rendererPanel = new JPanel();
    private static final JLabel packDescriptionLabel = new JLabel();
    private static final JLabel packStatusLabel = new JLabel();
    private static final JLabel packSizeLabel = new JLabel();
    private static final JCheckBox checkbox = new JCheckBox();
    private static final JCheckBox normalCheckBox = new JCheckBox();
    private static final Font normalFont = new JCheckBox().getFont();
    private static final Font boldFont = new Font(normalFont.getFontName(), 1, normalFont.getSize());
    private static final Font plainFont = new Font(normalFont.getFontName(), 0, normalFont.getSize());
    private static final Color annotationColor = new Color(0, 0, 120);
    private static final Color changedColor = new Color(200, 0, 0);
    private static Color selectionForeground;
    private static Color selectionBackground;
    private static Color textForeground;
    private static Color textBackground;
    private InstallData idata;
    TreePacksPanel treePacksPanel;
    private boolean showPackSize;

    public CheckBoxNodeRenderer(TreePacksPanel t, boolean showPackSize, InstallData idata) {
        this.idata = idata;
        this.showPackSize = showPackSize;
        selectionForeground = UIManager.getColor("Tree.selectionForeground");
        selectionBackground = UIManager.getColor("Tree.selectionBackground");
        textForeground = UIManager.getColor("Tree.textForeground");
        textBackground = UIManager.getColor("Tree.textBackground");
        this.treePacksPanel = t;
        rendererPanel.setLayout(new BorderLayout(0, 0));
        rendererPanel.setBackground(textBackground);
        rendererPanel.add("West", checkbox);
        if (showPackSize) {
            rendererPanel.setAlignmentX(0.0f);
            rendererPanel.setAlignmentY(0.0f);
            rendererPanel.add("East", packSizeLabel);
        }
        rendererPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.treePacksPanel.fromModel();
        rendererPanel.setPreferredSize(new Dimension(this.idata.guiPrefs.width - this.treePacksPanel.parent.getSideNavigationWidth() - 50 - 20 * (1 + ((DefaultMutableTreeNode)value).getLevel()), CheckBoxNodeRenderer.checkbox.getPreferredSize().height));
        if (selected) {
            checkbox.setForeground(selectionForeground);
            checkbox.setBackground(selectionBackground);
            rendererPanel.setForeground(selectionForeground);
            rendererPanel.setBackground(selectionBackground);
            packDescriptionLabel.setBackground(selectionBackground);
            packStatusLabel.setBackground(selectionBackground);
            packSizeLabel.setBackground(selectionBackground);
        } else {
            checkbox.setForeground(textForeground);
            checkbox.setBackground(textBackground);
            rendererPanel.setForeground(textForeground);
            rendererPanel.setBackground(textBackground);
            packDescriptionLabel.setBackground(textBackground);
            packStatusLabel.setBackground(textBackground);
            packSizeLabel.setBackground(textBackground);
        }
        if (value != null && value instanceof CheckBoxNode) {
            CheckBoxNode node = (CheckBoxNode)value;
            if (node.isTotalSizeChanged()) {
                packSizeLabel.setForeground(changedColor);
            } else if (selected) {
                packDescriptionLabel.setForeground(selectionForeground);
                packStatusLabel.setForeground(selectionForeground);
                packSizeLabel.setForeground(selectionForeground);
            } else {
                packDescriptionLabel.setForeground(annotationColor);
                packStatusLabel.setForeground(annotationColor);
                packSizeLabel.setForeground(annotationColor);
            }
            checkbox.setText(node.getTranslatedText());
            packDescriptionLabel.setText("DESCRIPTION");
            packStatusLabel.setText("To Be Installed");
            if (this.showPackSize && node.getTotalSize() > 0L) {
                packSizeLabel.setText(Pack.toByteUnitsString(node.getTotalSize()));
            } else {
                packSizeLabel.setText("");
            }
            if (node.isPartial()) {
                checkbox.setSelected(false);
            } else {
                checkbox.setSelected(node.isSelected());
            }
            checkbox.setEnabled(node.isEnabled() && node.getPack().selectable);
            packSizeLabel.setEnabled(node.isEnabled() && node.getPack().selectable);
            if (node.getChildCount() > 0) {
                checkbox.setFont(boldFont);
                packSizeLabel.setFont(boldFont);
            } else {
                checkbox.setFont(normalFont);
                packSizeLabel.setFont(plainFont);
            }
            if (node.isPartial()) {
                checkbox.setIcon(new PartialIcon());
            } else {
                checkbox.setIcon(normalCheckBox.getIcon());
            }
        }
        return rendererPanel;
    }

    public Component getCheckRenderer() {
        return rendererPanel;
    }
}

