/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.TreePacksPanel;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class CheckTreeController
extends KeyAdapter
implements MouseListener {
    JTree tree;
    TreePacksPanel treePacksPanel;
    int checkWidth;

    public CheckTreeController(TreePacksPanel p) {
        this.checkWidth = new JCheckBox().getPreferredSize().width;
        this.tree = p.getTree();
        this.treePacksPanel = p;
    }

    private void selectNode(CheckBoxNode current) {
        current.setPartial(false);
        this.treePacksPanel.setModelValue(current);
        Enumeration<TreeNode> e = current.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)e.nextElement();
            child.setSelected(current.isSelected() || child.getPack().required);
            if (!child.isSelected()) {
                child.setPartial(false);
            }
            this.treePacksPanel.setModelValue(child);
        }
        this.treePacksPanel.fromModel();
    }

    private boolean hasExcludes(CheckBoxNode node) {
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            CheckBoxNode cbn = (CheckBoxNode)e.nextElement();
            if (cbn.getPack().excludeGroup == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
        this.treePacksPanel.setDescription(current.getId());
        this.treePacksPanel.setDependencies(current.getId());
        if (ke.getKeyCode() != 32) {
            return;
        }
        if (current.getPack().required || !current.getPack().selectable) {
            return;
        }
        boolean currIsSelected = current.isSelected() & !current.isPartial();
        boolean currIsPartial = current.isPartial();
        boolean currHasExcludes = this.hasExcludes(current);
        CheckBoxNode root = (CheckBoxNode)current.getRoot();
        if (currIsPartial && currHasExcludes) {
            current.setSelected(false);
            this.selectNode(current);
            this.updateAllParents(root);
        } else {
            if (!currIsSelected) {
                this.selectAllChildNodes(current);
            }
            current.setSelected(!currIsSelected);
            this.selectNode(current);
            this.updateAllParents(root);
        }
        CheckTreeController.initTotalSize(root, true);
        this.treePacksPanel.setBytes((int)root.getTotalSize());
        this.treePacksPanel.showSpaceRequired();
        this.tree.treeDidChange();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
        this.treePacksPanel.setDescription(current.getId());
        this.treePacksPanel.setDependencies(current.getId());
        if (me.getX() > this.tree.getPathBounds((TreePath)path).x + this.checkWidth) {
            return;
        }
        if (current.getPack().required || !current.getPack().selectable) {
            return;
        }
        boolean currIsSelected = current.isSelected() & !current.isPartial();
        boolean currIsPartial = current.isPartial();
        boolean currHasExcludes = this.hasExcludes(current);
        CheckBoxNode root = (CheckBoxNode)current.getRoot();
        if (currIsPartial && currHasExcludes) {
            current.setSelected(false);
            this.selectNode(current);
            this.updateAllParents(root);
        } else {
            if (!currIsSelected) {
                this.selectAllChildNodes(current);
            }
            current.setSelected(!currIsSelected);
            this.selectNode(current);
            this.updateAllParents(root);
        }
        CheckTreeController.initTotalSize(root, true);
        this.treePacksPanel.setBytes((int)root.getTotalSize());
        this.treePacksPanel.showSpaceRequired();
        this.tree.treeDidChange();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void selectAllChildNodes(CheckBoxNode cbn) {
        Enumeration<TreeNode> e = cbn.children();
        while (e.hasMoreElements()) {
            CheckBoxNode subCbn = (CheckBoxNode)e.nextElement();
            this.selectAllDependencies(subCbn);
            if (subCbn.getChildCount() > 0) {
                this.selectAllChildNodes(subCbn);
            }
            subCbn.setSelected(true);
            subCbn.setEnabled(true);
            this.treePacksPanel.setModelValue(subCbn);
            subCbn.setEnabled(!subCbn.getPack().required);
        }
    }

    public void selectAllDependencies(CheckBoxNode cbn) {
        Pack pack = cbn.getPack();
        List<String> deps = pack.getDependencies();
        if (deps == null) {
            return;
        }
        for (String depId : deps) {
            CheckBoxNode depCbn = this.treePacksPanel.getCbnById(depId);
            this.selectAllDependencies(depCbn);
            if (depCbn.getChildCount() > 0 && (!depCbn.isSelected() || depCbn.isPartial())) {
                this.selectAllChildNodes(depCbn);
            }
            depCbn.setSelected(true);
            depCbn.setEnabled(true);
            this.treePacksPanel.setModelValue(depCbn);
            depCbn.setEnabled(!depCbn.getPack().required);
        }
    }

    public void updateAllParents(CheckBoxNode root) {
        Enumeration<TreeNode> rootEnum = root.depthFirstEnumeration();
        while (rootEnum.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)rootEnum.nextElement();
            if (child.getParent() == null || child.getParent().equals(root)) continue;
            this.updateParents(child);
        }
    }

    private void updateParents(CheckBoxNode node) {
        CheckBoxNode parent = (CheckBoxNode)node.getParent();
        if (parent != null && !parent.equals(parent.getRoot())) {
            Enumeration<TreeNode> ne = parent.children();
            boolean allSelected = true;
            boolean allDeselected = true;
            while (ne.hasMoreElements()) {
                CheckBoxNode child = (CheckBoxNode)ne.nextElement();
                if (child.isSelected()) {
                    allDeselected = false;
                } else {
                    allSelected = false;
                }
                if (child.isPartial()) {
                    allDeselected = false;
                    allSelected = false;
                }
                if (allSelected || allDeselected) continue;
                break;
            }
            if (parent.getChildCount() > 0) {
                if (!allSelected && !allDeselected) {
                    CheckTreeController.setPartialParent(parent);
                } else {
                    parent.setPartial(false);
                }
                if (allSelected) {
                    parent.setSelected(true);
                }
                if (allDeselected) {
                    parent.setSelected(false);
                }
                this.treePacksPanel.setModelValue(parent);
                if (allSelected || allDeselected) {
                    this.updateParents(parent);
                }
            }
        }
    }

    public static void setPartialParent(CheckBoxNode node) {
        node.setPartial(true);
        CheckBoxNode parent = (CheckBoxNode)node.getParent();
        if (parent != null && !parent.equals(parent.getRoot())) {
            CheckTreeController.setPartialParent(parent);
        }
    }

    public static long initTotalSize(CheckBoxNode node, boolean markChanged) {
        if (node.isLeaf()) {
            return node.getPack().getSize();
        }
        Enumeration<TreeNode> e = node.children();
        Pack nodePack = node.getPack();
        long bytes = 0L;
        if (nodePack != null && node.isSelected()) {
            bytes = nodePack.getSize();
        }
        while (e.hasMoreElements()) {
            CheckBoxNode c = (CheckBoxNode)e.nextElement();
            long size = CheckTreeController.initTotalSize(c, markChanged);
            if (!c.isSelected() && !c.isPartial()) continue;
            bytes += size;
        }
        if (node.getOriginalSize() != bytes) {
            node.setTotalSizeChanged(true);
        } else {
            node.setTotalSizeChanged(false);
        }
        node.setTotalSize(bytes);
        return bytes;
    }

    public static long setOriginalSize(CheckBoxNode node) {
        long bytes = 0L;
        if (node.isLeaf()) {
            bytes = node.getPack().getSize();
            node.setOriginalSize(bytes);
            return bytes;
        }
        Enumeration<TreeNode> e = node.children();
        Pack nodePack = node.getPack();
        if (nodePack != null) {
            bytes = nodePack.getSize();
        }
        while (e.hasMoreElements()) {
            long size = CheckTreeController.setOriginalSize((CheckBoxNode)e.nextElement());
            bytes += size;
        }
        node.setOriginalSize(bytes);
        return bytes;
    }
}

