/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.FileInputField;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;

public class DirInputField
extends FileInputField {
    private static final long serialVersionUID = 8494549823214831160L;
    private final boolean mustExist;
    private final boolean canCreate;

    public DirInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, boolean mustExist, boolean canCreate) {
        super(parent, data, directory, set, size, validatorConfig, null, null, mustExist);
        this.mustExist = mustExist;
        this.canCreate = canCreate || !mustExist;
    }

    @Override
    protected void prepareFileChooser(JFileChooser filechooser) {
        filechooser.setFileSelectionMode(1);
    }

    @Override
    protected boolean _validate(File dir) {
        this.userCancelled = false;
        boolean dirExists = dir.isDirectory();
        if (!dirExists) {
            if (this.mustExist) {
                return false;
            }
            if (!this.canCreate || !this.verifyCreateOK(dir)) {
                return false;
            }
        } else if (!DirInputField.isWriteable(dir)) {
            return false;
        }
        return true;
    }

    @Override
    protected void showMessage(int k) {
        if (k == 0) {
            this.showMessage("dir.notdirectory");
        } else if (k == 1) {
            this.showMessage("dir.nodirectory");
        }
    }

    private boolean verifyCreateOK(File path) {
        if (!path.exists() && !this.parent.emitNotificationFeedback(this.parent.getI18nStringForClass("createdir", "TargetPanel") + "\n" + path.getAbsolutePath())) {
            this.userCancelled = true;
            return false;
        }
        if (!DirInputField.isWriteable(path)) {
            this.parent.emitError(this.parentFrame.langpack.getString("installer.error"), this.parent.getI18nStringForClass("notwritable", "TargetPanel"));
            return false;
        }
        return true;
    }

    private static boolean isWriteable(File path) {
        File existParent = IoHelper.existingParent(path);
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }
}

