/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.FileInputField;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;

public class DirUrlInputField
extends FileInputField {
    private final String[] supportedProtocols = new String[]{"http", "https", "ftp", "file"};

    public DirUrlInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, String fileExt, String fileExtDesc, boolean mustExist) {
        super(parent, data, directory, set, size, validatorConfig, fileExt, fileExtDesc, mustExist);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.browseBtn) {
            String initialPath = this.data.getVariable("USER_HOME");
            if (this.filetxt.getText() != null && !this.isSupportedProtocol(this.filetxt.getText())) {
                initialPath = this.filetxt.getText();
            }
            JFileChooser fileChooser = new JFileChooser(initialPath);
            this.prepareFileChooser(fileChooser);
            if (fileChooser.showOpenDialog(this.parentFrame) == 0) {
                String selectedPath = fileChooser.getSelectedFile().getAbsolutePath();
                this.filetxt.setText(selectedPath);
                Debug.trace("Setting dir url input field directory to: " + selectedPath);
            }
        }
    }

    public String getSelectedValue() {
        String text = this.filetxt.getText();
        if (this.isSupportedProtocol(text)) {
            return text;
        }
        File result = new File(text);
        return result.getAbsolutePath();
    }

    private boolean isSupportedProtocol(String text) {
        for (String protocol : this.supportedProtocols) {
            if (!text.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void prepareFileChooser(JFileChooser fileChooser) {
        super.prepareFileChooser(fileChooser);
        fileChooser.setFileSelectionMode(1);
    }

    @Override
    public boolean validateField() {
        String input = this.filetxt.getText();
        boolean result = this.allowEmpty && input == null || input.isEmpty() ? true : (this.isSupportedProtocol(input) ? super.runValidators(input) : super.validateField());
        ButtonFactory.clearButtonMnemonics();
        return result;
    }
}

