/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import java.util.ArrayList;
import java.util.Map;

public class DynamicPackSelector {
    private static final int ON_SELECT = 0;
    private static final int ON_DESELECT = 1;
    int[] checkValues;
    ArrayList<Pack> packs;
    Map<String, Integer> idPos;

    public DynamicPackSelector(int[] checkValues, ArrayList<Pack> packs, Map<String, Integer> idPos) {
        this.checkValues = checkValues;
        this.packs = packs;
        this.idPos = idPos;
    }

    public void onSelectionUpdate(int currentPack) {
        String[] packSetList;
        int value = this.checkValues[currentPack];
        Pack pack = this.packs.get(currentPack);
        String[] stringArray = packSetList = value <= 0 ? pack.onDeselect : pack.onSelect;
        if (packSetList != null) {
            for (String set : packSetList) {
                String[] packs = this.splitCondPacks(set);
                if (!this.noPackMeetsCondition(packs, currentPack)) continue;
                this.updatePackPredicate(packs[0]);
            }
        }
    }

    private void updatePack(String pack) {
        int pos = this.getPosFromId(this.packId(pack));
        if (pos < 0) {
            return;
        }
        this.checkValues[pos] = this.isDeselect(pack) ? 0 : 1;
    }

    private void updatePackPredicate(String packstring) {
        if (packstring.contains(">")) {
            String[] imp = packstring.split(">");
            if (this.packSelectionCondition(imp[0])) {
                this.updatePack(imp[1]);
            }
        } else {
            this.updatePack(packstring);
        }
    }

    private boolean packSelectionCondition(String packstring) {
        if (packstring.contains(">")) {
            String[] imp = packstring.split(">");
            return !this.packConditionIsTrue(imp[0]) || this.packConditionIsTrue(imp[1]);
        }
        return this.packConditionIsTrue(packstring);
    }

    private boolean packConditionIsTrue(String packstring) {
        return !this.isDeselect(packstring) && this.packIsSelected(this.packId(packstring)) || this.isDeselect(packstring) && !this.packIsSelected(this.packId(packstring));
    }

    private boolean isDeselect(String packstring) {
        return packstring.startsWith("!");
    }

    private String packId(String packstring) {
        return this.isDeselect(packstring) ? packstring.substring(1) : packstring;
    }

    private String[] splitCondPacks(String condition) {
        return condition.split("\\|");
    }

    private boolean noPackMeetsCondition(String[] condpacks, int current) {
        for (String p : condpacks) {
            if (!this.packSelectionCondition(p)) continue;
            return false;
        }
        return true;
    }

    private boolean packIsSelected(String packname) {
        int pos = this.getPosFromId(packname);
        return pos >= 0 ? this.checkValues[pos] >= 1 : false;
    }

    private int getPosFromId(String id) {
        int pos;
        try {
            pos = this.idPos.get(id);
        }
        catch (NullPointerException e) {
            pos = -1;
        }
        return pos;
    }
}

