/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.patternfly.PatternflyProgressBarUI;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.JTextMessagePane;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileDownloader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FileDownloadManager
extends IzPanel {
    private JProgressBar progressBar;
    private FileDownloader fd;
    private boolean result = false;
    private JPanel downloadDialogPanel;
    private String outputPath;
    private String url;
    private String associatedVariable;

    public FileDownloadManager(String associatedVariable, String url, InstallData data, InstallerFrame parent) {
        super(parent, data);
        this.associatedVariable = associatedVariable;
        this.url = url;
        this.fd = new FileDownloader(new DownloadHandler(), url);
        this.buildUI();
    }

    public void startDownload() {
        this.fd.start();
    }

    public void stopDownload() {
        this.fd.stopDownload();
    }

    private void buildUI() {
        this.downloadDialogPanel = new JPanel();
        this.downloadDialogPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridy = 0;
        c.weighty = 1.0;
        this.outputPath = this.fd.getPath();
        JTextMessagePane statusMsg = new JTextMessagePane(String.format(this.idata.langpack.getString("filedownloader.downloading"), this.url), this.maxMessageWidth, this.fontMetrics);
        this.downloadDialogPanel.add((Component)statusMsg, c);
        c.gridy = 1;
        c.fill = 2;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(false);
        this.progressBar.setUI(new PatternflyProgressBarUI());
        this.progressBar.setFocusable(false);
        this.downloadDialogPanel.add((Component)this.progressBar, c);
    }

    public void hideDownloadDialog() {
        Window ancestor;
        if (this.downloadDialogPanel != null && (ancestor = SwingUtilities.getWindowAncestor(this.downloadDialogPanel)) != null) {
            ancestor.setVisible(false);
        }
    }

    public boolean getResult() {
        return this.result;
    }

    public String getFilePath() {
        return this.outputPath;
    }

    public FileDownloader getFileDownloaderThread() {
        return this.fd;
    }

    public String getAssociatedVariable() {
        return this.associatedVariable;
    }

    public JPanel getDownloadDisplayPanel() {
        return this.downloadDialogPanel;
    }

    private class DownloadHandler
    implements AbstractUIProgressHandler {
        private DownloadHandler() {
        }

        @Override
        public void emitNotification(String message) {
        }

        @Override
        public boolean emitWarning(String title, String message) {
            return true;
        }

        @Override
        public void emitError(String title, String message) {
            FileDownloadManager.this.hideDownloadDialog();
            FileDownloadManager.this.emitError(title, message);
        }

        @Override
        public void emitErrorAndBlockNext(String title, String message) {
        }

        @Override
        public int askQuestion(String title, String question, int choices) {
            return 0;
        }

        @Override
        public int askQuestion(String title, String question, int choices, int default_choice) {
            return 0;
        }

        @Override
        public void startAction(String name, final int max) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileDownloadManager.this.progressBar.setVisible(true);
                    FileDownloadManager.this.progressBar.setMinimum(0);
                    FileDownloadManager.this.progressBar.setMaximum(max);
                    FileDownloadManager.this.parent.lockNextButton();
                }
            });
        }

        @Override
        public void stopAction() {
        }

        @Override
        public void nextStep(String step_name, int step_no, int no_of_substeps) {
        }

        @Override
        public void setSubStepNo(int no_of_substeps) {
        }

        @Override
        public void progress(final int pos, String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileDownloadManager.this.progressBar.setValue(pos);
                }
            });
        }
    }
}

