/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.FileDownloader;
import java.util.Arrays;

public class FileDownloadManagerConsoleHelper {
    private String url;
    private FileDownloader fd;
    private String outputPath;
    private String cancelTip;
    private String spaces;
    private boolean result;
    private AutomatedInstallData data;

    public FileDownloadManagerConsoleHelper(String url) {
        this.fd = new FileDownloader(new DownloadHandlerConsole(), url);
        this.data = AutomatedInstallData.getInstance();
        this.url = url;
        this.cancelTip = " [" + this.data.langpack.getString("filedownloader.download.cancel") + "]";
        char[] chars = new char[this.cancelTip.length()];
        Arrays.fill(chars, ' ');
        this.spaces = new String(chars);
        if (this.fd.getResult()) {
            this.fd.start();
            this.initializePanel();
        }
    }

    public boolean getResult() {
        return this.result;
    }

    public String getDownloadPath() {
        return this.outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePanel() {
        this.outputPath = this.fd.getPath();
        System.out.println(String.format(this.data.langpack.getString("filedownloader.downloading"), this.url, this.outputPath));
        Thread getInputThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (FileDownloadManagerConsoleHelper.this.fd.isDownloading()) {
                    try {
                        String input = AeshReadlineConsole.readLineInterruptable();
                        if (!input.equalsIgnoreCase("c")) continue;
                        System.out.println();
                        FileDownloadManagerConsoleHelper.this.fd.stopDownload();
                        return;
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
        });
        getInputThread.start();
        FileDownloader fileDownloader = this.fd;
        synchronized (fileDownloader) {
            try {
                while (this.fd.isDownloading()) {
                    this.fd.wait();
                }
                getInputThread.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class DownloadHandlerConsole
    implements AbstractUIProgressHandler {
        int prevStep;

        private DownloadHandlerConsole() {
        }

        @Override
        public void emitNotification(String message) {
        }

        @Override
        public boolean emitWarning(String title, String message) {
            return false;
        }

        @Override
        public void emitError(String title, String message) {
            System.out.println(message);
        }

        @Override
        public void emitErrorAndBlockNext(String title, String message) {
        }

        @Override
        public int askQuestion(String title, String question, int choices) {
            return 0;
        }

        @Override
        public int askQuestion(String title, String question, int choices, int default_choice) {
            return 0;
        }

        @Override
        public void startAction(String name, int no_of_steps) {
        }

        @Override
        public void stopAction() {
            FileDownloadManagerConsoleHelper.this.result = FileDownloadManagerConsoleHelper.this.fd.getResult();
        }

        @Override
        public void nextStep(String step_name, int step_no, int no_of_substeps) {
        }

        @Override
        public void setSubStepNo(int no_of_substeps) {
        }

        @Override
        public void progress(int substep_no, String message) {
            if (this.prevStep != substep_no) {
                this.prevStep = substep_no;
                if (substep_no == 100) {
                    System.out.println("\r" + message + FileDownloadManagerConsoleHelper.this.spaces);
                } else {
                    System.out.print("\r" + message + String.format(FileDownloadManagerConsoleHelper.this.cancelTip, substep_no));
                }
            }
        }
    }
}

