/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.CorrectWidthJTextField;
import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.JFocusPanel;
import com.izforge.izpack.panels.JTextMessagePane;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.UserInputFileFilter;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ErrorIzpackPathException;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.WarningIzpackPathException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileInputField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4673684743657328492L;
    InstallerFrame parentFrame;
    IzPanel parent;
    List<ValidatorContainer> validators;
    JTextField filetxt;
    JButton browseBtn;
    String set;
    int size;
    InstallData data;
    String fileExtension;
    String fileExtensionDescription;
    boolean allowEmpty;
    boolean userCancelled = false;
    boolean mustExist = true;
    protected static final int INVALID = 0;
    protected static final int EMPTY = 1;
    private boolean suppressDownload = false;
    private int maxMessageWidth;

    public FileInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig) {
        this(parent, data, directory, set, size, validatorConfig, null, null, true);
    }

    public FileInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, String fileExt, String fileExtDesc, boolean mustExist) {
        this.parent = parent;
        this.parentFrame = parent.getInstallerFrame();
        this.data = data;
        this.validators = validatorConfig;
        this.set = set;
        this.size = size;
        this.fileExtension = fileExt;
        this.fileExtensionDescription = fileExtDesc;
        this.mustExist = mustExist;
        this.suppressDownload = false;
        this.maxMessageWidth = data.guiPrefs.width - 175;
        this.initialize();
    }

    private void initialize() {
        this.filetxt = new CorrectWidthJTextField(this.set, this.size);
        this.filetxt.setCaretPosition(0);
        this.parent.loadFileChooserLang();
        this.browseBtn = ButtonFactory.createButton(this.data.langpack.getString("UserInputPanel.search.browse"));
        this.browseBtn.addActionListener(this);
        this.browseBtn.addFocusListener(new FocusListenerAutoScroll());
        JFocusPanel focusBorder = new JFocusPanel(this.filetxt);
        this.filetxt.addFocusListener(new FocusListenerRepaint());
        this.filetxt.addFocusListener(new FocusListenerAutoScroll());
        this.add(focusBorder);
        this.add(this.browseBtn);
    }

    public void setFile(String filename) {
        this.filetxt.setText(filename);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.browseBtn) {
            Debug.trace("Show dirchooser");
            String initialPath = ".";
            if (this.filetxt.getText() != null) {
                initialPath = this.filetxt.getText();
            }
            JFileChooser filechooser = new JFileChooser(initialPath);
            this.prepareFileChooser(filechooser);
            if (filechooser.showOpenDialog(this.parentFrame) == 0) {
                String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
                this.filetxt.setText(selectedFile);
                Debug.trace("Setting current file chooser directory to: " + selectedFile);
            }
        }
    }

    protected void prepareFileChooser(JFileChooser filechooser) {
        filechooser.setFileSelectionMode(0);
        if (this.fileExtension != null && this.fileExtensionDescription != null) {
            UserInputFileFilter fileFilter = new UserInputFileFilter();
            fileFilter.setFileExt(this.fileExtension);
            fileFilter.setFileExtDesc(this.fileExtensionDescription);
            filechooser.setFileFilter(fileFilter);
        }
    }

    public File getSelectedFile() {
        File result = null;
        if (this.filetxt.getText() != null) {
            result = new File(this.filetxt.getText());
        }
        return result;
    }

    protected void showMessage(int k) {
        if (k == 0) {
            this.showMessage("file.notfile");
        } else if (k == 1) {
            this.showMessage("file.nofile");
        }
    }

    protected void showMessage(String messageType) {
        this.parent.emitWarning(this.parentFrame.langpack.getString("UserInputPanel." + messageType + ".caption"), this.parentFrame.langpack.getString("UserInputPanel." + messageType + ".message"));
    }

    protected boolean runValidators(String input) {
        StringInputProcessingClient processingClient = new StringInputProcessingClient(input, this.validators);
        List<Validator.Status> success = processingClient.validate();
        if (success.contains((Object)Validator.Status.ERROR)) {
            JOptionPane.showMessageDialog(this.parentFrame, this.createJTextMessagePane(processingClient.getValidationMessage().get(0)), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 0);
        } else if (success.contains((Object)Validator.Status.WARNING)) {
            String warningMessages = processingClient.getValidationMessage().stream().collect(Collectors.joining("\n"));
            JOptionPane.showMessageDialog(this.parentFrame, this.createJTextMessagePane(warningMessages), this.parentFrame.langpack.getString("UserInputPanel.warning.caption"), 2);
        }
        return !success.contains((Object)Validator.Status.ERROR);
    }

    private void showError(String messageLangpackId, String titleLangpackId, String ... format) {
        String message = this.parentFrame.langpack.getString(messageLangpackId);
        String title = this.parentFrame.langpack.getString(titleLangpackId);
        if (format.length == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, this.createJTextMessagePane(message), title, 0);
        } else {
            JOptionPane.showMessageDialog(this.parentFrame, this.createJTextMessagePane(String.format(message, format)), title, 0);
        }
    }

    private boolean showWarning(String messageLangpackId, String titleLangpackId, String ... format) {
        String message = this.parentFrame.langpack.getString(messageLangpackId);
        String title = this.parentFrame.langpack.getString(titleLangpackId);
        int response = format.length == 0 ? JOptionPane.showConfirmDialog(this.parentFrame, this.createJTextMessagePane(message), title, 0) : JOptionPane.showConfirmDialog(this.parentFrame, this.createJTextMessagePane(String.format(message, format)), title, 0);
        return response == 0;
    }

    private JTextMessagePane createJTextMessagePane(String message) {
        return new JTextMessagePane(message, this.maxMessageWidth, this.getFontMetrics(this.getFont()));
    }

    public boolean validateField() {
        boolean result = false;
        String input = this.filetxt.getText();
        if (this.allowEmpty && (input == null || input.isEmpty())) {
            result = true;
        } else if (input != null) {
            if (input.startsWith("~")) {
                String home = System.getProperty("user.home");
                input = home + input.substring(1);
            }
            File file = new File(input).getAbsoluteFile();
            input = file.toString();
            this.filetxt.setText(input);
            try {
                if (!FileUtil.isPathValid(input)) {
                    this.showMessage(0);
                    return false;
                }
            }
            catch (WarningIzpackPathException wipe) {
                result = this.showWarning(wipe.getMessage(), "installer.warning", new String[0]);
                if (!result) {
                    return false;
                }
            }
            catch (ErrorIzpackPathException ipe) {
                this.showError(ipe.getMessage(), "installer.error", new String[0]);
                return false;
            }
            if (this.mustExist) {
                if (!this._validate(file)) {
                    result = false;
                    if (!this.userCancelled) {
                        this.showMessage(0);
                    }
                } else {
                    result = true;
                }
            } else {
                result = this.runValidators(input);
            }
        } else {
            this.showMessage(1);
        }
        return result;
    }

    protected boolean _validate(File file) {
        return file.isFile();
    }

    public void setAllowEmptyInput(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public boolean mustExist() {
        return this.mustExist;
    }

    public JTextField getField() {
        return this.filetxt;
    }

    public JButton getButton() {
        return this.browseBtn;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.filetxt.setEnabled(enabled);
        this.filetxt.setEditable(enabled);
        this.browseBtn.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.filetxt.isEnabled();
    }

    public void suppressDownload(boolean suppress) {
        this.suppressDownload = suppress;
    }

    public boolean isSuppressed() {
        return this.suppressDownload;
    }

    public String getInputText() {
        return this.filetxt.getText();
    }
}

