/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.CorrectWidthJTextArea;
import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.PanelFactory;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257282535107998009L;
    private static final String FILE_EXISTS = "FinishPanel.file.already.exists";
    private static final String FINISH = "FinishPanel.";
    private static final String LINK = ".link";
    private static final String LABEL = ".label";
    private static final String SHOW = ".show";
    private JButton autoButton;
    protected VariableSubstitutor vs;

    private static String getTranslation(InstallData idata, String text) {
        return idata.langpack.getString(text);
    }

    public FinishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new GridBagLayout());
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        this.parent.addDoneButton();
        this.buildUI();
        Log.getInstance().informUser();
    }

    private void buildUI() {
        if (this.idata.installSuccess) {
            this.buildSuccessfulUI();
        } else {
            this.buildFailureUI();
        }
    }

    private void buildFailureUI() {
        this.addTitle(this.getFailureTitle());
        this.addContentPanel(this.getFailureContentPanel());
    }

    private JPanel getFailureContentPanel() {
        JPanel failurePanel = PanelFactory.createContentPanel(true);
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        failurePanel.add((Component)this.getLogPathMessage(), gbc);
        return failurePanel;
    }

    private JPanel getLogPathMessage() {
        JPanel logPathPanel = new JPanel(new GridBagLayout());
        String logFilePath = this.idata.getInstallPath() + File.separator + this.idata.getVariable("installation.logfile");
        File normalizedLogFilePath = new File(logFilePath);
        logPathPanel.add(LabelFactory.create(this.parent.langpack.getString("See Installation Log at " + normalizedLogFilePath.getAbsolutePath()), 2));
        return logPathPanel;
    }

    private void buildSuccessfulUI() {
        this.addTitle(this.getSuccessTitle());
        this.addContentPanel(this.getSuccessContentPanel());
    }

    private void addContentPanel(JPanel content) {
        this.add((Component)content, GridBagConstraintsFactory.getContentPanelConstraints());
    }

    private JPanel getSuccessContentPanel() {
        JPanel successPanel = PanelFactory.createContentPanel(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        if (this.uninstallJarExists()) {
            gbc.weightx = 1.0;
            gbc.fill = 1;
            successPanel.add((Component)this.getUninstallerMessage(), gbc);
            ++gbc.gridy;
        }
        if (this.showLinks()) {
            successPanel.add((Component)this.getLinkPanel(), gbc);
            ++gbc.gridy;
        }
        gbc.fill = 0;
        gbc.weightx = gbc.weighty = (double)0;
        successPanel.add((Component)this.getAutoButton(), gbc);
        return successPanel;
    }

    private JPanel getAutoButton() {
        JPanel autoButtonPanel = new JPanel(new GridBagLayout());
        this.autoButton = ButtonFactory.createButton(this.parent.langpack.getString("FinishPanel.auto"));
        this.autoButton.setToolTipText(this.parent.langpack.getString("FinishPanel.auto.tip"));
        this.autoButton.addActionListener(this);
        this.autoButton.setActionCommand("Create auto.xml");
        AccessibleContext ac = this.autoButton.getAccessibleContext();
        ac.setAccessibleDescription("This JButton will create the auto.xml descriptor for future installations when pressed");
        this.parent.setFocus(this.autoButton);
        autoButtonPanel.add((Component)this.autoButton, GridBagConstraintsFactory.getBasicConstraints());
        return autoButtonPanel;
    }

    private boolean uninstallJarExists() {
        return this.idata.uninstallOutJar != null;
    }

    private boolean showLinks() {
        boolean showLinks = true;
        String linkFlag = this.idata.getVariable("FinishPanel.links.show");
        if (linkFlag == null || !linkFlag.equals("true")) {
            showLinks = false;
        }
        return showLinks;
    }

    private void addTitle(JLabel title) {
        this.add((Component)title, GridBagConstraintsFactory.getTitleConstraints(18));
    }

    public String[] getLinkIds() {
        String[] linkIds = null;
        String availableLinks = this.idata.getVariable("FinishPanel.links.list");
        if (availableLinks != null) {
            linkIds = availableLinks.split(",");
        }
        return linkIds;
    }

    private JPanel getLinkPanel() {
        JPanel linkPanel = new JPanel(new GridBagLayout());
        String[] linkIds = this.getLinkIds();
        if (this.showLinks() && linkIds != null) {
            linkPanel.add((Component)this.getLinkTitle(), GridBagConstraintsFactory.getTitleConstraints(18));
            boolean show = this.checkLinkConditions(linkIds);
            if (show) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 1;
                linkPanel.add((Component)this.getLinksPanel(linkIds), gbc);
            }
        }
        return linkPanel;
    }

    private JPanel getLinksPanel(String[] linkIds) {
        JPanel linksPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        for (String linkId : linkIds) {
            String condId = FINISH + linkId + SHOW;
            boolean linkCond = this.idata.getRules().isConditionTrue(this.idata.getVariable(condId));
            if (linkCond) {
                gbc.gridx = 0;
                String storedValue = this.idata.langpack.getString(FINISH + linkId + LABEL);
                JLabel label = LabelFactory.create(storedValue);
                linksPanel.add((Component)label, gbc);
                JLabel link = new JLabel(this.idata.langpack.getString(FINISH + linkId + LINK));
                gbc.gridx = 1;
                linksPanel.add((Component)link, gbc);
                gbc.gridx = 2;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                linksPanel.add(Box.createGlue(), gbc);
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
            }
            ++gbc.gridy;
        }
        return linksPanel;
    }

    private boolean checkLinkConditions(String[] linkIds) {
        for (String linkId : linkIds) {
            String condId = FINISH + linkId + SHOW;
            boolean linkCond = this.idata.getRules().isConditionTrue(this.idata.getVariable(condId));
            if (!linkCond) continue;
            return true;
        }
        return false;
    }

    public JLabel getLinkTitle() {
        JLabel linkTitle = LabelFactory.create(this.idata.langpack.getString("FinishPanel.link.header"), 2);
        linkTitle.setFont(FontResources.getOpenSansLight().deriveFont(16.0f));
        return linkTitle;
    }

    private JLabel getSuccessTitle() {
        JLabel successTitle = LabelFactory.createTitleLabel(this.idata.langpack.getString("FinishPanel.success"), false);
        return successTitle;
    }

    private JLabel getFailureTitle() {
        JLabel failureTitle = LabelFactory.createTitleLabel(this.idata.langpack.getString("FinishPanel.fail"), false);
        failureTitle.setForeground(Color.RED);
        return failureTitle;
    }

    private JPanel getUninstallerMessage() {
        JPanel uninstallerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        String path = this.translatePath(this.idata.info.getUninstallerPath());
        JLabel uninstallerInfo = LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), 2);
        uninstallerPanel.add((Component)uninstallerInfo, gbc);
        ++gbc.gridy;
        CorrectWidthJTextArea pathLabel = new CorrectWidthJTextArea();
        pathLabel.setFocusable(false);
        pathLabel.setEditable(false);
        pathLabel.setBackground(null);
        pathLabel.setLineWrap(true);
        pathLabel.setWrapStyleWord(true);
        pathLabel.setText(path);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        uninstallerPanel.add((Component)pathLabel, gbc);
        return uninstallerPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        this.loadFileChooserLang();
        fc.setCurrentDirectory(new File(this.idata.getInstallPath()));
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Save");
        FileNameExtensionFilter xmlfilter = new FileNameExtensionFilter("XML File (.xml)", "xml");
        fc.setFileFilter(xmlfilter);
        try {
            if (fc.showSaveDialog(this) == 0) {
                File file = fc.getSelectedFile();
                if (fc.getFileFilter().equals(xmlfilter) && !file.getPath().endsWith(".xml")) {
                    file = new File(file.getPath() + ".xml");
                }
                int res = 0;
                if (file.exists()) {
                    res = this.askQuestion(this.parent.langpack.getString("installer.warning"), FinishPanel.getTranslation(this.idata, FILE_EXISTS), 37, 47);
                }
                if (!file.exists() || file.exists() && res == 47) {
                    FileOutputStream out = new FileOutputStream(file);
                    BufferedOutputStream outBuff = new BufferedOutputStream(out, 5120);
                    this.parent.writeXMLTree(this.idata.xmlData, outBuff);
                    outBuff.flush();
                    outBuff.close();
                    file.setWritable(false, false);
                    file.setReadable(false, false);
                    file.setWritable(true, true);
                    file.setReadable(true, true);
                    this.autoButton.setEnabled(false);
                    String buttonSuccessText = this.parent.langpack.getString("FinishPanel.auto.generate.success");
                    if (buttonSuccessText != null && !buttonSuccessText.equals("FinishPanel.auto.generate.success")) {
                        this.autoButton.setText(buttonSuccessText);
                    }
                    FinishPanel.outputVariableFile(file);
                }
            }
        }
        catch (Exception err) {
            Debug.trace(err);
            this.emitError(this.parent.langpack.getString("installer.error"), err.toString());
        }
    }

    protected static void outputVariableFile(File file) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (!idata.autoPromptVars.isEmpty()) {
            String propsFilePath = file.getPath() + ".variables";
            File propsFile = null;
            do {
                if (!(propsFile = new File(propsFilePath)).exists()) continue;
                propsFilePath = propsFilePath + "1";
            } while (propsFile.exists());
            PrintWriter propsOut = null;
            try {
                propsOut = new PrintWriter(new FileWriter(propsFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (String variable : idata.autoPromptVars) {
                propsOut.println(variable + "=");
            }
            propsOut.close();
        }
    }

    protected String translatePath(String destination) {
        destination = this.vs.substitute(destination, null);
        return destination.replace('/', File.separatorChar);
    }
}

