/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.FinishPanel;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;

public class FinishPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static final String SUCCESS = "FinishPanel.success";
    private static final String FAIL = "FinishPanel.fail";
    private static final String AUTO_PATH = "FinishPanel.autoxml.info";
    private static final String INSTALL = "FinishPanel.install";
    private static final String AUTO_INSTALL = "FinishPanel.automatic.install";
    private static final String AUTO_WARN = "FinishPanel.automatic.warning";
    private static final String DIRECTORY = "FinishPanel.directory";
    private static final String FILE_EXISTS = "FinishPanel.file.already.exists";
    private static final String FILE_UNWRITE = "FinishPanel.file.cannot.write";
    private static final String AUTO_SUCCESS = "FinishPanel.xml.success";
    private static final String AUTO_NO_SUCCESS = "FinishPanel.xml.no.success";

    private static String getTranslation(AutomatedInstallData idata, String text) {
        return idata.langpack.getString(text);
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return true;
    }

    private String read() throws Exception {
        byte[] byteArray = new byte[]{(byte)System.in.read()};
        return new String(byteArray);
    }

    private String readln() throws Exception {
        String input = this.read();
        int available = System.in.available();
        if (available > 0) {
            byte[] byteArray = new byte[available];
            System.in.read(byteArray);
            input = input + new String(byteArray);
        }
        return input.trim();
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata, ConsoleInstaller parent) {
        if (idata.installSuccess) {
            System.out.println(FinishPanelConsoleHelper.getTranslation(idata, SUCCESS));
            System.out.println(FinishPanelConsoleHelper.getTranslation(idata, INSTALL) + " " + idata.getInstallPath());
            System.out.println();
            int value = PanelConsoleHelper.askYesNo(FinishPanelConsoleHelper.getTranslation(idata, AUTO_INSTALL), false);
            if (value == 47) {
                if (idata.getVariable("jdbc.driver.install") != null && idata.getVariable("jdbc.driver.install").equals("on")) {
                    System.out.println(FinishPanelConsoleHelper.getTranslation(idata, AUTO_WARN));
                }
                File path = null;
                while (true) {
                    String strTargetPath = "";
                    String defaultFile = idata.getInstallPath() + File.separator + "auto.xml";
                    System.out.println(FinishPanelConsoleHelper.getTranslation(idata, AUTO_PATH) + " [" + defaultFile + "] ");
                    try {
                        String strIn = AeshReadlineConsole.readFile(false);
                        strTargetPath = !strIn.isEmpty() ? strIn : defaultFile;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
                    strTargetPath = vs.substitute(strTargetPath, null);
                    path = new File(IoHelper.expandHomePath(strTargetPath));
                    String parentPath = path.getAbsoluteFile().getParent();
                    Path autoParent = parentPath != null ? FileSystems.getDefault().getPath(parentPath, new String[0]) : null;
                    boolean failure = false;
                    if (path.isDirectory() || parentPath == null) {
                        System.out.println(FinishPanelConsoleHelper.getTranslation(idata, DIRECTORY));
                        failure = true;
                    } else if (path.exists()) {
                        value = PanelConsoleHelper.askYesNo(FinishPanelConsoleHelper.getTranslation(idata, FILE_EXISTS) + " ", false);
                        if (value == 47) {
                            if (!Files.isWritable(FileSystems.getDefault().getPath(strTargetPath, new String[0]))) {
                                System.out.println(FinishPanelConsoleHelper.getTranslation(idata, FILE_UNWRITE));
                                failure = true;
                            }
                        } else {
                            failure = true;
                        }
                    } else if (!Files.isWritable(autoParent)) {
                        System.out.println(FinishPanelConsoleHelper.getTranslation(idata, FILE_UNWRITE));
                        failure = true;
                    }
                    if (path == null || failure) continue;
                    try {
                        FileOutputStream out = new FileOutputStream(path);
                        BufferedOutputStream outBuff = new BufferedOutputStream(out, 5120);
                        parent.writeXMLTree(idata.xmlData, outBuff);
                        outBuff.flush();
                        outBuff.close();
                        path.setWritable(false, false);
                        path.setReadable(false, false);
                        path.setWritable(true, true);
                        path.setReadable(true, true);
                        FinishPanel.outputVariableFile(path);
                        System.out.println(FinishPanelConsoleHelper.getTranslation(idata, AUTO_SUCCESS));
                    }
                    catch (Exception e) {
                        System.out.println(FinishPanelConsoleHelper.getTranslation(idata, AUTO_NO_SUCCESS));
                        Debug.trace(e);
                        continue;
                    }
                    break;
                }
            }
        } else {
            System.out.println(FinishPanelConsoleHelper.getTranslation(idata, FAIL));
        }
        return true;
    }
}

