/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FontResources;
import com.izforge.izpack.gui.GridBagConstraintsFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.PanelFactory;
import com.izforge.izpack.gui.ScrollPaneFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLLicencePanel
extends IzPanel
implements HyperlinkListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 3256728385458746416L;
    private JEditorPane textArea;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;
    final ButtonGroup group = new ButtonGroup();

    public HTMLLicencePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new GridBagLayout());
        this.buildUI();
    }

    private void setFocus() {
        Enumeration<AbstractButton> buttons = this.group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            this.setInitialFocus(button);
            return;
        }
        this.setInitialFocus(this.noRadio);
    }

    private void buildUI() {
        this.add((Component)this.getTitle(), GridBagConstraintsFactory.getTitleConstraints());
        this.addScroller();
        this.addButtons();
    }

    private void addButtons() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 2;
        this.add((Component)this.getRadioButtons(), gbc);
    }

    private void addScroller() {
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        gbc.gridy = 1;
        gbc.insets.right = 10;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this.getLicenceScroller(), gbc);
    }

    private JPanel getRadioButtons() {
        JPanel buttonPanel = PanelFactory.createRadioButtonPanel(!this.parent.hasBackground, this.group);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        Box verticalBox = Box.createVerticalBox();
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        this.yesRadio = new JRadioButton(this.parent.langpack.getString("LicencePanel.agree"), false);
        this.yesRadio.setOpaque(!this.parent.hasBackground);
        this.yesRadio.setFont(FontResources.getOpenSansRegular());
        this.group.add(this.yesRadio);
        verticalBox.add((Component)this.yesRadio, gbc);
        ++gbc.gridy;
        this.yesRadio.addFocusListener(this);
        this.noRadio = new JRadioButton(this.parent.langpack.getString("LicencePanel.notagree"), true);
        this.noRadio.setOpaque(!this.parent.hasBackground);
        this.noRadio.setFont(FontResources.getOpenSansRegular());
        this.group.add(this.noRadio);
        verticalBox.add((Component)this.noRadio, gbc);
        this.noRadio.addFocusListener(this);
        buttonPanel.add(verticalBox);
        AccessibleContext ac = this.yesRadio.getAccessibleContext();
        ac.setAccessibleDescription("JRadioButton to accept the licence agreement");
        this.yesRadio.setActionCommand("Selected =  Accept the licence agreement");
        ac = this.yesRadio.getAccessibleContext();
        ac.setAccessibleDescription("JRadioButton to reject the licence agreement");
        this.noRadio.setActionCommand("Selected = Reject the licence agreement");
        return buttonPanel;
    }

    private Component getLicenceScroller() {
        JScrollPane scroller = null;
        try {
            this.textArea = new JEditorPane();
            this.textArea.setFont(FontResources.getOpenSansRegular());
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            scroller = ScrollPaneFactory.createScroller(this.textArea);
            scroller.setFocusable(true);
            this.textArea.setPage(this.loadLicence());
            this.textArea.setFocusable(false);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return scroller;
    }

    private JLabel getTitle() {
        JLabel title = LabelFactory.createTitleLabel(this.idata.langpack.getString("HTMLLicencePanel.headline"), !this.parent.hasBackground);
        return title;
    }

    private URL loadLicence() {
        String resNamePrifix = "HTMLLicencePanel.licence";
        try {
            return ResourceManager.getInstance().getURL(resNamePrifix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    @Override
    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception f) {
                    this.textArea.setPage(e.getURL());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
        this.setFocus();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JRadioButton b = (JRadioButton)focusEvent.getComponent();
        b.doClick();
        if (focusEvent.getComponent() == this.yesRadio) {
            this.parent.unlockNextButton(false);
        }
        if (focusEvent.getComponent() == this.noRadio) {
            this.parent.lockNextButton();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

