/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.AeshReadlineConsole;
import com.izforge.izpack.util.StringTool;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;

public class HTMLLicencePanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static final String CONSOLE_ASK = "console.ask";
    private static final String LICENCE_ERROR = "HTMLLicence.Error";
    private static final String CONTINUE = "HTMLLicence.continue";

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata, ConsoleInstaller parent) {
        String license = null;
        String resNamePrefix = "HTMLLicencePanel.licence";
        try {
            license = ResourceManager.getInstance().getTextResource(resNamePrefix);
        }
        catch (Exception err) {
            license = idata.langpack.getString(LICENCE_ERROR) + " " + resNamePrefix;
            System.out.println(license);
            return false;
        }
        int lines = 25;
        int l = 0;
        String strippedHTML = StringTool.removeHTML(license);
        StringTokenizer st = new StringTokenizer(strippedHTML, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            System.out.println(token);
            if (++l < lines) continue;
            if (!this.doContinue(idata)) {
                return false;
            }
            l = 0;
        }
        int i = this.askToAcceptLicense(idata);
        if (i == 1) {
            return true;
        }
        if (i == 2) {
            return false;
        }
        return this.runConsole(idata, parent);
    }

    private boolean doContinue(AutomatedInstallData idata) {
        System.out.println("\r");
        System.out.println(idata.langpack.getString(CONTINUE));
        String strIn = AeshReadlineConsole.readLine();
        return !strIn.equalsIgnoreCase("x");
    }

    private int askToAcceptLicense(AutomatedInstallData idata) {
        String strIn;
        String consoleAsk = idata.langpack.getString(CONSOLE_ASK);
        do {
            System.out.println(consoleAsk);
            strIn = AeshReadlineConsole.readLine();
            System.out.println("");
            if (strIn.equals("1")) {
                return 1;
            }
            if (!strIn.equals("2")) continue;
            return 2;
        } while (!strIn.equals("3"));
        return 3;
    }
}

